/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.parameter;

import dev.faultyfunctions.soulgraves.libs.lamp.Lamp;
import dev.faultyfunctions.soulgraves.libs.lamp.annotation.Range;
import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.NumberNotInRangeException;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ParameterNode;
import dev.faultyfunctions.soulgraves.libs.lamp.process.ParameterValidator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum RangeChecker implements ParameterValidator<CommandActor, Number>
{
    INSTANCE;


    @Override
    public void validate(@NotNull CommandActor actor, Number value, @NotNull ParameterNode<CommandActor, Number> parameter, @NotNull Lamp<CommandActor> lamp) {
        Range range = parameter.annotations().get(Range.class);
        if (range == null) {
            return;
        }
        if (value == null) {
            return;
        }
        if (value.doubleValue() > range.max() || value.doubleValue() < range.min()) {
            throw new NumberNotInRangeException(value, range.min(), range.max());
        }
    }
}

