/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.parameter;

import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ExecutionContext;
import dev.faultyfunctions.soulgraves.libs.lamp.parameter.ParameterType;
import dev.faultyfunctions.soulgraves.libs.lamp.parameter.PrioritySpec;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.MutableStringStream;
import org.jetbrains.annotations.NotNull;

public final class StringParameterType
implements ParameterType<CommandActor, String> {
    private static final StringParameterType GREEDY = new StringParameterType(true);
    private static final StringParameterType SINGLE = new StringParameterType(false);
    private final boolean greedy;

    private StringParameterType(boolean greedy) {
        this.greedy = greedy;
    }

    @NotNull
    public static <A extends CommandActor> ParameterType<A, String> greedy() {
        return GREEDY;
    }

    @NotNull
    public static <A extends CommandActor> ParameterType<A, String> single() {
        return SINGLE;
    }

    @Override
    public String parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<CommandActor> context) {
        if (input.peek() == '\"' || !this.greedy) {
            return input.readString();
        }
        return input.consumeRemaining();
    }

    @Override
    public boolean isGreedy() {
        return this.greedy;
    }

    @Override
    @NotNull
    public PrioritySpec parsePriority() {
        return PrioritySpec.lowest();
    }
}

