/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.parameter.builtins;

import dev.faultyfunctions.soulgraves.libs.lamp.Lamp;
import dev.faultyfunctions.soulgraves.libs.lamp.annotation.Values;
import dev.faultyfunctions.soulgraves.libs.lamp.annotation.list.AnnotationList;
import dev.faultyfunctions.soulgraves.libs.lamp.autocomplete.SuggestionProvider;
import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.ValueNotAllowedException;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ExecutionContext;
import dev.faultyfunctions.soulgraves.libs.lamp.parameter.ParameterType;
import dev.faultyfunctions.soulgraves.libs.lamp.parameter.PrioritySpec;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.MutableStringStream;
import dev.faultyfunctions.soulgraves.libs.lamp.util.Collections;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum ValuesParameterTypeFactory implements ParameterType.Factory<CommandActor>
{
    INSTANCE;


    @Override
    public <T> ParameterType<CommandActor, T> create(@NotNull Type parameterType, @NotNull AnnotationList annotations, @NotNull Lamp<CommandActor> lamp) {
        List<String> allowed;
        final Values values2 = annotations.get(Values.class);
        if (values2 == null) {
            return null;
        }
        final ParameterType delegate = lamp.findNextResolver(parameterType, annotations, this).requireParameterType();
        List<String> list = allowed = values2.caseSensitive() ? Arrays.asList(values2.value()) : Collections.map(values2.value(), String::toUpperCase);
        if (allowed.isEmpty()) {
            throw new IllegalArgumentException("@Values() must contain at least 1 value!");
        }
        return new ParameterType<CommandActor, T>(){

            @Override
            public T parse(@NotNull MutableStringStream input, @NotNull @NotNull ExecutionContext<@NotNull CommandActor> context) {
                int start = input.position();
                Object value = delegate.parse(input, context);
                int end = input.position();
                input.setPosition(start);
                String consumed = input.peek(end - start);
                input.setPosition(end);
                if (values2.caseSensitive() && allowed.contains(consumed) || !values2.caseSensitive() && allowed.contains(consumed.toUpperCase())) {
                    return value;
                }
                throw new ValueNotAllowedException(consumed, Arrays.asList(values2.value()), values2.caseSensitive());
            }

            @Override
            @NotNull
            public @NotNull SuggestionProvider<@NotNull CommandActor> defaultSuggestions() {
                return SuggestionProvider.of(values2.value());
            }

            @Override
            @NotNull
            public PrioritySpec parsePriority() {
                return PrioritySpec.highest();
            }
        };
    }
}

