/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.response;

import dev.faultyfunctions.soulgraves.libs.lamp.Lamp;
import dev.faultyfunctions.soulgraves.libs.lamp.annotation.list.AnnotationList;
import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.context.ErrorContext;
import dev.faultyfunctions.soulgraves.libs.lamp.response.ResponseHandler;
import dev.faultyfunctions.soulgraves.libs.lamp.util.Classes;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CompletionStageResponseHandler implements ResponseHandler.Factory<CommandActor>
{
    INSTANCE;


    @Override
    @Nullable
    public <T> ResponseHandler<CommandActor, T> create(@NotNull Type type, @NotNull AnnotationList annotations, @NotNull Lamp<CommandActor> lamp) {
        Class<?> rawType = Classes.getRawType(type);
        if (rawType != CompletionStage.class && rawType != CompletableFuture.class) {
            return null;
        }
        Type suppliedType = Classes.getFirstGeneric(type, Object.class);
        ResponseHandler delegate = lamp.responseHandler(suppliedType, AnnotationList.empty());
        return (response, context) -> {
            CompletionStage future = (CompletionStage)response;
            future.whenComplete((o, throwable) -> {
                if (throwable != null) {
                    lamp.handleException((Throwable)throwable, ErrorContext.executingFunction(context));
                } else {
                    delegate.handleResponse(o, context);
                }
            });
        };
    }
}

