/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.stream.token;

import dev.faultyfunctions.soulgraves.libs.lamp.stream.MutableStringStream;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.token.LiteralToken;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.token.ParameterToken;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.token.Token;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TokenParser {
    @Contract(mutates="param1")
    @NotNull
    public static Token parseNextToken(@NotNull MutableStringStream stream) {
        if (stream.peek() == '<') {
            stream.moveForward();
            String name = stream.readUntil('>');
            if (name.isEmpty()) {
                throw new ParseException("Cannot have <> for an argument name!");
            }
            return new ParameterToken(name);
        }
        String name = stream.readUnquotedString();
        return new LiteralToken(name);
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message) {
            super(message);
        }
    }
}

