/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag;

import dev.faultyfunctions.soulgraves.libs.rtag.RtagDeserializer;
import dev.faultyfunctions.soulgraves.libs.rtag.RtagMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.RtagSerializer;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import dev.faultyfunctions.soulgraves.libs.rtag.util.EasyLookup;
import dev.faultyfunctions.soulgraves.libs.rtag.util.OptionalType;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ThrowableFunction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;

public class Rtag
extends RtagMirror {
    private static final BiPredicate<Integer, Object[]> addPredicate = (index, path) -> ((Object[])path).length == index || path[index] instanceof Integer;
    private static final BiPredicate<Integer, Object[]> setPredicate = (index, path) -> ((Object[])path).length > index && path[index] instanceof Integer;
    public static final Rtag INSTANCE = new Rtag();
    @ApiStatus.Experimental
    public static final Object UNIT;
    private static final Object REGISTRY;
    private final Map<String, RtagDeserializer<Object>> deserializers = new HashMap<String, RtagDeserializer<Object>>();
    private final Map<Class<?>, RtagSerializer<Object>> serializers = new HashMap();

    @ApiStatus.Experimental
    public static Object getMinecraftRegistry() {
        return REGISTRY;
    }

    public Rtag() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public Rtag(RtagMirror mirror) {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public RtagMirror getMirror() {
        return this;
    }

    public <T> Rtag putDeserializer(RtagDeserializer<T> deserializer) {
        this.deserializers.put(deserializer.getOutID(), deserializer);
        return this;
    }

    public <T> Rtag putSerializer(Class<T> type, RtagSerializer<T> serializer) {
        this.serializers.put(type, serializer);
        return this;
    }

    public boolean add(Object tag, Object value, Object ... path) {
        Object valueTag;
        if (path.length == 0) {
            return false;
        }
        Object finalTag = this.getExactOrCreate(tag, path, addPredicate);
        if (TAG_LIST.isInstance(finalTag) && (valueTag = this.newTag(value)) != null) {
            TagList.add(finalTag, valueTag);
            return true;
        }
        return false;
    }

    public boolean set(Object tag, Object value, Object ... path) {
        if (path.length == 0) {
            return false;
        }
        int last = path.length - 1;
        Object finalTag = this.getExactOrCreate(tag, Arrays.copyOf(path, last), value == null ? null : setPredicate);
        if (finalTag == null) {
            return false;
        }
        if (value == null) {
            return this.removeExact(finalTag, path[last]);
        }
        return this.setExact(finalTag, value, path[last]);
    }

    public boolean setExact(Object tag, Object value, Object key) {
        Object valueTag;
        if (key instanceof Integer && TAG_LIST.isInstance(tag)) {
            Object valueTag2 = this.newTag(value);
            if (valueTag2 != null) {
                TagList.set(tag, (Integer)key, valueTag2);
                return true;
            }
        } else if (TAG_COMPOUND.isInstance(tag) && (valueTag = this.newTag(value)) != null) {
            TagCompound.set(tag, String.valueOf(key), valueTag);
            return true;
        }
        return false;
    }

    public boolean merge(Object tag, Object value, boolean replace, Object ... path) {
        return this.getExactOrCreate(tag, path, setPredicate, finalTag -> TagCompound.merge(finalTag, this.newTag(value), replace));
    }

    public boolean deepMerge(Object tag, Object value, boolean replace, Object ... path) {
        return this.getExactOrCreate(tag, path, setPredicate, finalTag -> TagCompound.merge(finalTag, this.newTag(value), replace, true));
    }

    public boolean move(Object tag, Object[] from, Object[] to) {
        return this.move(tag, from, to, true);
    }

    public boolean move(Object tag, Object[] from, Object[] to, boolean clear) {
        Object value = this.getExact(tag, from);
        if (value == null) {
            return false;
        }
        boolean result = this.set(tag, value, to);
        if (!result) {
            return false;
        }
        if (clear && from.length > 1) {
            Object[] copy;
            int size;
            Object[] path = from;
            for (int i = 1; i < from.length && (size = TagBase.size(this.getExact(tag, copy = Arrays.copyOf(from, from.length - i)))) >= 0 && size <= 1; ++i) {
                path = copy;
            }
            this.set(tag, null, path);
        } else {
            this.set(tag, null, from);
        }
        return true;
    }

    public boolean removeExact(Object tag, Object key) {
        if (key instanceof Integer && TAG_LIST.isInstance(tag)) {
            TagList.remove(tag, (Integer)key);
        } else if (TAG_COMPOUND.isInstance(tag)) {
            TagCompound.remove(tag, String.valueOf(key));
        } else {
            return false;
        }
        return true;
    }

    public <T> T get(Object tag, Object ... path) {
        return OptionalType.cast(this.getTagValue(this.getExact(tag, path)));
    }

    public OptionalType getOptional(Object tag, Object ... path) {
        return OptionalType.of(this.getTagValue(this.getExact(tag, path)));
    }

    public Object getExact(Object tag, Object ... path) {
        return this.getExactOrCreate(tag, path, null);
    }

    public Object getExactOrCreate(Object tag, Object[] path, BiPredicate<Integer, Object[]> listPredicate) {
        Object finalTag = tag;
        for (int i = 0; i < path.length; ++i) {
            Object key = path[i];
            if (key instanceof ThrowableFunction) {
                try {
                    finalTag = ((ThrowableFunction)key).apply(finalTag);
                }
                catch (Throwable t) {
                    return null;
                }
                if (finalTag != null) continue;
                return null;
            }
            if (key instanceof Integer && TAG_LIST.isInstance(finalTag)) {
                if ((Integer)key >= 0 ? TagList.size(finalTag) > (Integer)key : TagList.size(finalTag) >= Math.abs((Integer)key)) {
                    finalTag = TagList.get(finalTag, (Integer)key);
                    continue;
                }
                return null;
            }
            if (TAG_COMPOUND.isInstance(finalTag)) {
                String keyString = String.valueOf(key);
                if (listPredicate != null && TagCompound.notHasKey(finalTag, keyString)) {
                    TagCompound.set(finalTag, keyString, listPredicate.test(i + 1, path) ? TagList.newTag() : TagCompound.newTag());
                }
                if ((finalTag = TagCompound.get(finalTag, keyString)) != null) continue;
                return null;
            }
            return null;
        }
        return finalTag;
    }

    public boolean getExactOrCreate(Object tag, Object[] path, BiPredicate<Integer, Object[]> listPredicate, Predicate<Object> predicate) {
        Object finalTag = this.getExactOrCreate(tag, path, listPredicate);
        if (finalTag == null) {
            return false;
        }
        return predicate.test(finalTag);
    }

    @Override
    public Object getTagValue(Object tag) {
        Object type;
        Object object = super.getTagValue(tag);
        if (object instanceof Map && (type = ((Map)object).get("rtag==")) instanceof String && this.deserializers.containsKey((String)type)) {
            return this.deserializers.get((String)type).deserialize((Map)object);
        }
        return object;
    }

    @Override
    public Object newTag(Object object) {
        if (object == null) {
            return null;
        }
        if (this.serializers.containsKey(object.getClass())) {
            RtagSerializer<Object> serializer = this.serializers.get(object.getClass());
            Map<String, Object> map = serializer.serialize(object);
            map.put("rtag==", serializer.getInID());
            return this.newTag(map);
        }
        return super.newTag(object);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public Object toTag(Object object) {
        return this.newTag(object);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public <T> T fromTag(Object tag) {
        return OptionalType.cast(this.getTagValue(tag));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public Object fromTagExact(Object tag) {
        return this.getTagValue(tag);
    }

    static {
        Object unit = new Object();
        Object registry = null;
        if (ServerInstance.MAJOR_VERSION >= 14) {
            try {
                unit = ((Object[])EasyLookup.addNMSClass("util.Unit").getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0]))[0];
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (ServerInstance.MAJOR_VERSION >= 20) {
                try {
                    registry = EasyLookup.addOBCClass("CraftRegistry").getDeclaredMethod("getMinecraftRegistry", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        UNIT = unit;
        REGISTRY = registry;
    }
}

