/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import dev.faultyfunctions.soulgraves.libs.rtag.Rtag;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.util.EasyLookup;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ComponentType {
    private static final Class<?> COMPONENT_TYPE;
    private static final Class<?> REGISTRY_OPS_TYPE;
    private static final Map<String, Object> TYPES;
    private static final Map<String, Codec<Object>> CODECS;
    @ApiStatus.Experimental
    public static final Object NBT_OPS;
    @ApiStatus.Experimental
    public static final Object JAVA_OPS;
    private static final MethodHandle CREATE;
    private static final MethodHandle CODEC;
    private static DynamicOps<Object> REGISTRY_NBT_OPS;
    private static DynamicOps<JsonElement> REGISTRY_JSON_OPS;
    private static DynamicOps<Object> REGISTRY_JAVA_OPS;

    ComponentType() {
    }

    public static Object of(Object type) {
        if (COMPONENT_TYPE.isInstance(type)) {
            return type;
        }
        return ComponentType.of(String.valueOf(type));
    }

    public static Object of(String name) {
        return TYPES.get(ComponentType.key(name));
    }

    public static Map<String, Object> all() {
        return Collections.unmodifiableMap(TYPES);
    }

    public static Codec<Object> codec(Object type) {
        if (COMPONENT_TYPE.isInstance(type)) {
            try {
                return CODEC.invoke(type);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot get codec from component type", t);
            }
        }
        return ComponentType.codec(String.valueOf(type));
    }

    public static Codec<Object> codec(String name) {
        return CODECS.get(ComponentType.key(name));
    }

    public static String key(String name) {
        if (name.startsWith("minecraft:") || name.contains(":")) {
            return name;
        }
        return "minecraft:" + name;
    }

    public static boolean isType(Object object) {
        return COMPONENT_TYPE.isInstance(object);
    }

    public static boolean exists(String name) {
        return TYPES.containsKey(ComponentType.key(name));
    }

    @ApiStatus.Internal
    public static <T> T createGlobalContext(Object dynamicOps) {
        if (REGISTRY_OPS_TYPE.isInstance(dynamicOps)) {
            return (T)dynamicOps;
        }
        try {
            return (T)CREATE.invoke(dynamicOps, Rtag.getMinecraftRegistry());
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create serialization context", e);
        }
    }

    public static Optional<Object> parse(Object type, Object object) {
        if (TagBase.isTag(object)) {
            return ComponentType.parseNbt(type, object);
        }
        if (object instanceof JsonElement) {
            return ComponentType.parseJson(type, (JsonElement)object);
        }
        return ComponentType.parseJava(type, object);
    }

    public static <T> Optional<Object> parse(Object type, DynamicOps<T> dynamicOps, T object) {
        Codec<Object> codec = ComponentType.codec(type);
        if (codec == null) {
            return Optional.empty();
        }
        try {
            DataResult dataResult = codec.parse((DynamicOps)ComponentType.createGlobalContext(dynamicOps), object);
            if (dataResult.isError()) {
                throw new IllegalArgumentException("" + dataResult);
            }
            return dataResult.result();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot parse component" + (String)(type instanceof String ? " '" + type + "'" : ""), t);
        }
    }

    public static Optional<Object> parseNbt(Object type, Object nbt) {
        return ComponentType.parse(type, REGISTRY_NBT_OPS, nbt);
    }

    public static Optional<Object> parseJson(Object type, JsonElement json) {
        return ComponentType.parse(type, REGISTRY_JSON_OPS, json);
    }

    public static Optional<Object> parseJava(Object type, Object object) {
        return ComponentType.parse(type, REGISTRY_JAVA_OPS, object);
    }

    public static <T> Optional<T> encode(Object type, DynamicOps<T> dynamicOps, Object component) {
        if (component == null) {
            return Optional.empty();
        }
        Codec<Object> codec = ComponentType.codec(type);
        if (codec == null) {
            return Optional.empty();
        }
        try {
            DataResult dataResult = codec.encodeStart((DynamicOps)ComponentType.createGlobalContext(dynamicOps), component);
            if (dataResult.isError()) {
                throw new IllegalArgumentException("" + dataResult);
            }
            return dataResult.result();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot encode component" + (String)(type instanceof String ? " '" + type + "'" : ""), t);
        }
    }

    public static Optional<Object> encodeNbt(Object type, Object component) {
        return ComponentType.encode(type, REGISTRY_NBT_OPS, component);
    }

    public static Optional<JsonElement> encodeJson(Object type, Object component) {
        return ComponentType.encode(type, REGISTRY_JSON_OPS, component);
    }

    public static Optional<Object> encodeJava(Object type, Object component) {
        return ComponentType.encode(type, REGISTRY_JAVA_OPS, component);
    }

    static {
        try {
            if (ServerInstance.MAJOR_VERSION >= 13) {
                EasyLookup.addNMSClass("nbt.DynamicOpsNBT", "NbtOps");
            }
            if (ServerInstance.VERSION >= 18.02f) {
                EasyLookup.addNMSClass("resources.RegistryOps");
            }
            if (ServerInstance.Release.COMPONENT) {
                EasyLookup.addNMSClass("core.Holder");
                EasyLookup.addNMSClass("core.RegistryMaterials", "MappedRegistry");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        COMPONENT_TYPE = EasyLookup.classById("DataComponentType");
        REGISTRY_OPS_TYPE = EasyLookup.classById("RegistryOps");
        TYPES = new HashMap<String, Object>();
        CODECS = new HashMap<String, Codec<Object>>();
        JAVA_OPS = JavaOps.INSTANCE;
        DynamicOps nbtOps = null;
        MethodHandle method$create = null;
        MethodHandle method$codec = null;
        if (ServerInstance.Release.COMPONENT) {
            try {
                String nbtOps$instance = "a";
                String registry$create = "a";
                String registry$components = "as";
                String registry$map = "f";
                String resource$key = "a";
                String holder$value = "a";
                String codec = "b";
                if (ServerInstance.Type.MOJANG_MAPPED) {
                    nbtOps$instance = "INSTANCE";
                    registry$create = "create";
                    registry$components = "DATA_COMPONENT_TYPE";
                    registry$map = "byLocation";
                    resource$key = "getPath";
                    holder$value = "value";
                    codec = "codec";
                } else {
                    if (ServerInstance.MAJOR_VERSION >= 21) {
                        registry$components = "aq";
                    }
                    if (ServerInstance.VERSION >= 21.02f) {
                        registry$components = "ao";
                        registry$map = "e";
                    }
                    if (ServerInstance.VERSION >= 21.04f) {
                        registry$components = "am";
                    }
                }
                nbtOps = (DynamicOps)EasyLookup.classById("DynamicOpsNBT").getDeclaredField(nbtOps$instance).get(null);
                method$create = EasyLookup.staticMethod("RegistryOps", registry$create, "RegistryOps", DynamicOps.class, "HolderLookup.Provider");
                Object componentsRegistry = EasyLookup.classById("BuiltInRegistries").getDeclaredField(registry$components).get(null);
                Map componentsMap = (Map)EasyLookup.field("RegistryMaterials", registry$map).get(componentsRegistry);
                Method keyMethod = EasyLookup.classById("MinecraftKey").getDeclaredMethod(resource$key, new Class[0]);
                Method valueMethod = EasyLookup.classById("Holder").getDeclaredMethod(holder$value, new Class[0]);
                Method codecMethod = EasyLookup.classById("DataComponentType").getDeclaredMethod(codec, new Class[0]);
                method$codec = EasyLookup.unreflectMethod(codecMethod);
                for (Map.Entry entry : componentsMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    String key = (String)keyMethod.invoke(entry.getKey(), new Object[0]);
                    Object value = valueMethod.invoke(entry.getValue(), new Object[0]);
                    TYPES.put(ComponentType.key(key), value);
                    Codec valueCodec = (Codec)codecMethod.invoke(value, new Object[0]);
                    if (valueCodec == null) continue;
                    CODECS.put(ComponentType.key(key), (Codec<Object>)valueCodec);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        NBT_OPS = nbtOps;
        CREATE = method$create;
        CODEC = method$codec;
        try {
            REGISTRY_NBT_OPS = (DynamicOps)ComponentType.createGlobalContext(NBT_OPS);
            REGISTRY_JSON_OPS = (DynamicOps)ComponentType.createGlobalContext(JsonOps.INSTANCE);
            REGISTRY_JAVA_OPS = (DynamicOps)ComponentType.createGlobalContext(JAVA_OPS);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

