/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item.mirror;

import dev.faultyfunctions.soulgraves.libs.rtag.Rtag;
import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemData;
import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.item.mirror.IAttributeMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ChatComponent;
import dev.faultyfunctions.soulgraves.libs.rtag.util.OptionalType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class IComponentMirror
implements ItemMirror {
    private static final Map<String, Transformation> TRANSFORMATIONS = new LinkedHashMap<String, Transformation>();
    private static final List<String> HIDE_FLAGS = List.of("minecraft:enchantments", "minecraft:attribute_modifiers", "minecraft:unbreakable", "minecraft:can_break", "minecraft:can_place_on", "minecraft:stored_enchantments", "minecraft:dyed_color", "minecraft:trim");
    private static final Byte TRUE = 1;
    private static final Byte FALSE = 0;
    private static final Object TAG_TRUE = TagBase.newTag(true);
    private static final Object TAG_FALSE = TagBase.newTag(false);

    @Override
    public float getDeprecationVersion() {
        return 20.04f;
    }

    private Iterable<Map.Entry<String, Transformation>> getTransformations(final Collection<String> keys2) {
        return new Iterable<Map.Entry<String, Transformation>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<String, Transformation>> iterator() {
                return new Iterator<Map.Entry<String, Transformation>>(){
                    private final Iterator<Map.Entry<String, Transformation>> iterator = TRANSFORMATIONS.entrySet().iterator();
                    private Map.Entry<String, Transformation> next;

                    @Override
                    public boolean hasNext() {
                        while (this.iterator.hasNext()) {
                            this.next = this.iterator.next();
                            if (!keys2.contains(this.next.getKey())) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Map.Entry<String, Transformation> next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Map.Entry<String, Transformation> next = this.next;
                        this.next = null;
                        return next;
                    }
                };
            }
        };
    }

    @Override
    public void upgrade(Object compound, String id, float from, float to) {
        Object components;
        if (to < 20.04f) {
            return;
        }
        if (from <= 20.03f) {
            Object tag;
            Object count = TagCompound.get(compound, "Count");
            if (count != null) {
                TagCompound.remove(compound, "Count");
                TagCompound.set(compound, "count", TagBase.newTag(((Number)TagBase.getValue(count)).intValue()));
            }
            if ((tag = TagCompound.get(compound, "tag")) == null) {
                return;
            }
            Set<Object[]> paths = this.extractPaths(compound);
            TagCompound.remove(compound, "tag");
            TagCompound.set(compound, "components", tag);
            for (Object[] objectArray : paths) {
                if (objectArray.length < 2) continue;
                Object[] componentPath = ItemData.getComponentPath(objectArray);
                if (componentPath.length > 1 && componentPath[1].equals("minecraft:written_book_content") && id.equalsIgnoreCase("minecraft:writable_book")) {
                    componentPath[1] = "writable_book_content";
                }
                if (objectArray[0].equals("tag")) {
                    objectArray[0] = "components";
                }
                Rtag.INSTANCE.move(compound, objectArray, componentPath, true);
            }
            Map<String, Object> value = TagCompound.getValue(tag);
            for (String key : new ArrayList<String>(value.keySet())) {
                Object val;
                boolean result;
                Transformation transformation = TRANSFORMATIONS.get(key);
                if (transformation == null || (result = TagCompound.isTagCompound(val = value.get(key)) ? transformation.upgradeComponent(tag, key, TagCompound.getValue(val)) : (TagList.isTagList(val) ? transformation.upgradeList(tag, key, TagList.getValue(val)) : transformation.upgradeObject(tag, key, TagBase.getValue(val))))) continue;
                value.remove(key);
            }
            this.upgradeHideFlags(tag, id);
        }
        if ((components = TagCompound.get(compound, "components")) == null) {
            return;
        }
        Map<String, Object> value = TagCompound.getValue(components);
        for (Map.Entry<String, Transformation> entry : this.getTransformations(value.keySet())) {
            String string = entry.getKey();
            Transformation transformation = entry.getValue();
            transformation.upgrade(components, string, value.get(string), from, to);
        }
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        this.upgrade(compound, id, from, to);
    }

    private void upgradeHideFlags(Object components, String id) {
        OptionalType optional = Rtag.INSTANCE.getOptional(components, "minecraft:custom_data", "HideFlags");
        if (optional.isEmpty()) {
            return;
        }
        Rtag.INSTANCE.set(components, null, "minecraft:custom_data", "HideFlags");
        if (TagCompound.getValue(TagCompound.get(components, "minecraft:custom_data")).isEmpty()) {
            TagCompound.remove(components, "minecraft:custom_data");
        }
        Set<Integer> flags = optional.asOrdinalSet(8);
        for (Integer flag : flags) {
            if (flag == 5 && !id.equalsIgnoreCase("minecraft:enchanted_book")) {
                TagCompound.set(components, "minecraft:hide_additional_tooltip", TagCompound.newTag());
                continue;
            }
            Rtag.INSTANCE.set(components, false, HIDE_FLAGS.get(flag), "show_in_tooltip");
        }
    }

    @Override
    public void downgrade(Object compound, String id, float from, float to) {
        Transformation transformation;
        if (from < 20.04f) {
            return;
        }
        Object components = TagCompound.get(compound, "components");
        if (components != null) {
            Map<String, Object> value = TagCompound.getValue(components);
            for (Map.Entry<String, Transformation> entry : this.getTransformations(value.keySet())) {
                String key = entry.getKey();
                transformation = entry.getValue();
                transformation.downgrade(components, key, value.get(key), from, to);
            }
        }
        if (to <= 20.03f) {
            Object count = TagCompound.get(compound, "count");
            if (count != null) {
                TagCompound.remove(compound, "count");
                TagCompound.set(compound, "Count", TagBase.newTag((byte)Math.min((Integer)TagBase.getValue(count), 127)));
            } else {
                TagCompound.set(compound, "Count", TagBase.newTag((byte)1));
            }
            if (components == null) {
                return;
            }
            TagCompound.remove(compound, "components");
            TagCompound.set(compound, "tag", components);
            Map<String, Object> value = TagCompound.getValue(components);
            for (String key : new ArrayList<String>(value.keySet())) {
                Object val;
                boolean result;
                transformation = TRANSFORMATIONS.get(key);
                if (transformation == null || (result = TagCompound.isTagCompound(val = value.get(key)) ? transformation.downgradeComponent(components, key, TagCompound.getValue(val)) : (TagList.isTagList(val) ? transformation.downgradeList(components, key, TagList.getValue(val)) : transformation.downgradeObject(components, key, TagBase.getValue(val))))) continue;
                value.remove(key);
            }
            for (Object[] path : this.extractPaths(compound)) {
                Object[] tagPath;
                if (path.length < 2 || (tagPath = ItemData.getTagPath(path)).length <= 1) continue;
                Rtag.INSTANCE.move(compound, path, tagPath, true);
            }
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        this.downgrade(compound, id, from, to);
    }

    private Set<Object[]> extractPaths(Object compound) {
        Map<String, Object> value = TagCompound.getValue(compound);
        if (value.isEmpty()) {
            return Set.of();
        }
        HashSet<Object[]> paths = new HashSet<Object[]>();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            if (TagCompound.isTagCompound(entry.getValue())) {
                for (Object[] path : this.extractPaths(entry.getValue())) {
                    Object[] subPath = new Object[path.length + 1];
                    subPath[0] = entry.getKey();
                    System.arraycopy(path, 0, subPath, 1, path.length);
                    paths.add(subPath);
                }
                continue;
            }
            paths.add(new Object[]{entry.getKey()});
        }
        return paths;
    }

    static {
        TRANSFORMATIONS.put("minecraft:hide_additional_tooltip", new TooltipDisplay());
        TRANSFORMATIONS.put("minecraft:unbreakable", new Unbreakable());
        TRANSFORMATIONS.put("minecraft:enchantments", new Enchantments(0));
        TRANSFORMATIONS.put("minecraft:stored_enchantments", new Enchantments(5));
        TRANSFORMATIONS.put("minecraft:can_break", new CanBuild(3));
        TRANSFORMATIONS.put("minecraft:can_place_on", new CanBuild(4));
        TRANSFORMATIONS.put("minecraft:dyed_color", new DyedColor());
        TRANSFORMATIONS.put("minecraft:attribute_modifiers", new AttributeModifiers());
        TRANSFORMATIONS.put("minecraft:charged_projectiles", new ChargedProjectiles());
        TRANSFORMATIONS.put("minecraft:map_decorations", new MapDecorations());
        TRANSFORMATIONS.put("minecraft:writable_book_content", new BookContents());
        TRANSFORMATIONS.put("minecraft:written_book_content", new BookContents());
        TRANSFORMATIONS.put("minecraft:trim", new Trim());
        TRANSFORMATIONS.put("minecraft:firework_explosion", new FireworkExplosion());
        TRANSFORMATIONS.put("minecraft:fireworks", new Fireworks());
        TRANSFORMATIONS.put("minecraft:profile", new Profile());
        TRANSFORMATIONS.put("minecraft:base_color", new BaseColor());
        TRANSFORMATIONS.put("minecraft:banner_patterns", new BannerPatterns());
        TRANSFORMATIONS.put("minecraft:container", new Container());
        TRANSFORMATIONS.put("minecraft:bees", new Bees());
        TRANSFORMATIONS.put("minecraft:food", new Food());
        TRANSFORMATIONS.put("minecraft:consumable", new Food());
        TRANSFORMATIONS.put("minecraft:use_remainder", new Food());
        TRANSFORMATIONS.put("minecraft:fire_resistant", new DamageResistant());
        TRANSFORMATIONS.put("minecraft:damage_resistant", new DamageResistant());
        TRANSFORMATIONS.put("minecraft:custom_model_data", new CustomModelData());
        TRANSFORMATIONS.put("minecraft:equippable", new Equippable());
        TRANSFORMATIONS.put("minecraft:hide_tooltip", new TooltipDisplay());
        TRANSFORMATIONS.put("minecraft:jukebox_playable", new JukeboxPlayable());
        TRANSFORMATIONS.put("minecraft:custom_name", new TextComponentTransformation(new Object[0]));
        TRANSFORMATIONS.put("minecraft:instrument", new TextComponentTransformation("description"));
        TRANSFORMATIONS.put("minecraft:item_name", new TextComponentTransformation(new Object[0]));
        TRANSFORMATIONS.put("minecraft:lore", new Lore());
        TRANSFORMATIONS.put("minecraft:tooltip_display", new TooltipDisplay());
    }

    public static interface Transformation {
        default public void upgrade(Object components, String id, Object component, float from, float to) {
        }

        default public boolean upgradeComponent(Object components, String id, Map<String, Object> value) {
            return true;
        }

        default public boolean upgradeList(Object components, String id, List<Object> value) {
            return true;
        }

        default public boolean upgradeObject(Object components, String id, Object value) {
            return true;
        }

        default public void downgrade(Object components, String id, Object component, float from, float to) {
        }

        default public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            return true;
        }

        default public boolean downgradeList(Object components, String id, List<Object> value) {
            return true;
        }

        default public boolean downgradeObject(Object components, String id, Object value) {
            return true;
        }

        default public void move(Map<String, Object> map, String fromKey, String toKey) {
            this.move(map, fromKey, toKey, null);
        }

        default public boolean move(Map<String, Object> map, String fromKey, String toKey, Function<Object, Object> transformation) {
            Object value = map.get(fromKey);
            map.remove(fromKey);
            if (value != null && transformation != null) {
                if ((value = transformation.apply(TagBase.getValue(value))) != null) {
                    value = TagBase.newTag(value);
                } else {
                    return false;
                }
            }
            if (value != null) {
                map.put(toKey, value);
                return true;
            }
            return false;
        }

        default public void setFlag(Object components, int ordinal) {
            int bitField = Rtag.INSTANCE.getOptional(components, "minecraft:custom_data", "HideFlags").asInt(0);
            byte bit = (byte)(1 << ordinal);
            Rtag.INSTANCE.set(components, bitField |= bit, "minecraft:custom_data", "HideFlags");
        }
    }

    public static class TooltipDisplay
    implements TooltipTransformation {
        private static final List<String> HIDDEN_COMPONENTS = List.of("minecraft:banner_patterns", "minecraft:bees", "minecraft:block_entity_data", "minecraft:block_state", "minecraft:bundle_contents", "minecraft:charged_projectiles", "minecraft:container", "minecraft:container_loot", "minecraft:firework_explosion", "minecraft:fireworks", "minecraft:instrument", "minecraft:map_id", "minecraft:painting/variant", "minecraft:pot_decorations", "minecraft:potion_contents", "minecraft:tropical_fish/pattern", "minecraft:written_book_content");
        private static final Set<String> HIDE_FLAGS = Set.of("minecraft:enchantments", "minecraft:attribute_modifiers", "minecraft:unbreakable", "minecraft:can_break", "minecraft:can_place_on", "minecraft:stored_enchantments", "minecraft:dyed_color", "minecraft:trim");

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            this.setFlag(components, 5);
            return false;
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                if (id.equals("minecraft:hide_additional_tooltip")) {
                    this.hideComponents(components, HIDDEN_COMPONENTS);
                    TagCompound.remove(components, id);
                } else if (id.equals("minecraft:hide_tooltip")) {
                    Rtag.INSTANCE.set(components, true, "minecraft:tooltip_display", "hide_tooltip");
                    TagCompound.remove(components, id);
                }
            }
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.04f && to < 21.04f && id.equals("minecraft:tooltip_display")) {
                Object hiddenComponents;
                if (TAG_TRUE.equals(TagCompound.get(component, "hide_tooltip"))) {
                    TagCompound.set(components, "minecraft:hide_tooltip", TagCompound.newTag());
                }
                if ((hiddenComponents = TagCompound.get(component, "hidden_components")) != null) {
                    for (Object tag : TagList.getValue(hiddenComponents)) {
                        String hidden = (String)TagBase.getValue(tag);
                        if (HIDE_FLAGS.contains(hidden)) {
                            Rtag.INSTANCE.set(components, false, hidden, "show_in_tooltip");
                            continue;
                        }
                        if (!HIDDEN_COMPONENTS.contains(hidden)) continue;
                        TagCompound.set(components, "minecraft:hide_additional_tooltip", TagCompound.newTag());
                    }
                }
                TagCompound.remove(components, id);
            }
        }
    }

    public static class Unbreakable
    extends TooltipDowngrade {
        public Unbreakable() {
            super(2);
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                this.upgradeTooltip(components, id, component);
                Rtag.INSTANCE.set(components, TagCompound.newTag(), id);
            }
        }

        @Override
        public boolean upgradeObject(Object components, String id, Object value) {
            if (TRUE.equals(value)) {
                return Rtag.INSTANCE.set(components, Map.of("show_in_tooltip", true), id);
            }
            return false;
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            this.downgradeTooltip(components, value);
            return Rtag.INSTANCE.set(components, true, id);
        }
    }

    public static class Enchantments
    extends TooltipDowngrade {
        public Enchantments(int ordinal) {
            super(ordinal);
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                this.upgradeTooltip(components, id, component);
                Rtag.INSTANCE.set(components, TagCompound.get(component, "levels"), id);
            }
        }

        @Override
        public boolean upgradeList(Object components, String id, List<Object> value) {
            HashMap<String, Integer> levels = new HashMap<String, Integer>();
            for (Object enchantment : value) {
                String key = (String)TagBase.getValue(TagCompound.get(enchantment, "id"));
                Number level = (Number)TagBase.getValue(TagCompound.get(enchantment, "lvl"));
                if (key == null) continue;
                if (key.equals("minecraft:sweeping")) {
                    key = "minecraft:sweeping_edge";
                }
                if (level == null) {
                    level = 1;
                }
                levels.put(key, Math.max(1, level.intValue()));
            }
            TagCompound.remove(components, id);
            return Rtag.INSTANCE.set(components, levels, id, "levels");
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.04f && to < 21.04f) {
                TagCompound.set(components, id, TagCompound.newTag(Map.of("levels", component)));
            }
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            this.downgradeTooltip(components, value);
            if (value.containsKey("levels")) {
                ArrayList<Object> enchantments = new ArrayList<Object>();
                for (Map.Entry<String, Object> entry : TagCompound.getValue(value.get("levels")).entrySet()) {
                    String key = entry.getKey();
                    if (key.equals("minecraft:sweeping_edge")) {
                        key = "minecraft:sweeping";
                    }
                    int level = (Integer)TagBase.getValue(entry.getValue());
                    enchantments.add(TagCompound.newTag(Map.of("id", TagBase.newTag(key), "lvl", TagBase.newTag((short)(level > Short.MAX_VALUE ? Short.MAX_VALUE : (short)level)))));
                }
                return Rtag.INSTANCE.set(components, enchantments, id);
            }
            return false;
        }
    }

    public static class CanBuild
    extends TooltipDowngrade {
        public CanBuild(int ordinal) {
            super(ordinal);
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                this.upgradeTooltip(components, id, component);
                Rtag.INSTANCE.set(components, TagCompound.get(component, "predicates"), id);
            }
        }

        @Override
        public boolean upgradeList(Object components, String id, List<Object> value) {
            List<Object> predicates;
            Object saved = Rtag.INSTANCE.getExact(components, "minecraft:custom_data", "savedPredicates");
            if (saved != null) {
                Rtag.INSTANCE.set(components, null, "minecraft:custom_data", "savedPredicates");
                predicates = TagList.getValue(saved);
            } else {
                predicates = new ArrayList();
            }
            for (Object block : value) {
                HashMap<String, Object> predicate = new HashMap<String, Object>();
                predicate.put("blocks", block);
                predicates.add(TagCompound.newTag(predicate));
            }
            HashMap<String, Object> component = new HashMap<String, Object>();
            component.put("predicates", TagList.newTag(predicates));
            return Rtag.INSTANCE.set(components, TagCompound.newTag(component), id);
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.04f && to < 21.04f) {
                TagCompound.set(components, id, TagCompound.newTag(Map.of("predicates", component)));
            }
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            this.downgradeTooltip(components, value);
            ArrayList<Object> blocks = new ArrayList<Object>();
            if (value.containsKey("predicates")) {
                List<Object> predicates = TagList.getValue(value.get("predicates"));
                Iterator<Object> iterator2 = predicates.iterator();
                while (iterator2.hasNext()) {
                    Map<String, Object> predicate = TagCompound.getValue(iterator2.next());
                    if (!predicate.containsKey("blocks") || predicate.size() != 1) continue;
                    blocks.add(predicate.get("blocks"));
                    iterator2.remove();
                }
                if (!predicates.isEmpty()) {
                    Rtag.INSTANCE.set(components, value.get("predicates"), "minecraft:custom_data", "savedPredicates");
                }
            }
            return Rtag.INSTANCE.set(components, blocks, id);
        }
    }

    public static class DyedColor
    extends TooltipDowngrade {
        public DyedColor() {
            super(6);
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                this.upgradeTooltip(components, id, component);
                Rtag.INSTANCE.set(components, TagCompound.get(component, "rgb"), id);
            }
        }

        @Override
        public boolean upgradeObject(Object components, String id, Object value) {
            TagCompound.remove(components, id);
            return Rtag.INSTANCE.set(components, value, id, "rgb");
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.04f && to < 21.04f) {
                TagCompound.set(components, id, TagCompound.newTag(Map.of("rgb", component)));
            }
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            this.downgradeTooltip(components, value);
            if (value.containsKey("rgb")) {
                return Rtag.INSTANCE.set(components, value.get("rgb"), id);
            }
            return false;
        }
    }

    public static class AttributeModifiers
    extends TooltipDowngrade {
        private static final Set<String> PLAYER = Set.of("block_interaction_range", "entity_interaction_range", "block_break_speed", "mining_efficiency", "sneaking_speed", "submerged_mining_speed", "sweeping_damage_ratio");
        private static final String ZOMBIE = "spawn_reinforcements";

        public AttributeModifiers() {
            super(1);
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.0f && from < 21.0f) {
                AttributeModifiers.modifiers(component, map -> {
                    String nameValue;
                    Object name = map.remove("name");
                    if (name != null && (nameValue = (String)TagBase.getValue(name)).indexOf(58) > 0) {
                        map.put("id", name);
                        map.remove("uuid");
                        return;
                    }
                    Object uuid = map.remove("uuid");
                    if (uuid != null) {
                        map.put("id", TagBase.newTag("minecraft:" + TagBase.getValue(uuid)));
                    } else {
                        map.put("id", TagBase.newTag("minecraft:" + UUID.randomUUID()));
                    }
                });
            }
            if (to >= 21.02f && from < 21.02f) {
                AttributeModifiers.modifiers(component, map -> {
                    Object type = map.remove("type");
                    if (type != null) {
                        map.put("type", TagBase.newTag(IAttributeMirror.rename(((String)TagBase.getValue(type)).toLowerCase(), typeValue -> {
                            if (typeValue.startsWith("generic.") || typeValue.startsWith("player.") || typeValue.startsWith("zombie.")) {
                                return typeValue.substring(typeValue.indexOf(46) + 1);
                            }
                            return typeValue;
                        })));
                    }
                });
            }
            if (to >= 21.04f && from < 21.04f) {
                this.upgradeTooltip(components, id, component);
                Rtag.INSTANCE.set(components, TagCompound.get(component, "modifiers"), id);
            }
        }

        @Override
        public boolean upgradeList(Object components, String id, List<Object> value) {
            for (Object modifier : value) {
                Map<String, Object> map = TagCompound.getValue(modifier);
                this.move(map, "AttributeName", "type", type -> IAttributeMirror.rename((String)type, s -> {
                    switch (s) {
                        case "generic.block_interaction_range": {
                            return "player.block_interaction_range";
                        }
                        case "generic.entity_interaction_range": {
                            return "player.entity_interaction_range";
                        }
                        case "horse.jump_strength": {
                            return "generic.jump_strength";
                        }
                    }
                    return s;
                }));
                this.move(map, "Slot", "slot");
                this.move(map, "UUID", "uuid");
                this.move(map, "Name", "name");
                this.move(map, "Amount", "amount");
                this.move(map, "Operation", "operation", operation -> {
                    switch ((Integer)operation) {
                        case 0: {
                            return "add_value";
                        }
                        case 1: {
                            return "add_multiplied_base";
                        }
                        case 2: {
                            return "add_multiplied_total";
                        }
                    }
                    return null;
                });
            }
            TagCompound.remove(components, id);
            return Rtag.INSTANCE.set(components, value, id, "modifiers");
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (to < 21.04f && from >= 21.04f) {
                component = TagCompound.newTag(Map.of("modifiers", component));
                TagCompound.set(components, id, component);
            }
            if (to < 21.02f && from >= 21.02f) {
                AttributeModifiers.modifiers(component, map -> {
                    Object type = map.remove("type");
                    if (type != null) {
                        map.put("type", TagBase.newTag(IAttributeMirror.rename(((String)TagBase.getValue(type)).toLowerCase(), typeValue -> {
                            if (!typeValue.contains(".")) {
                                if (PLAYER.contains(typeValue)) {
                                    return "player." + typeValue;
                                }
                                if (ZOMBIE.equals(typeValue)) {
                                    return "zombie." + typeValue;
                                }
                                return "generic." + typeValue;
                            }
                            return typeValue;
                        })));
                    }
                });
            }
            if (to < 21.0f && from >= 21.0f) {
                AttributeModifiers.modifiers(component, map -> {
                    Object key = map.remove("id");
                    if (key != null) {
                        map.put("name", key);
                    } else {
                        map.put("name", TagBase.newTag(UUID.randomUUID()));
                    }
                    map.put("uuid", TagBase.newTag(UUID.randomUUID()));
                });
            }
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            this.downgradeTooltip(components, value);
            Object modifiers = AttributeModifiers.modifiers(value, map -> {
                this.move((Map<String, Object>)map, "type", "AttributeName", type -> IAttributeMirror.rename((String)type, s -> {
                    switch (s) {
                        case "player.block_interaction_range": {
                            return "generic.block_interaction_range";
                        }
                        case "player.entity_interaction_range": {
                            return "generic.entity_interaction_range";
                        }
                        case "generic.jump_strength": {
                            return "horse.jump_strength";
                        }
                    }
                    return s;
                }));
                this.move((Map<String, Object>)map, "slot", "Slot");
                this.move((Map<String, Object>)map, "uuid", "UUID");
                this.move((Map<String, Object>)map, "name", "Name");
                this.move((Map<String, Object>)map, "amount", "Amount");
                this.move((Map<String, Object>)map, "operation", "Operation", operation -> {
                    switch ((String)operation) {
                        case "add_value": {
                            return 0;
                        }
                        case "add_multiplied_base": {
                            return 1;
                        }
                        case "add_multiplied_total": {
                            return 2;
                        }
                    }
                    return null;
                });
            });
            return modifiers != null && Rtag.INSTANCE.set(components, modifiers, id);
        }

        private static Object modifiers(Object value, Consumer<Map<String, Object>> consumer) {
            Object modifiers;
            Object object = modifiers = value instanceof Map ? ((Map)value).get("modifiers") : TagCompound.get(value, "modifiers");
            if (modifiers != null) {
                for (Object modifier : TagList.getValue(modifiers)) {
                    Map<String, Object> map = TagCompound.getValue(modifier);
                    consumer.accept(map);
                }
            }
            return modifiers;
        }
    }

    public static class ChargedProjectiles
    implements Transformation {
        @Override
        public boolean upgradeList(Object components, String id, List<Object> value) {
            Rtag.INSTANCE.set(components, null, "minecraft:custom_data", "Charged");
            return true;
        }

        @Override
        public boolean downgradeList(Object components, String id, List<Object> value) {
            return Rtag.INSTANCE.set(components, !value.isEmpty(), "minecraft:custom_data", "Charged");
        }
    }

    public static class MapDecorations
    implements Transformation {
        @Override
        public boolean upgradeList(Object components, String id, List<Object> value) {
            HashMap<String, Object> decorations = new HashMap<String, Object>();
            for (Object decoration : value) {
                Map<String, Object> map = TagCompound.getValue(decoration);
                String key = (String)TagBase.getValue(map.remove("id"));
                if (key == null) continue;
                this.move(map, "type", "type", type -> Type.VALUES[Byte.valueOf((Byte)type).intValue()].name().toLowerCase());
                this.move(map, "rot", "rotation", rot -> Float.valueOf(Double.valueOf((Double)rot).floatValue()));
                decorations.put(key, decoration);
            }
            Object saved = Rtag.INSTANCE.getExact(components, "minecraft:custom_data", "savedDecorations");
            if (saved != null) {
                Rtag.INSTANCE.set(components, null, "minecraft:custom_data", "savedDecorations");
                decorations.putAll(TagCompound.getValue(saved));
            }
            return Rtag.INSTANCE.set(components, decorations, id);
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            ArrayList<Object> decorations = new ArrayList<Object>();
            HashMap<String, Object> saved = new HashMap<String, Object>();
            for (Map.Entry<String, Object> decoration : value.entrySet()) {
                Map<String, Object> map = TagCompound.getValue(decoration.getValue());
                String type = (String)TagBase.getValue(map.get("type"));
                if (Type.ORDINALS.containsKey(type)) {
                    map.put("id", TagBase.newTag(decoration.getKey()));
                    map.put("type", TagBase.newTag(Type.ORDINALS.get(type)));
                    this.move(map, "rot", "rotation", rot -> Float.valueOf(((Float)rot).floatValue()).doubleValue());
                    decorations.add(decoration.getValue());
                    continue;
                }
                saved.put(decoration.getKey(), decoration.getValue());
            }
            if (!saved.isEmpty()) {
                Rtag.INSTANCE.set(components, saved, "minecraft:custom_data", "savedDecorations");
            }
            return Rtag.INSTANCE.set(components, decorations, id);
        }

        private static enum Type {
            PLAYER,
            FRAME,
            RED_MARKER,
            BLUE_MARKER,
            TARGET_X,
            TARGET_POINT,
            PLAYER_OFF_MAP,
            PLAYER_OFF_LIMITS,
            MANSION,
            MONUMENT,
            BANNER_WHITE,
            BANNER_ORANGE,
            BANNER_MAGENTA,
            BANNER_LIGHT_BLUE,
            BANNER_YELLOW,
            BANNER_LIME,
            BANNER_PINK,
            BANNER_GRAY,
            BANNER_LIGHT_GRAY,
            BANNER_CYAN,
            BANNER_PURPLE,
            BANNER_BLUE,
            BANNER_BROWN,
            BANNER_GREEN,
            BANNER_RED,
            BANNER_BLACK,
            RED_X,
            VILLAGE_DESERT,
            VILLAGE_PLAINS,
            VILLAGE_SAVANNA,
            VILLAGE_SNOWY,
            VILLAGE_TAIGA,
            JUNGLE_TEMPLE,
            SWAMP_HUT;

            static final Type[] VALUES;
            static final Map<String, Byte> ORDINALS;

            static {
                VALUES = Type.values();
                ORDINALS = new HashMap<String, Byte>();
                for (Type value : VALUES) {
                    ORDINALS.put(value.name().toLowerCase(), (byte)value.ordinal());
                }
            }
        }
    }

    public static class BookContents
    extends TextComponentTransformation
    implements Transformation {
        public BookContents() {
            super(new Object[0]);
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            Object pages;
            if (to >= 21.04f && from < 21.04f && id.equals("minecraft:written_book_content") && (pages = TagCompound.get(component, "pages")) != null) {
                TagList.getValue(pages).replaceAll(this::upgradeText);
            }
        }

        @Override
        public boolean upgradeComponent(Object components, String id, Map<String, Object> value) {
            if (value.containsKey("pages")) {
                Map<Object, Object> filtered_pages;
                ArrayList<Object> pages = new ArrayList<Object>();
                if (value.containsKey("filtered_pages")) {
                    filtered_pages = TagCompound.getValue(value.get("filtered_pages"));
                    value.remove("filtered_pages");
                } else {
                    filtered_pages = Map.of();
                }
                int index = 0;
                for (Object text : TagList.getValue(value.get("pages"))) {
                    HashMap<String, Object> page = new HashMap<String, Object>();
                    page.put("text", text);
                    Object filtered = filtered_pages.get(String.valueOf(index));
                    if (filtered != null) {
                        page.put("filtered", filtered);
                    }
                    pages.add(TagCompound.newTag(page));
                    ++index;
                }
                value.put("pages", TagList.newTag(pages));
            } else {
                value.remove("filtered_pages");
            }
            if (value.containsKey("title")) {
                HashMap<String, Object> title = new HashMap<String, Object>();
                title.put("text", value.get("title"));
                if (value.containsKey("filtered_title")) {
                    title.put("filtered", value.get("filtered_title"));
                }
                value.put("title", TagCompound.getValue(title));
            } else {
                value.remove("filtered_title");
            }
            return true;
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            Object pages;
            if (from >= 21.04f && to < 21.04f && id.equals("minecraft:written_book_content") && (pages = TagCompound.get(component, "pages")) != null) {
                TagList.getValue(pages).replaceAll(this::downgradeText);
            }
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            if (value.containsKey("pages")) {
                ArrayList<Object> pages = new ArrayList<Object>();
                HashMap<String, Object> filtered_pages = new HashMap<String, Object>();
                int index = 0;
                for (Object page : TagList.getValue(value.get("pages"))) {
                    Map<String, Object> map = TagCompound.getValue(page);
                    pages.add(map.get("text"));
                    if (map.containsKey("filtered")) {
                        filtered_pages.put(String.valueOf(index), map.get("filtered"));
                    }
                    ++index;
                }
                value.put("pages", TagList.newTag(pages));
                if (!filtered_pages.isEmpty()) {
                    value.put("filtered_pages", TagCompound.newTag(filtered_pages));
                }
            }
            if (value.containsKey("title")) {
                Map<String, Object> title = TagCompound.getValue(value.get("title"));
                value.put("title", title.get("text"));
                if (title.containsKey("filtered")) {
                    value.put("filtered_title", title.get("filtered"));
                }
            }
            return true;
        }
    }

    public static class Trim
    extends TooltipDowngrade {
        public Trim() {
            super(7);
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                this.upgradeTooltip(components, id, component);
            }
        }
    }

    public static class FireworkExplosion
    implements Transformation {
        @Override
        public boolean upgradeComponent(Object components, String id, Map<String, Object> value) {
            this.upgradeExplosion(value, false);
            Object saved = Rtag.INSTANCE.getExact(components, "minecraft:custom_data", "savedExplosion");
            if (saved != null) {
                Rtag.INSTANCE.set(components, null, "minecraft:custom_data", "savedExplosion");
                value.put("shape", saved);
            }
            return true;
        }

        public void upgradeExplosion(Map<String, Object> explosion, boolean move) {
            if (move) {
                this.move(explosion, "Type", "shape", shape -> Shape.VALUES[(Integer)shape].name().toLowerCase());
                this.move(explosion, "Colors", "colors");
                this.move(explosion, "FadeColors", "fade_colors");
                this.move(explosion, "Trail", "has_trail");
                this.move(explosion, "Flicker", "has_twinkle");
            } else {
                Object shape2 = TagBase.getValue(explosion.get("shape"));
                if (shape2 != null) {
                    explosion.put("shape", TagBase.newTag(Shape.VALUES[(Integer)shape2].name().toLowerCase()));
                }
            }
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            Object saved = this.downgradeExplosion(value, true, false);
            if (saved != null) {
                Rtag.INSTANCE.set(components, saved, "minecraft:custom_data", "savedExplosion");
            }
            return true;
        }

        public Object downgradeExplosion(Map<String, Object> explosion, boolean continueOnFail, boolean move) {
            Object name = explosion.get("shape");
            boolean contains = Shape.ORDINALS.containsKey((String)TagBase.getValue(name));
            if (contains || continueOnFail) {
                if (move) {
                    this.move(explosion, "shape", "Type", shape -> contains ? Shape.ORDINALS.get((String)shape) : (byte)0);
                    this.move(explosion, "colors", "Colors");
                    this.move(explosion, "fade_colors", "FadeColors");
                    this.move(explosion, "has_trail", "Trail");
                    this.move(explosion, "has_twinkle", "Flicker");
                } else {
                    Object shape2 = TagBase.getValue(explosion.get("shape"));
                    if (shape2 != null) {
                        explosion.put("shape", TagBase.newTag(contains ? Shape.ORDINALS.get((String)shape2) : (byte)0));
                    }
                }
            }
            return contains ? null : name;
        }

        private static enum Shape {
            SMALL_BALL,
            LARGE_BALL,
            STAR,
            CREEPER,
            BURST;

            static final Shape[] VALUES;
            static final Map<String, Byte> ORDINALS;

            static {
                VALUES = Shape.values();
                ORDINALS = new HashMap<String, Byte>();
                for (Shape value : VALUES) {
                    ORDINALS.put(value.name().toLowerCase(), (byte)value.ordinal());
                }
            }
        }
    }

    public static class Fireworks
    extends FireworkExplosion {
        @Override
        public boolean upgradeComponent(Object components, String id, Map<String, Object> value) {
            List<Object> explosions = value.containsKey("explosions") ? TagList.getValue(value.get("explosions")) : new ArrayList();
            for (Object explosion : explosions) {
                this.upgradeExplosion(TagCompound.getValue(explosion), true);
            }
            Object saved = Rtag.INSTANCE.getExact(components, "minecraft:custom_data", "savedExplosions");
            if (saved != null) {
                Rtag.INSTANCE.set(components, null, "minecraft:custom_data", "savedExplosions");
                explosions.addAll(TagList.getValue(saved));
            }
            return true;
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            ArrayList<Object> saved = new ArrayList<Object>();
            List<Object> explosions = TagList.getValue(value.get("explosions"));
            Iterator<Object> iterator2 = explosions.iterator();
            while (iterator2.hasNext()) {
                Object explosion = iterator2.next();
                Object result = this.downgradeExplosion(TagCompound.getValue(explosion), false, true);
                if (result == null) continue;
                saved.add(explosion);
                iterator2.remove();
            }
            if (!saved.isEmpty()) {
                Rtag.INSTANCE.set(components, saved, "minecraft:custom_data", "savedExplosions");
            }
            return true;
        }
    }

    public static class Profile
    implements Transformation {
        @Override
        public boolean upgradeComponent(Object components, String id, Map<String, Object> value) {
            if (!value.containsKey("name") || ((String)TagBase.getValue(value.get("name"))).isBlank()) {
                value.put("name", TagBase.newTag("null"));
            }
            if (value.containsKey("properties")) {
                ArrayList<Object> list = new ArrayList<Object>();
                Map<String, Object> properties = TagCompound.getValue(value.get("properties"));
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    boolean textures = entry.getKey().equals("textures");
                    for (Object property : TagList.getValue(entry.getValue())) {
                        Map<String, Object> propertyMap = TagCompound.getValue(property);
                        propertyMap.put("name", TagBase.newTag(entry.getKey()));
                        if (textures) {
                            this.move(propertyMap, "Value", "value");
                            this.move(propertyMap, "Signature", "signature");
                        }
                        list.add(property);
                    }
                }
                if (!list.isEmpty()) {
                    value.put("properties", TagList.newTag(list));
                } else {
                    value.remove("properties");
                }
            }
            return true;
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            if (value.containsKey("properties")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                List<Object> properties = TagList.getValue(value.get("properties"));
                Iterator<Object> iterator2 = properties.iterator();
                while (iterator2.hasNext()) {
                    Object property = iterator2.next();
                    Map<String, Object> propertyMap = TagCompound.getValue(property);
                    String name = (String)TagBase.getValue(propertyMap.get("name"));
                    propertyMap.remove("name");
                    if (name.equals("textures")) {
                        this.move(propertyMap, "value", "Value");
                        this.move(propertyMap, "signature", "Signature");
                        continue;
                    }
                    Object list = map.get(name);
                    if (list == null) {
                        list = TagList.newTag();
                        map.put(name, list);
                    }
                    TagList.add(list, property);
                    iterator2.remove();
                }
                if (!properties.isEmpty()) {
                    map.put("textures", value.get("properties"));
                }
                if (!map.isEmpty()) {
                    value.put("properties", TagCompound.newTag(map));
                } else {
                    value.remove("properties");
                }
            }
            return true;
        }
    }

    public static class BaseColor
    implements Transformation {
        @Override
        public boolean upgradeObject(Object components, String id, Object value) {
            return Rtag.INSTANCE.set(components, Color.VALUES[(Integer)value].name().toLowerCase(), id);
        }

        @Override
        public boolean downgradeObject(Object components, String id, Object value) {
            return Rtag.INSTANCE.set(components, Color.ORDINALS.get((String)value), id);
        }
    }

    public static class BannerPatterns
    implements Transformation {
        @Override
        public boolean upgradeList(Object components, String id, List<Object> value) {
            for (Object compound : value) {
                Map<String, Object> map = TagCompound.getValue(compound);
                this.move(map, "Pattern", "pattern", pattern -> Pattern.NAMES.get((String)pattern));
                this.move(map, "Color", "color", color -> Color.VALUES[(Integer)color].name().toLowerCase());
            }
            Object saved = Rtag.INSTANCE.getExact(components, "minecraft:custom_data", "savedPatterns");
            if (saved != null) {
                Rtag.INSTANCE.set(components, null, "minecraft:custom_data", "savedPatterns");
                value.addAll(TagList.getValue(saved));
            }
            return true;
        }

        @Override
        public boolean downgradeList(Object components, String id, List<Object> value) {
            ArrayList<Object> saved = new ArrayList<Object>();
            for (Object compound : value) {
                Map<String, Object> map = TagCompound.getValue(compound);
                String name = (String)TagBase.getValue(map.get("pattern"));
                if (Pattern.SHORT_NAMES.containsKey(name)) {
                    this.move(map, "pattern", "Pattern", pattern -> Pattern.SHORT_NAMES.get((String)pattern));
                    this.move(map, "color", "Color", color -> Color.ORDINALS.get((String)color));
                    continue;
                }
                saved.add(compound);
            }
            if (!saved.isEmpty()) {
                Rtag.INSTANCE.set(components, saved, "minecraft:custom_data", "savedPatterns");
            }
            return true;
        }

        private static enum Pattern {
            BASE("b"),
            SQUARE_BOTTOM_LEFT("bl"),
            SQUARE_BOTTOM_RIGHT("br"),
            SQUARE_TOP_LEFT("tl"),
            SQUARE_TOP_RIGHT("tr"),
            STRIPE_BOTTOM("bs"),
            STRIPE_TOP("ts"),
            STRIPE_LEFT("ls"),
            STRIPE_RIGHT("rs"),
            STRIPE_CENTER("cs"),
            STRIPE_MIDDLE("ms"),
            STRIPE_DOWNRIGHT("drs"),
            STRIPE_DOWNLEFT("dls"),
            SMALL_STRIPES("ss"),
            CROSS("cr"),
            STRAIGHT_CROSS("sc"),
            TRIANGLE_BOTTOM("bt"),
            TRIANGLE_TOP("tt"),
            TRIANGLES_BOTTOM("bts"),
            TRIANGLES_TOP("tts"),
            DIAGONAL_LEFT("ld"),
            DIAGONAL_UP_RIGHT("rd"),
            DIAGONAL_UP_LEFT("lud"),
            DIAGONAL_RIGHT("rud"),
            CIRCLE("mc"),
            RHOMBUS("mr"),
            HALF_VERTICAL("vh"),
            HALF_HORIZONTAL("hh"),
            HALF_VERTICAL_RIGHT("vhr"),
            HALF_HORIZONTAL_BOTTOM("hhb"),
            BORDER("bo"),
            CURLY_BORDER("cbo"),
            GRADIENT("gra"),
            GRADIENT_UP("gru"),
            BRICKS("bri"),
            GLOBE("glb"),
            CREEPER("cre"),
            SKULL("sku"),
            FLOWER("flo"),
            MOJANG("moj"),
            PIGLIN("pig");

            static final Map<String, String> NAMES;
            static final Map<String, String> SHORT_NAMES;
            private final String shortName;

            private Pattern(String shortName) {
                this.shortName = shortName;
            }

            public String getShortName() {
                return this.shortName;
            }

            static {
                NAMES = new HashMap<String, String>();
                SHORT_NAMES = new HashMap<String, String>();
                for (Pattern value : Pattern.values()) {
                    String name = "minecraft:" + value.name().toLowerCase();
                    NAMES.put(value.getShortName(), name);
                    SHORT_NAMES.put(name, value.getShortName());
                }
            }
        }
    }

    public static class Container
    implements Transformation {
        @Override
        public boolean upgradeList(Object components, String id, List<Object> value) {
            for (int i = 0; i < value.size(); ++i) {
                Object item = value.get(i);
                Map<String, Object> itemValue = TagCompound.getValue(item);
                HashMap<String, Object> slot = new HashMap<String, Object>();
                Number itemSlot = (Number)TagBase.getValue(itemValue.get("Slot"));
                if (itemSlot == null) {
                    value.remove(i);
                    ++i;
                    continue;
                }
                slot.put("slot", TagBase.newTag(itemSlot.intValue()));
                itemValue.remove("Slot");
                slot.put("item", item);
                value.set(i, TagCompound.newTag(slot));
            }
            return true;
        }

        @Override
        public boolean downgradeList(Object components, String id, List<Object> value) {
            for (int i = 0; i < value.size(); ++i) {
                Object slot = value.get(i);
                Map<String, Object> slotValue = TagCompound.getValue(slot);
                Object item = slotValue.get("item");
                TagCompound.set(item, "Slot", TagBase.newTag(Integer.valueOf((Integer)TagBase.getValue(slotValue.get("slot"))).byteValue()));
                value.set(i, item);
            }
            return true;
        }
    }

    public static class Bees
    implements Transformation {
        @Override
        public boolean upgradeList(Object components, String id, List<Object> value) {
            for (Object bee : value) {
                Map<String, Object> map = TagCompound.getValue(bee);
                this.move(map, "EntityData", "entity_data");
                this.move(map, "TicksInHive", "ticks_in_hive");
                this.move(map, "MinOccupationTicks", "min_ticks_in_hive");
            }
            return true;
        }

        @Override
        public boolean downgradeList(Object components, String id, List<Object> value) {
            for (Object bee : value) {
                Map<String, Object> map = TagCompound.getValue(bee);
                this.move(map, "entity_data", "EntityData");
                this.move(map, "ticks_in_hive", "TicksInHive");
                this.move(map, "min_ticks_in_hive", "MinOccupationTicks");
            }
            return true;
        }
    }

    public static class Food
    implements Transformation {
        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.02f && from < 21.02f && id.equals("minecraft:food")) {
                Object effects;
                Object usingConvertsTo;
                Map<String, Object> food = TagCompound.getValue(component);
                Object eatSeconds = food.remove("eat_seconds");
                if (eatSeconds != null) {
                    Rtag.INSTANCE.set(components, eatSeconds, "minecraft:consumable", "consume_seconds");
                }
                if ((usingConvertsTo = food.remove("using_converts_to")) != null) {
                    TagCompound.set(components, "minecraft:use_remainder", usingConvertsTo);
                }
                if ((effects = food.remove("effects")) != null) {
                    for (Object effect : TagList.getValue(effects)) {
                        TagCompound.set(effect, "type", TagBase.newTag("apply_effects"));
                        Rtag.INSTANCE.add(effect, TagCompound.remove(effect, "effect"), "effects");
                    }
                    Rtag.INSTANCE.set(components, effects, "minecraft:consumable", "on_consume_effects");
                }
            }
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.02f && to < 21.02f) {
                if (id.equals("minecraft:consumable")) {
                    Object onConsumeEffects;
                    Map<String, Object> consumable = TagCompound.getValue(component);
                    Object consumeSeconds = consumable.remove("consume_seconds");
                    if (consumeSeconds != null) {
                        Rtag.INSTANCE.set(components, consumeSeconds, "minecraft:food", "eat_seconds");
                    }
                    if ((onConsumeEffects = consumable.get("on_consume_effects")) != null) {
                        Iterator<Object> iterator2 = TagList.getValue(onConsumeEffects).iterator();
                        while (iterator2.hasNext()) {
                            Map<String, Object> effect = TagCompound.getValue(iterator2.next());
                            if (!TagBase.getValue(effect.get("type")).equals("apply_effects")) continue;
                            iterator2.remove();
                            Object probability = effect.get("probability");
                            for (Object value : TagList.getValue(effect.get("effects"))) {
                                Rtag.INSTANCE.add(components, Map.of(probability, Map.of("effect", value)), "minecraft:food", "apply_effects");
                            }
                        }
                    }
                }
                if (id.equals("minecraft:use_remainder")) {
                    TagCompound.remove(components, id);
                    Rtag.INSTANCE.set(components, component, "minecraft:food", "using_converts_to");
                }
            }
        }
    }

    public static class DamageResistant
    implements Transformation {
        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.02f && from < 21.02f && id.equals("minecraft:fire_resistant")) {
                TagCompound.remove(components, "minecraft:fire_resistant");
                Rtag.INSTANCE.set(components, "#minecraft:is_fire", "minecraft:damage_resistant", "types");
            }
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.02f && to < 21.02f && id.equals("minecraft:damage_resistant") && "#minecraft:is_fire".equals(TagBase.getValue(TagCompound.get(component, "types")))) {
                TagCompound.remove(components, "minecraft:damage_resistant");
                TagCompound.set(components, "minecraft:fire_resistant", TagCompound.newTag());
            }
        }
    }

    public static class CustomModelData
    implements Transformation {
        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.03f && from < 21.03f) {
                TagCompound.remove(components, id);
                if (component instanceof Number) {
                    TagCompound.set(components, id, TagCompound.newTag(Map.of("floats", TagList.newTag(List.of(Float.valueOf(((Number)component).floatValue()))))));
                }
            }
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.03f && to < 21.03f) {
                TagCompound.remove(components, id);
                Object floats = TagCompound.get(component, "floats");
                if (floats != null) {
                    Float modelData = null;
                    for (Object element : TagList.getValue(floats)) {
                        if (element == null) continue;
                        modelData = (Float)TagBase.getValue(element);
                        break;
                    }
                    if (modelData != null) {
                        TagCompound.set(components, id, TagBase.newTag(modelData.intValue()));
                    }
                }
            }
        }
    }

    public static class Equippable
    implements Transformation {
        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.034f && from < 21.03f) {
                this.move(TagCompound.getValue(component), "model", "asset_id");
            }
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.03f && to < 21.03f) {
                this.move(TagCompound.getValue(component), "asset_id", "model");
            }
        }
    }

    public static class JukeboxPlayable
    implements TooltipTransformation {
        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                this.upgradeTooltip(components, id, component);
            }
        }
    }

    public static class TextComponentTransformation
    implements Transformation {
        private final Object[] path;

        public TextComponentTransformation(Object ... path) {
            this.path = path;
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                if (this.path.length > 0) {
                    Object jsonComponent = Rtag.INSTANCE.get(component, this.path);
                    if (jsonComponent != null) {
                        Rtag.INSTANCE.set(component, this.upgradeText(jsonComponent), this.path);
                    }
                } else {
                    Rtag.INSTANCE.set(components, this.upgradeText(component), id);
                }
            }
        }

        public Object upgradeText(Object jsonComponent) {
            Object textComponent = ChatComponent.fromJson((String)TagBase.getValue(jsonComponent));
            return ChatComponent.toTagOrNull(textComponent);
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.04f && to < 21.04f) {
                if (this.path.length > 0) {
                    Object tagComponent = Rtag.INSTANCE.get(component, this.path);
                    if (tagComponent != null) {
                        Rtag.INSTANCE.set(component, this.downgradeText(tagComponent), this.path);
                    }
                } else {
                    Rtag.INSTANCE.set(components, this.downgradeText(component), id);
                }
            }
        }

        public Object downgradeText(Object tagComponent) {
            Object textComponent = ChatComponent.fromTag(tagComponent);
            return TagBase.newTag(ChatComponent.toJsonOrNull(textComponent));
        }
    }

    public static class Lore
    extends TextComponentTransformation {
        public Lore() {
            super(new Object[0]);
        }

        @Override
        public void upgrade(Object components, String id, Object component, float from, float to) {
            if (to >= 21.04f && from < 21.04f) {
                TagList.getValue(component).replaceAll(this::upgradeText);
            }
        }

        @Override
        public void downgrade(Object components, String id, Object component, float from, float to) {
            if (from >= 21.04f && to < 21.04f) {
                TagList.getValue(component).replaceAll(this::downgradeText);
            }
        }
    }

    private static enum Color {
        WHITE,
        ORANGE,
        MAGENTA,
        LIGHT_BLUE,
        YELLOW,
        LIME,
        PINK,
        GRAY,
        LIGHT_GRAY,
        CYAN,
        PURPLE,
        BLUE,
        BROWN,
        GREEN,
        RED,
        BLACK;

        static final Color[] VALUES;
        static final Map<String, Byte> ORDINALS;

        static {
            VALUES = Color.values();
            ORDINALS = new HashMap<String, Byte>();
            for (Color value : VALUES) {
                ORDINALS.put(value.name().toLowerCase(), (byte)value.ordinal());
            }
        }
    }

    public static class TooltipDowngrade
    implements TooltipTransformation {
        private final int ordinal;

        public TooltipDowngrade(int ordinal) {
            this.ordinal = ordinal;
        }

        @Override
        public boolean downgradeComponent(Object components, String id, Map<String, Object> value) {
            this.downgradeTooltip(components, value);
            return true;
        }

        public void downgradeTooltip(Object components, Map<String, Object> value) {
            if (TAG_FALSE.equals(value.get("show_in_tooltip"))) {
                this.setFlag(components, this.ordinal);
            }
            value.remove("show_in_tooltip");
        }
    }

    public static interface TooltipTransformation
    extends Transformation {
        default public void upgradeTooltip(Object components, String id, Object component) {
            if (TAG_FALSE.equals(TagCompound.remove(component, "show_in_tooltip"))) {
                this.hideComponents(components, List.of(id));
            }
        }

        default public void hideComponents(Object components, List<String> paths) {
            Object tag = Rtag.INSTANCE.getExact(components, "minecraft:tooltip_display", "hidden_components");
            if (tag == null) {
                Rtag.INSTANCE.set(components, paths, "minecraft:tooltip_display", "hidden_components");
            } else {
                List<Object> hiddenComponents = TagList.getValue(tag);
                for (String s : paths) {
                    Object path = TagBase.newTag(s);
                    if (hiddenComponents.contains(path)) continue;
                    hiddenComponents.add(path);
                }
            }
        }
    }
}

