/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item.mirror;

import dev.faultyfunctions.soulgraves.libs.rtag.Rtag;
import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemTagStream;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import java.util.List;
import java.util.Set;

public class IContainerMirror
implements ItemMirror {
    private static final Set<String> CONTAINERS = Set.of("minecraft:chiseled_bookshelf", "minecraft:chest", "minecraft:furnace", "minecraft:ender_chest", "minecraft:shulker_box", "minecraft:white_shulker_box", "minecraft:orange_shulker_box", "minecraft:magenta_shulker_box", "minecraft:light_blue_shulker_box", "minecraft:yellow_shulker_box", "minecraft:lime_shulker_box", "minecraft:pink_shulker_box", "minecraft:gray_shulker_box", "minecraft:light_gray_shulker_box", "minecraft:cyan_shulker_box", "minecraft:purple_shulker_box", "minecraft:blue_shulker_box", "minecraft:brown_shulker_box", "minecraft:green_shulker_box", "minecraft:red_shulker_box", "minecraft:black_shulker_box", "minecraft:hopper", "minecraft:dispenser", "minecraft:dropper", "minecraft:trapped_chest", "minecraft:crafter", "minecraft:brewing_stand", "minecraft:barrel", "minecraft:smoker", "minecraft:blast_furnace", "minecraft:campfire", "minecraft:soul_campfire");
    private final ItemTagStream stream;
    private final Object[] path;
    private final boolean slotList;

    public IContainerMirror(ItemTagStream stream, boolean component) {
        this.stream = stream;
        if (component) {
            this.path = new Object[]{"minecraft:container"};
            this.slotList = true;
        } else {
            this.path = new Object[]{"BlockEntityTag", "Items"};
            this.slotList = false;
        }
    }

    @Override
    public float getMinVersion() {
        return 9.0f;
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        if (this.isContainer(from, id)) {
            this.processComponents(components, from, to);
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (this.isContainer(to, id)) {
            this.processComponents(components, from, to);
        }
    }

    private boolean isContainer(float version, String id) {
        if (version <= 20.03f) {
            return id.contains("shulker_box");
        }
        return CONTAINERS.contains(id);
    }

    public void processComponents(Object components, float from, float to) {
        block4: {
            Object container = Rtag.INSTANCE.getExact(components, this.path);
            if (container == null) break block4;
            List<Object> items = TagList.getValue(container);
            if (this.slotList) {
                for (Object slot : items) {
                    Object item = TagCompound.get(slot, "item");
                    this.stream.onLoad(item, from, to);
                }
            } else {
                for (Object item : items) {
                    this.stream.onLoad(item, from, to);
                }
            }
        }
    }
}

