/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item.mirror;

import dev.faultyfunctions.soulgraves.libs.rtag.Rtag;
import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IPotionMirror
implements ItemMirror {
    private static final Map<Object, Object> cache = new HashMap<Object, Object>();
    private static final Object POTION;
    private static final Object SPLASH_POTION;
    private static final Set<String> POTION_ITEMS;
    private final boolean convertDamage;

    public IPotionMirror() {
        this(true);
    }

    public IPotionMirror(boolean convertDamage) {
        this.convertDamage = convertDamage;
    }

    @Override
    public float getDeprecationVersion() {
        return 20.0f;
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        if (from <= 20.01f && POTION_ITEMS.contains(id)) {
            Map<String, Object> map;
            if (to >= 20.02f && (map = TagCompound.getValue(components)).containsKey("CustomPotionEffects")) {
                Object customPotionEffects = map.remove("CustomPotionEffects");
                map.put("custom_potion_effects", customPotionEffects);
            }
            this.upgrade(compound, id, from, to);
        }
    }

    @Override
    public void upgrade(Object compound, String id, float from, float to) {
        if (this.convertDamage && to >= 9.0f && from < 9.0f && id.equals("minecraft:potion")) {
            this.upgrade(compound);
        }
    }

    private void upgrade(Object compound) {
        Short damage = (Short)TagBase.getValue(TagCompound.get(compound, "Damage"));
        if (damage == null || damage == 0) {
            return;
        }
        String potion = this.getPotion(damage.shortValue());
        if (potion != null) {
            TagCompound.set(compound, "id", damage > 16000 ? SPLASH_POTION : POTION);
            TagCompound.set(compound, "Damage", TagBase.newTag((short)0));
            Rtag.INSTANCE.set(compound, TagBase.newTag(potion), "tag", "Potion");
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (to <= 20.01f && POTION_ITEMS.contains(id)) {
            Map<String, Object> map = TagCompound.getValue(components);
            if (from >= 20.02f && map.containsKey("custom_potion_effects")) {
                Object customPotionEffects = map.remove("custom_potion_effects");
                map.put("CustomPotionEffects", customPotionEffects);
            }
            if (from >= 9.0f && to < 9.0f && (id.equals("minecraft:potion") || id.equals("minecraft:splash_potion"))) {
                String potion;
                if (id.equals("minecraft:splash_potion")) {
                    TagCompound.set(compound, "id", POTION);
                }
                if ((potion = (String)TagBase.getValue(map.get("Potion"))) == null || potion.equals("empty") || potion.equals("water")) {
                    return;
                }
                short damage = (short)this.getDamage(id, potion);
                if (damage > 0) {
                    TagCompound.set(compound, "id", POTION);
                    TagCompound.set(compound, "Damage", TagBase.newTag(damage));
                    map.remove("Potion");
                }
            }
        }
    }

    public String getPotion(int damage) {
        return (String)cache.computeIfAbsent(damage, __ -> {
            for (PotionType type : PotionType.VALUES) {
                if (type.getPotion() != damage && type.getSplash() != damage) continue;
                return "minecraft:" + type.name().toLowerCase();
            }
            return null;
        });
    }

    public int getDamage(String id, String potion) {
        return (Integer)cache.computeIfAbsent(id + "=" + potion, __ -> {
            String potionType = potion.replace("minecraft:", "").toUpperCase();
            for (PotionType type : PotionType.VALUES) {
                if (!type.name().equals(potionType)) continue;
                if (id.equalsIgnoreCase("minecraft:splash_potion")) {
                    return type.getSplash();
                }
                return type.getPotion();
            }
            return -1;
        });
    }

    static {
        POTION_ITEMS = Set.of("minecraft:potion", "minecraft:lingering_potion", "minecraft:splash_potion", "minecraft:tipped_arrow");
        Object potion = null;
        Object splash = null;
        try {
            potion = TagBase.newTag("minecraft:potion");
            splash = TagBase.newTag("minecraft:splash_potion");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        POTION = potion;
        SPLASH_POTION = splash;
    }

    public static enum PotionType {
        MUNDANE(64),
        THICK(32),
        AWKWARD(16),
        NIGHT_VISION(8230, 16422),
        INVISIBILITY(8238, 16430),
        LEAPING(8203, 16395),
        FIRE_RESISTANCE(8227, 16419),
        SWIFTNESS(8194, 16386),
        SLOWNESS(8234, 16426),
        WATER_BREATHING(8237, 16429),
        HEALING(8261, 16453),
        HARMING(8268, 16460),
        POISON(8196, 16388),
        REGENERATION(8193, 16385),
        STRENGTH(8201, 16393),
        WEAKNESS(8232, 16424),
        STRONG_LEAPING(8235, 16427),
        STRONG_SWIFTNESS(8226, 16418),
        STRONG_HEALING(8229, 16421),
        STRONG_HARMING(8236, 16428),
        STRONG_POISON(8228, 16420),
        STRONG_REGENERATION(8225, 16417),
        STRONG_STRENGTH(8233, 8233),
        LONG_NIGHT_VISION(8262, 16454),
        LONG_INVISIBILITY(8270, 16462),
        LONG_LEAPING(8267, 16459),
        LONG_FIRE_RESISTANCE(8259, 16451),
        LONG_SWIFTNESS(8258, 16450),
        LONG_SLOWNESS(8266, 16458),
        LONG_WATER_BREATHING(8269, 16461),
        LONG_POISON(8260, 16452),
        LONG_REGENERATION(8257, 16449),
        LONG_STRENGTH(8265, 16457),
        LONG_WEAKNESS(8264, 16456);

        public static final PotionType[] VALUES;
        private final int potion;
        private final int splash;

        private PotionType(int potion) {
            this(potion, -1);
        }

        private PotionType(int potion, int splash) {
            this.potion = potion;
            this.splash = splash;
        }

        public int getPotion() {
            return this.potion;
        }

        public int getSplash() {
            return this.splash;
        }

        static {
            VALUES = PotionType.values();
        }
    }
}

