/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.stream;

import dev.faultyfunctions.soulgraves.libs.rtag.util.EasyLookup;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandle;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class TStreamTools {
    private static final Object READ_LIMITER;
    private static final boolean USE_FAST_STREAM;
    private static final MethodHandle newFastInputStream;
    private static final MethodHandle readNBT;
    private static final MethodHandle writeNBT;

    TStreamTools() {
    }

    public static Object getReadLimiter() {
        return READ_LIMITER;
    }

    public static DataInputStream getDataInput(InputStream input) throws IOException {
        return TStreamTools.getDataInput(input, TStreamTools.isGzipFormat(input));
    }

    public static DataInputStream getDataInput(InputStream input, boolean gzip) throws IOException {
        InputStream in;
        InputStream inputStream = in = gzip ? new GZIPInputStream(input) : input;
        if (USE_FAST_STREAM) {
            try {
                return new DataInputStream(newFastInputStream.invoke(in));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new DataInputStream(new BufferedInputStream(in));
    }

    public static boolean isGzipFormat(File file) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            int ID1 = raf.read();
            if (ID1 <= -1 || ID1 > 255) {
                boolean bl = false;
                return bl;
            }
            int ID2 = raf.read();
            if (ID2 <= -1 || ID2 > 255) {
                boolean bl = false;
                return bl;
            }
            boolean bl = TStreamTools.isGzipHeader(ID1, ID2);
            return bl;
        }
    }

    public static boolean isGzipFormat(InputStream input) throws IOException {
        InputStream in = input.markSupported() ? input : new BufferedInputStream(input);
        in.mark(2);
        int ID1 = in.read();
        if (ID1 <= -1 || ID1 > 255) {
            in.reset();
            return false;
        }
        int ID2 = in.read();
        if (ID2 <= -1 || ID2 > 255) {
            in.reset();
            return false;
        }
        in.reset();
        return TStreamTools.isGzipHeader(ID1, ID2);
    }

    public static boolean isGzipHeader(byte[] bytes) {
        return TStreamTools.isGzipHeader(bytes[0] & 0xFF, bytes[1] & 0xFF);
    }

    public static boolean isGzipHeader(int ID1, int ID2) {
        return (ID2 << 8 | ID1) == 35615;
    }

    public static boolean isNbtHeader(byte[] bytes) {
        return bytes[0] >= 1 && bytes[0] <= 12 && bytes[1] == 0 && bytes[2] == 0;
    }

    public static Object read(File file) throws IOException {
        try (DataInputStream in = TStreamTools.getDataInput(new FileInputStream(file), TStreamTools.isGzipFormat(file));){
            Object object = TStreamTools.read((DataInput)in);
            return object;
        }
    }

    public static Object read(byte[] bytes) throws IOException {
        try (DataInputStream in = TStreamTools.getDataInput(new ByteArrayInputStream(bytes), bytes.length >= 2 && TStreamTools.isGzipHeader(bytes));){
            Object object = TStreamTools.read((DataInput)in);
            return object;
        }
    }

    public static Object read(InputStream input) throws IOException {
        try (DataInputStream in = TStreamTools.getDataInput(input);){
            Object object = TStreamTools.read((DataInput)in);
            return object;
        }
    }

    public static Object read(DataInputStream input) throws IOException {
        return TStreamTools.read((DataInput)input);
    }

    public static Object read(DataInput input) throws IOException {
        try {
            if ((double)ServerInstance.VERSION >= 20.02) {
                return readNBT.invoke(input, TStreamTools.getReadLimiter());
            }
            return readNBT.invoke(input, 0, TStreamTools.getReadLimiter());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void write(Object tag, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            TStreamTools.write(tag, out);
        }
    }

    public static void write(Object tag, OutputStream output) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(output)));){
            TStreamTools.write(tag, (DataOutput)out);
        }
    }

    public static void write(Object tag, DataOutputStream output) throws IOException {
        TStreamTools.write(tag, (DataOutput)output);
    }

    public static void write(Object tag, DataOutput output) throws IOException {
        try {
            writeNBT.invoke(tag, output);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        try {
            EasyLookup.addNMSClass("nbt.NBTCompressedStreamTools", "NbtIo");
            EasyLookup.addNMSClass("nbt.NBTReadLimiter", "NbtAccounter");
            if (ServerInstance.MAJOR_VERSION >= 18) {
                EasyLookup.addNMSClass("util.FastBufferedInputStream");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        USE_FAST_STREAM = ServerInstance.MAJOR_VERSION >= 18;
        MethodHandle new$FastInputStream = null;
        MethodHandle method$read = null;
        MethodHandle method$write = null;
        MethodHandle get$unlimited = null;
        try {
            String read = "a";
            String write = "a";
            String unlimited = "a";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                read = "readUnnamedTag";
                write = "writeUnnamedTag";
                unlimited = (double)ServerInstance.VERSION >= 20.02 ? "unlimitedHeap" : "UNLIMITED";
            } else if ((double)ServerInstance.VERSION >= 20.02) {
                read = "c";
                write = "b";
            }
            if (USE_FAST_STREAM) {
                new$FastInputStream = EasyLookup.constructor("FastBufferedInputStream", InputStream.class);
            }
            method$read = (double)ServerInstance.VERSION >= 20.02 ? EasyLookup.staticMethod("NBTCompressedStreamTools", read, "NBTBase", DataInput.class, "NBTReadLimiter") : EasyLookup.staticMethod("NBTCompressedStreamTools", read, "NBTBase", DataInput.class, Integer.TYPE, "NBTReadLimiter");
            method$write = EasyLookup.staticMethod("NBTCompressedStreamTools", write, Void.TYPE, "NBTBase", DataOutput.class);
            get$unlimited = (double)ServerInstance.VERSION >= 20.02 ? EasyLookup.staticMethod("NBTReadLimiter", unlimited, "NBTReadLimiter", new Object[0]) : EasyLookup.staticGetter("NBTReadLimiter", unlimited, "NBTReadLimiter");
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        newFastInputStream = new$FastInputStream;
        readNBT = method$read;
        writeNBT = method$write;
        Object readLimiter = null;
        try {
            readLimiter = get$unlimited != null ? get$unlimited.invoke() : ((double)ServerInstance.VERSION >= 20.02 ? EasyLookup.classById("NBTReadLimiter").getDeclaredConstructor(Long.TYPE, Integer.TYPE).newInstance(Long.MAX_VALUE, 512) : EasyLookup.classById("NBTReadLimiter").getDeclaredConstructor(Long.TYPE).newInstance(Long.MAX_VALUE));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        READ_LIMITER = readLimiter;
    }
}

