/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.tag;

import dev.faultyfunctions.soulgraves.libs.rtag.RtagMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import dev.faultyfunctions.soulgraves.libs.rtag.util.EasyLookup;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ThrowableFunction;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class TagBase {
    private static final Class<?> NBT_BASE = EasyLookup.classById("NBTBase");
    private static final Map<Class<?>, ThrowableFunction<Object, Object>> newTagFunction = new HashMap();
    private static final Map<Class<?>, ThrowableFunction<Object, Object>> getValueFunction = new HashMap();
    private static final MethodHandle getTypeId;
    private static final MethodHandle tagByte;
    private static final MethodHandle asByte;
    private static final MethodHandle tagByteArray;
    private static final MethodHandle asByteArray;
    private static final MethodHandle tagDouble;
    private static final MethodHandle asDouble;
    private static final MethodHandle tagFloat;
    private static final MethodHandle asFloat;
    private static final MethodHandle tagInt;
    private static final MethodHandle asInt;
    private static final MethodHandle tagIntArray;
    private static final MethodHandle asIntArray;
    private static final MethodHandle tagLong;
    private static final MethodHandle asLong;
    private static final MethodHandle tagLongArray;
    private static final MethodHandle asLongArray;
    private static final MethodHandle tagShort;
    private static final MethodHandle asShort;
    private static final MethodHandle tagString;
    private static final MethodHandle asString;

    TagBase() {
    }

    private static void newFunction(ThrowableFunction<Object, Object> function, Class<?> ... classes) {
        for (Class<?> c : classes) {
            newTagFunction.put(c, function);
        }
    }

    public static Object newTag(Object object) throws IllegalArgumentException {
        if (object == null) {
            return null;
        }
        ThrowableFunction<Object, Object> function = newTagFunction.get(object.getClass());
        if (function == null) {
            throw new IllegalArgumentException("The object type " + object.getClass().getName() + " cannot be used to create NBTBase tag using TagBase class");
        }
        try {
            return function.apply(object);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot create NBTBase object from " + object.getClass().getName() + " object", t);
        }
    }

    public static Object newTag(RtagMirror mirror, Object object) throws IllegalArgumentException {
        try {
            return TagBase.newTag(object);
        }
        catch (IllegalArgumentException e) {
            if (object instanceof List) {
                return TagList.newTag(mirror, (List)object);
            }
            return TagCompound.newTag(mirror, object);
        }
    }

    public static boolean isTag(Object object) {
        return NBT_BASE.isInstance(object);
    }

    public static boolean isTypeOf(Object tag, byte type) {
        return TagBase.getTypeId(tag) == type;
    }

    public static boolean isTypeOf(Object tag1, Object tag2) {
        return TagBase.getTypeId(tag1) == TagBase.getTypeId(tag2);
    }

    public static Object clone(Object tag) {
        return TagBase.newTag(TagBase.getValue(tag));
    }

    public static byte getTypeId(Object tag) {
        try {
            return getTypeId.invoke(tag);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object getValue(Object tag) throws IllegalArgumentException {
        if (tag == null) {
            return null;
        }
        ThrowableFunction<Object, Object> function = getValueFunction.get(tag.getClass());
        if (function == null) {
            throw new IllegalArgumentException("The object type " + tag.getClass().getName() + " is not supported by TagBase class");
        }
        try {
            return function.apply(tag);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get java object from " + tag.getClass().getName() + " class", t);
        }
    }

    public static Object getValue(RtagMirror mirror, Object tag) throws IllegalArgumentException {
        try {
            return TagBase.getValue(tag);
        }
        catch (IllegalArgumentException e) {
            if (TagCompound.isTagCompound(tag)) {
                return TagCompound.getValue(mirror, tag);
            }
            if (TagList.isTagList(tag)) {
                return TagList.getValue(mirror, tag);
            }
            throw e;
        }
    }

    public static int size(Object tag) {
        if (TagCompound.isTagCompound(tag)) {
            return TagCompound.getValue(tag).size();
        }
        if (TagList.isTagList(tag)) {
            return TagList.size(tag);
        }
        return -1;
    }

    public static void clear(Object tag) {
        if (TagCompound.isTagCompound(tag)) {
            TagCompound.clear(tag);
        } else if (TagList.isTagList(tag)) {
            TagList.clear(tag);
        }
    }

    static {
        MethodHandle method$getTypeId = null;
        MethodHandle new$Byte = null;
        MethodHandle new$ByteArray = null;
        MethodHandle new$Double = null;
        MethodHandle new$Float = null;
        MethodHandle new$Int = null;
        MethodHandle new$IntArray = null;
        MethodHandle new$Long = null;
        MethodHandle new$LongArray = null;
        MethodHandle new$Short = null;
        MethodHandle new$String = null;
        MethodHandle get$Byte = null;
        MethodHandle get$ByteArray = null;
        MethodHandle get$Double = null;
        MethodHandle get$Float = null;
        MethodHandle get$Int = null;
        MethodHandle get$IntArray = null;
        MethodHandle get$Long = null;
        MethodHandle get$LongArray = null;
        MethodHandle get$Short = null;
        MethodHandle get$String = null;
        try {
            String data;
            String getTypeId = "getTypeId";
            String asByte = data = "data";
            String asDouble = data;
            String asFloat = data;
            String asInt = data;
            String asLong = data;
            String asShort = data;
            String asLongArray = "b";
            String asString2 = data;
            if (ServerInstance.Type.MOJANG_MAPPED) {
                getTypeId = "getId";
                asLongArray = "data";
                if ((double)ServerInstance.VERSION >= 21.04) {
                    asByte = "value";
                    asDouble = "value";
                    asFloat = "value";
                    asInt = "value";
                    asLong = "value";
                    asShort = "value";
                    asString2 = "value";
                }
            } else {
                if (ServerInstance.MAJOR_VERSION == 13 || ServerInstance.MAJOR_VERSION == 14) {
                    asLongArray = "f";
                }
                if (ServerInstance.Release.UNIVERSAL) {
                    data = "c";
                    asByte = "x";
                    asDouble = "w";
                    asFloat = "w";
                    asInt = "c";
                    asLong = "c";
                    asShort = "c";
                    asLongArray = "c";
                    asString2 = "A";
                }
                if (ServerInstance.MAJOR_VERSION >= 18) {
                    getTypeId = "a";
                }
                if ((double)ServerInstance.VERSION >= 19.02) {
                    getTypeId = "b";
                }
                if ((double)ServerInstance.VERSION >= 21.04) {
                    asByte = "v";
                    asDouble = "c";
                    asFloat = "c";
                    asInt = "b";
                    asLong = "b";
                    asShort = "b";
                    asString2 = "b";
                }
            }
            method$getTypeId = EasyLookup.method(NBT_BASE, getTypeId, Byte.TYPE, new Object[0]);
            new$Byte = EasyLookup.unreflectConstructor("NBTTagByte", Byte.TYPE);
            get$Byte = EasyLookup.getter("NBTTagByte", asByte, Byte.TYPE);
            new$ByteArray = EasyLookup.unreflectConstructor("NBTTagByteArray", byte[].class);
            get$ByteArray = EasyLookup.getter("NBTTagByteArray", data, byte[].class);
            new$Double = EasyLookup.unreflectConstructor("NBTTagDouble", Double.TYPE);
            get$Double = EasyLookup.getter("NBTTagDouble", asDouble, Double.TYPE);
            new$Float = EasyLookup.unreflectConstructor("NBTTagFloat", Float.TYPE);
            get$Float = EasyLookup.getter("NBTTagFloat", asFloat, Float.TYPE);
            new$Int = EasyLookup.unreflectConstructor("NBTTagInt", Integer.TYPE);
            get$Int = EasyLookup.getter("NBTTagInt", asInt, Integer.TYPE);
            new$IntArray = EasyLookup.unreflectConstructor("NBTTagIntArray", "int[]");
            get$IntArray = EasyLookup.getter("NBTTagIntArray", data, "int[]");
            new$Long = EasyLookup.unreflectConstructor("NBTTagLong", Long.TYPE);
            get$Long = EasyLookup.getter("NBTTagLong", asLong, Long.TYPE);
            if (ServerInstance.MAJOR_VERSION >= 12) {
                new$LongArray = EasyLookup.unreflectConstructor("NBTTagLongArray", "long[]");
                get$LongArray = EasyLookup.getter("NBTTagLongArray", asLongArray, "long[]");
            }
            new$Short = EasyLookup.unreflectConstructor("NBTTagShort", Short.TYPE);
            get$Short = EasyLookup.getter("NBTTagShort", asShort, Short.TYPE);
            new$String = EasyLookup.unreflectConstructor("NBTTagString", String.class);
            get$String = EasyLookup.getter("NBTTagString", asString2, String.class);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        getTypeId = method$getTypeId;
        tagByte = new$Byte;
        tagByteArray = new$ByteArray;
        tagDouble = new$Double;
        tagFloat = new$Float;
        tagInt = new$Int;
        tagIntArray = new$IntArray;
        tagLong = new$Long;
        tagLongArray = new$LongArray;
        tagShort = new$Short;
        tagString = new$String;
        asByte = get$Byte;
        asByteArray = get$ByteArray;
        asDouble = get$Double;
        asFloat = get$Float;
        asInt = get$Int;
        asIntArray = get$IntArray;
        asLong = get$Long;
        asLongArray = get$LongArray;
        asShort = get$Short;
        asString = get$String;
        TagBase.newFunction((ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagByte), Byte.TYPE, Byte.class);
        TagBase.newFunction(bool -> tagByte.invoke((Boolean)bool != false ? (byte)1 : (byte)0), Boolean.TYPE, Boolean.class);
        getValueFunction.put(EasyLookup.classById("NBTTagByte"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asByte));
        newTagFunction.put(EasyLookup.classById("byte[]"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagByteArray));
        getValueFunction.put(EasyLookup.classById("NBTTagByteArray"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asByteArray));
        TagBase.newFunction((ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagDouble), Double.TYPE, Double.class);
        getValueFunction.put(EasyLookup.classById("NBTTagDouble"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asDouble));
        TagBase.newFunction((ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagFloat), Float.TYPE, Float.class);
        getValueFunction.put(EasyLookup.classById("NBTTagFloat"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asFloat));
        TagBase.newFunction((ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagInt), Integer.TYPE, Integer.class);
        getValueFunction.put(EasyLookup.classById("NBTTagInt"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asInt));
        newTagFunction.put(EasyLookup.classById("int[]"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagIntArray));
        getValueFunction.put(EasyLookup.classById("NBTTagIntArray"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asIntArray));
        TagBase.newFunction((ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagLong), Long.TYPE, Long.class);
        getValueFunction.put(EasyLookup.classById("NBTTagLong"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asLong));
        if (ServerInstance.MAJOR_VERSION >= 12) {
            newTagFunction.put(EasyLookup.classById("long[]"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagLongArray));
            getValueFunction.put(EasyLookup.classById("NBTTagLongArray"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asLongArray));
        }
        TagBase.newFunction((ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagShort), Short.TYPE, Short.class);
        getValueFunction.put(EasyLookup.classById("NBTTagShort"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asShort));
        newTagFunction.put(String.class, (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)tagString));
        newTagFunction.put(UUID.class, uuid -> tagString.invoke(uuid.toString()));
        getValueFunction.put(EasyLookup.classById("NBTTagString"), (ThrowableFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)asString));
    }
}

