/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.tag;

import dev.faultyfunctions.soulgraves.libs.rtag.RtagMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.util.EasyLookup;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;

public class TagList {
    private static final Class<?> NBT_LIST = EasyLookup.classById("NBTTagList");
    private static final MethodHandle newEmpty;
    private static final MethodHandle newList;
    private static final MethodHandle clone;
    private static final MethodHandle getTypeField;
    private static final MethodHandle setTypeField;
    private static final MethodHandle getListField;
    private static final MethodHandle setListField;

    TagList() {
    }

    public static Object newTag() {
        try {
            return newEmpty.invoke();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> Object newTag(List<T> list) {
        if (list == null || list.isEmpty()) {
            return TagList.newTag();
        }
        try {
            list.addAll(List.of());
        }
        catch (UnsupportedOperationException e) {
            return TagList.newTag(new ArrayList<T>(list));
        }
        return TagList.newUncheckedTag(list);
    }

    public static <T> Object newUncheckedTag(List<T> list) {
        try {
            if ((double)ServerInstance.VERSION >= 21.04) {
                return newList.invoke(list);
            }
            byte type = TagBase.getTypeId(list.get(0));
            if (ServerInstance.MAJOR_VERSION >= 15) {
                return newList.invoke(list, type);
            }
            Object tag = TagList.newTag();
            setTypeField.invoke(tag, type);
            try {
                setListField.invoke(tag, list);
            }
            catch (ClassCastException e) {
                TagList.getValue(tag).addAll(list);
            }
            return tag;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> Object newTag(RtagMirror mirror, List<T> list) {
        if (list == null || list.isEmpty()) {
            return TagList.newTag();
        }
        ArrayList<Object> tags = new ArrayList<Object>();
        for (T value : list) {
            tags.add(mirror.newTag(value));
        }
        return TagList.newUncheckedTag(tags);
    }

    public static boolean isTagList(Object object) {
        return NBT_LIST.isInstance(object);
    }

    public static Object clone(Object tag) {
        try {
            return clone.invoke(tag);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object clone(Object tag, BiPredicate<Object, Integer> filter) {
        List<Object> list = TagList.getValue(tag);
        if (list.isEmpty()) {
            return TagList.newTag();
        }
        ArrayList<Object> listCopy = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (!filter.test(o, i)) continue;
            listCopy.add(o);
        }
        return TagList.newUncheckedTag(listCopy);
    }

    public static List<Object> getValue(Object tag) {
        try {
            return getListField.invoke(tag);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static List<Object> getValue(RtagMirror mirror, Object tag) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (tag != null) {
            for (Object object : TagList.getValue(tag)) {
                list.add(mirror.getTagValue(object));
            }
        }
        return list;
    }

    @Deprecated
    public static byte getType(Object tag) {
        if ((double)ServerInstance.VERSION >= 21.04) {
            Iterator<Object> iterator2 = TagList.getValue(tag).iterator();
            if (iterator2.hasNext()) {
                Object o = iterator2.next();
                return TagBase.getTypeId(o);
            }
            return 0;
        }
        return TagList.getType0(tag);
    }

    private static byte getType0(Object tag) {
        try {
            return getTypeField.invoke(tag);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static int size(Object tag) {
        return TagList.getValue(tag).size();
    }

    public static boolean contains(Object listTag, Object tag) {
        return TagList.getValue(listTag).contains(tag);
    }

    public static void add(Object listTag, Object tag) {
        if ((double)ServerInstance.VERSION < 21.04) {
            byte listType = TagList.getType0(listTag);
            if (listType == 0) {
                TagList.setType0(listTag, TagBase.getTypeId(tag));
            } else if (!TagBase.isTypeOf(tag, listType)) {
                return;
            }
        }
        TagList.getValue(listTag).add(tag);
    }

    public static void add(Object listTag, Object ... tags) {
        if ((double)ServerInstance.VERSION < 21.04) {
            byte listType = TagList.getType0(listTag);
            if (listType == 0) {
                TagList.setType0(listTag, TagBase.getTypeId(tags[0]));
            } else if (!TagBase.isTypeOf(tags[0], TagList.getType0(listTag))) {
                return;
            }
        }
        List<Object> list = TagList.getValue(listTag);
        for (Object tag : tags) {
            list.add(tag);
        }
    }

    public static Object remove(Object tag, int index) {
        return TagList.getValue(tag).remove(index);
    }

    public static void set(Object listTag, int index, Object tag) {
        TagList.getValue(listTag).set(index, tag);
    }

    @Deprecated
    public static void setType(Object tag, byte type) {
        if ((double)ServerInstance.VERSION >= 21.04) {
            return;
        }
        TagList.setType0(tag, type);
    }

    private static void setType0(Object tag, byte type) {
        try {
            setTypeField.invoke(tag, type);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void setValue(Object tag, List<Object> list) {
        if (list.isEmpty()) {
            TagList.clear(tag);
        } else {
            try {
                if ((double)ServerInstance.VERSION < 21.04) {
                    byte type = TagBase.getTypeId(list.get(0));
                    setTypeField.invoke(tag, type);
                }
                setListField.invoke(tag, list);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static Object get(Object tag, int index) {
        List<Object> value = TagList.getValue(tag);
        return value.get(index >= 0 ? index : value.size() + index);
    }

    public static void clear(Object tag) {
        TagList.getValue(tag).clear();
        TagList.setType(tag, (byte)0);
    }

    static {
        MethodHandle new$EmptyList = null;
        MethodHandle new$List = null;
        MethodHandle method$clone = null;
        MethodHandle get$type = null;
        MethodHandle get$list = null;
        MethodHandle set$type = null;
        MethodHandle set$list = null;
        try {
            String clone = "clone";
            String type = "type";
            String list = "list";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                clone = "copy";
            } else {
                if (ServerInstance.MAJOR_VERSION >= 10 && ServerInstance.MAJOR_VERSION <= 13) {
                    clone = "d";
                }
                if (ServerInstance.Release.UNIVERSAL) {
                    type = "w";
                    list = "c";
                }
                if (ServerInstance.MAJOR_VERSION >= 18) {
                    clone = "d";
                }
                if ((double)ServerInstance.VERSION >= 19.03) {
                    clone = "e";
                }
                if ((double)ServerInstance.VERSION >= 21.04) {
                    list = "v";
                    clone = "g";
                }
            }
            new$EmptyList = EasyLookup.constructor(NBT_LIST, new Object[0]);
            if ((double)ServerInstance.VERSION >= 21.04) {
                new$List = EasyLookup.constructor(NBT_LIST, List.class);
            } else if (ServerInstance.MAJOR_VERSION >= 15) {
                new$List = EasyLookup.constructor(NBT_LIST, List.class, Byte.TYPE);
            }
            method$clone = EasyLookup.method(NBT_LIST, clone, NBT_LIST, new Object[0]);
            if ((double)ServerInstance.VERSION < 21.04) {
                get$type = EasyLookup.getter(NBT_LIST, type, Byte.TYPE);
                set$type = EasyLookup.setter(NBT_LIST, type, Byte.TYPE);
            }
            get$list = EasyLookup.getter(NBT_LIST, list, List.class);
            set$list = EasyLookup.setter(NBT_LIST, list, List.class);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        newEmpty = new$EmptyList;
        newList = new$List;
        clone = method$clone;
        getTypeField = get$type;
        setTypeField = set$type;
        getListField = get$list;
        setListField = set$list;
    }
}

