/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.faultyfunctions.soulgraves.libs.rtag.RtagMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.data.ComponentType;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import dev.faultyfunctions.soulgraves.libs.rtag.util.EasyLookup;
import dev.faultyfunctions.soulgraves.libs.rtag.util.OptionalType;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class ChatComponent {
    public static final String[] NBT_PALETTE;
    public static final String[] NBT_PALETTE_HEX;
    public static final String[] NBT_PALETTE_BUNGEE;
    public static final String[] NBT_PALETTE_MINIMESSAGE;
    private static final Class<?> CHAT_BASE_COMPONENT;
    private static final Gson GSON;
    private static final char[] RAW_SUFFIX;
    private static final MethodHandle fromString;
    private static final MethodHandle fromComponent;
    private static final MethodHandle fromJson;
    private static final MethodHandle toJson;
    private static final Object COMPONENT_CODEC;

    ChatComponent() {
    }

    public static boolean isChatComponent(Object object) {
        if (object instanceof String) {
            String s = (String)object;
            if (s.length() > 11) {
                int index;
                if (s.charAt(0) == '{' && s.charAt(s.length() - 1) == '}' && (index = s.indexOf("\"text\":\"")) > 0) {
                    char c;
                    int i = s.indexOf(34, index + 8) + 1;
                    return i + 1 >= s.length() || (c = s.charAt(i)) == '}' || c == ',';
                }
            } else if (s.length() == 11) {
                return s.equals("{\"text\":\"\"}");
            }
            return false;
        }
        return CHAT_BASE_COMPONENT.isInstance(object);
    }

    public static Object fromJson(String json) {
        try {
            if (json == null || json.isEmpty()) {
                return null;
            }
            if (ServerInstance.Release.COMPONENT) {
                JsonElement element;
                try {
                    element = new JsonParser().parse(json);
                }
                catch (JsonSyntaxException e) {
                    element = new JsonObject();
                    element.getAsJsonObject().addProperty("text", json);
                }
                if (element == null) {
                    return null;
                }
                if (ServerInstance.VERSION >= 21.04f) {
                    ChatComponent.updateJson(element);
                }
                return Serialization.parseJson(element);
            }
            return fromJson.invoke(json);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void updateJson(JsonElement element) {
        if (element == null) {
            return;
        }
        if (element.isJsonObject()) {
            JsonElement clickEvent;
            JsonObject object = element.getAsJsonObject();
            JsonElement hoverEvent = object.remove("hoverEvent");
            if (hoverEvent != null && hoverEvent.isJsonObject() && ChatComponent.updateHoverEvent(hoverEvent.getAsJsonObject())) {
                object.add("hover_event", hoverEvent);
            }
            if ((clickEvent = object.remove("clickEvent")) != null && clickEvent.isJsonObject() && ChatComponent.updateClickEvent(clickEvent.getAsJsonObject())) {
                object.add("click_event", clickEvent);
            }
            ChatComponent.updateJson(object.get("extra"));
        } else if (element.isJsonArray()) {
            for (JsonElement e : element.getAsJsonArray()) {
                ChatComponent.updateJson(e);
            }
        }
    }

    private static boolean updateHoverEvent(JsonObject hoverEvent) {
        JsonElement contents;
        JsonElement jsonAction = hoverEvent.get("action");
        if (jsonAction == null || !jsonAction.isJsonPrimitive()) {
            return false;
        }
        String action = jsonAction.getAsJsonPrimitive().getAsString();
        JsonElement value = hoverEvent.remove("value");
        if (value != null && !value.isJsonNull()) {
            switch (action) {
                case "show_text": {
                    hoverEvent.add("contents", value);
                    break;
                }
                case "show_item": {
                    if (!value.isJsonPrimitive()) break;
                    hoverEvent.add("contents", ChatComponent.tagToJson(TagCompound.newTag(value.getAsString())));
                    break;
                }
                case "show_entity": {
                    if (!value.isJsonPrimitive() || !(value = ChatComponent.tagToJson(TagCompound.newTag(value.getAsString()))).isJsonObject()) break;
                    JsonElement name = value.getAsJsonObject().remove("name");
                    if (name != null && name.isJsonPrimitive()) {
                        value.getAsJsonObject().add("name", new JsonParser().parse(name.getAsString()));
                    }
                    hoverEvent.add("contents", value);
                    break;
                }
            }
        }
        if ((contents = hoverEvent.remove("contents")) == null) {
            return false;
        }
        switch (action) {
            case "show_text": {
                hoverEvent.add("value", contents);
                break;
            }
            case "show_item": {
                if (contents.isJsonPrimitive()) {
                    hoverEvent.add("id", contents);
                    break;
                }
                if (!contents.isJsonObject()) break;
                for (Map.Entry entry : contents.getAsJsonObject().entrySet()) {
                    hoverEvent.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                break;
            }
            case "show_entity": {
                if (!contents.isJsonObject()) break;
                for (Map.Entry entry : contents.getAsJsonObject().entrySet()) {
                    if (((String)entry.getKey()).equals("id")) {
                        hoverEvent.add("uuid", (JsonElement)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("type")) {
                        hoverEvent.add("id", (JsonElement)entry.getValue());
                        continue;
                    }
                    hoverEvent.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                break;
            }
        }
        return true;
    }

    private static boolean updateClickEvent(JsonObject clickEvent) {
        JsonElement jsonAction = clickEvent.get("action");
        JsonElement jsonValue = clickEvent.remove("value");
        if (jsonAction == null || !jsonAction.isJsonPrimitive() || jsonValue == null || !jsonValue.isJsonPrimitive()) {
            return false;
        }
        String action = jsonAction.getAsString();
        String value = jsonValue.getAsString();
        switch (action) {
            case "open_url": {
                String s = value.toLowerCase();
                if (!s.startsWith("https://") && !s.startsWith("http://")) {
                    return false;
                }
                clickEvent.add("url", jsonValue);
                break;
            }
            case "open_file": {
                clickEvent.add("path", jsonValue);
                break;
            }
            case "run_command": 
            case "suggest_command": {
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c != '\u00a7' && c >= ' ' && c != '\u007f') continue;
                    return false;
                }
                clickEvent.add("command", jsonValue);
                break;
            }
            case "change_page": {
                int page;
                try {
                    page = Integer.parseInt(value);
                }
                catch (Throwable t) {
                    return false;
                }
                clickEvent.addProperty("page", (Number)Math.max(page, 1));
                break;
            }
            case "copy_to_clipboard": {
                clickEvent.add("value", jsonValue);
                break;
            }
        }
        return true;
    }

    public static Object fromString(String string) {
        try {
            if (ServerInstance.MAJOR_VERSION >= 13) {
                return fromString.invoke(string);
            }
            return string == null || string.isEmpty() ? null : fromString.invoke(string)[0];
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object fromTag(Object tag) {
        Object currentTag = ServerInstance.VERSION < 21.04f ? (TagList.isTagList(tag) ? ChatComponent.downgradeTagList(TagList.clone(tag)) : (TagCompound.isTagCompound(tag) ? ChatComponent.downgradeTagCompound(TagCompound.clone(tag)) : tag)) : tag;
        if (ServerInstance.Release.COMPONENT) {
            return Serialization.parseNbt(currentTag);
        }
        return ChatComponent.fromJson(GSON.toJson(ChatComponent.tagToJson(currentTag)));
    }

    private static void downgradeTag(Object tag) {
        if (TagCompound.isTagCompound(tag)) {
            ChatComponent.downgradeTagCompound(tag);
        } else if (TagList.isTagList(tag)) {
            ChatComponent.downgradeTagList(tag);
        }
    }

    private static Object downgradeTagList(Object tag) {
        for (Object element : TagList.getValue(tag)) {
            ChatComponent.downgradeTag(element);
        }
        return tag;
    }

    private static Object downgradeTagCompound(Object tag) {
        Object clickEvent;
        Map<String, Object> map = TagCompound.getValue(tag);
        Object hoverEvent = map.remove("hover_event");
        if (TagCompound.isTagCompound(hoverEvent) && ChatComponent.downgradeHoverEvent(TagCompound.getValue(hoverEvent))) {
            map.put("hoverEvent", hoverEvent);
        }
        if (TagCompound.isTagCompound(clickEvent = map.remove("click_event")) && ChatComponent.downgradeClickEvent(TagCompound.getValue(clickEvent))) {
            map.put("clickEvent", clickEvent);
        }
        ChatComponent.downgradeTag(map.get("extra"));
        return tag;
    }

    private static boolean downgradeHoverEvent(Map<String, Object> hoverEvent) {
        HashMap contents;
        String action;
        Object tagAction = hoverEvent.get("action");
        if (tagAction == null || TagBase.getTypeId(tagAction) != 8) {
            return false;
        }
        switch (action = (String)TagBase.getValue(tagAction)) {
            case "show_text": {
                Object value = hoverEvent.get("value");
                if (value == null) {
                    return false;
                }
                hoverEvent.put("contents", value);
                return true;
            }
            case "show_item": {
                contents = new HashMap();
                hoverEvent.entrySet().removeIf(entry -> {
                    if (((String)entry.getKey()).equals("action")) {
                        return false;
                    }
                    contents.put((String)entry.getKey(), entry.getValue());
                    return true;
                });
                break;
            }
            case "show_entity": {
                contents = new HashMap();
                hoverEvent.entrySet().removeIf(entry -> {
                    switch ((String)entry.getKey()) {
                        case "action": {
                            return false;
                        }
                        case "uuid": {
                            contents.put("id", entry.getValue());
                            break;
                        }
                        case "id": {
                            contents.put("type", entry.getValue());
                            break;
                        }
                        default: {
                            contents.put((String)entry.getKey(), entry.getValue());
                        }
                    }
                    return true;
                });
                break;
            }
            default: {
                return true;
            }
        }
        if (contents.isEmpty()) {
            return false;
        }
        hoverEvent.put("contents", contents);
        return true;
    }

    private static boolean downgradeClickEvent(Map<String, Object> clickEvent) {
        String key;
        String action;
        Object tagAction = clickEvent.get("action");
        if (tagAction == null || TagBase.getTypeId(tagAction) != 8) {
            return false;
        }
        switch (action = (String)TagBase.getValue(tagAction)) {
            case "open_url": {
                key = "url";
                break;
            }
            case "open_file": {
                key = "path";
                break;
            }
            case "run_command": 
            case "suggest_command": {
                key = "command";
                break;
            }
            case "change_page": {
                Object page = clickEvent.get("page");
                if (page == null) {
                    return false;
                }
                clickEvent.put("value", TagBase.newTag(String.valueOf(TagBase.getValue(page))));
                return true;
            }
            default: {
                return true;
            }
        }
        Object value = clickEvent.get(key);
        if (value == null) {
            return false;
        }
        clickEvent.put("value", value);
        return true;
    }

    private static JsonElement tagToJson(Object tag) {
        if (tag == null) {
            return JsonNull.INSTANCE;
        }
        Object value = TagBase.getValue(RtagMirror.INSTANCE, tag);
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        switch (TagBase.getTypeId(tag)) {
            case 0: {
                return JsonNull.INSTANCE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new JsonPrimitive((Number)value);
            }
            case 8: {
                return new JsonPrimitive((String)value);
            }
            case 7: 
            case 11: 
            case 12: {
                int size = Array.getLength(value);
                JsonArray array = new JsonArray(size);
                for (int i = 0; i < size; ++i) {
                    Object element = Array.get(value, i);
                    array.add((JsonElement)new JsonPrimitive((Number)element));
                }
                return array;
            }
            case 9: {
                JsonArray list = new JsonArray(((List)value).size());
                for (Object o : (List)value) {
                    JsonElement element = ChatComponent.tagToJson(o);
                    list.add(element);
                }
                return list;
            }
            case 10: {
                JsonObject map = new JsonObject();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    JsonElement element = ChatComponent.tagToJson(entry.getValue());
                    map.add(String.valueOf(entry.getKey()), element);
                }
                return map;
            }
        }
        throw new IllegalArgumentException("Invalid tag type: " + tag);
    }

    public static String toJson(Object component) throws IllegalArgumentException {
        if (component instanceof String) {
            Object o = ChatComponent.fromString((String)component);
            if (o == null) {
                return "{\"text\":\"\"}";
            }
            return ChatComponent.toJson(o);
        }
        Objects.requireNonNull(component, "The provided object cannot be null");
        if (!CHAT_BASE_COMPONENT.isInstance(component)) {
            throw new IllegalArgumentException("The provided object isn't an IChatBaseComponent");
        }
        try {
            if (ServerInstance.Release.COMPONENT) {
                JsonElement element = Serialization.encodeJson(component);
                return GSON.toJson(element);
            }
            return toJson.invoke(component);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String toJsonOrNull(Object component) throws IllegalArgumentException {
        if (component instanceof String) {
            return ChatComponent.toJsonOrNull(ChatComponent.fromString((String)component));
        }
        return component == null ? null : ChatComponent.toJson(component);
    }

    public static String toString(Object component) throws IllegalArgumentException {
        if (component instanceof String) {
            Object o = ChatComponent.fromJson((String)component);
            if (o == null) {
                return "";
            }
            return ChatComponent.toString(o);
        }
        Objects.requireNonNull(component, "The provided object cannot be null");
        if (!CHAT_BASE_COMPONENT.isInstance(component)) {
            throw new IllegalArgumentException("The provided object isn't an IChatBaseComponent");
        }
        try {
            return fromComponent.invoke(component);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String toStringOrNull(Object component) throws IllegalArgumentException {
        if (component instanceof String) {
            return ChatComponent.toStringOrNull(ChatComponent.fromJson((String)component));
        }
        return component == null ? null : ChatComponent.toString(component);
    }

    public static Object toTag(Object component) {
        Objects.requireNonNull(component, "The provided object cannot be null");
        if (!CHAT_BASE_COMPONENT.isInstance(component)) {
            throw new IllegalArgumentException("The provided object isn't an IChatBaseComponent");
        }
        if (ServerInstance.Release.COMPONENT) {
            try {
                return Serialization.encodeNbt(component);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        String json = ChatComponent.toJson(component);
        return ChatComponent.tagFromJson(new JsonParser().parse(json));
    }

    public static Object toTagOrNull(Object component) {
        return component == null ? null : ChatComponent.toTag(component);
    }

    private static Object tagFromJson(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return TagBase.newTag(primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                return TagBase.newTag(primitive.getAsNumber());
            }
            if (primitive.isString()) {
                return TagBase.newTag(primitive.getAsString());
            }
        } else {
            if (element.isJsonArray()) {
                JsonPrimitive primitive;
                JsonArray array = element.getAsJsonArray();
                if (array.isEmpty()) {
                    return TagList.newTag();
                }
                JsonElement first = array.get(0);
                if (first.isJsonPrimitive() && (primitive = first.getAsJsonPrimitive()).isNumber()) {
                    Number number = primitive.getAsNumber();
                    if (number instanceof Byte) {
                        byte[] bytes = new byte[array.size()];
                        int i = 0;
                        for (JsonElement e : array) {
                            bytes[i] = e.getAsByte();
                            ++i;
                        }
                        return TagBase.newTag(bytes);
                    }
                    if (number instanceof Integer) {
                        int[] integers = new int[array.size()];
                        int i = 0;
                        for (JsonElement e : array) {
                            integers[i] = e.getAsInt();
                            ++i;
                        }
                        return TagBase.newTag(integers);
                    }
                    if (number instanceof Long) {
                        long[] longs = new long[array.size()];
                        int i = 0;
                        for (JsonElement e : array) {
                            longs[i] = e.getAsLong();
                            ++i;
                        }
                        return TagBase.newTag(longs);
                    }
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (JsonElement e : array) {
                    Object t = ChatComponent.tagFromJson(e);
                    if (t == null) continue;
                    list.add(t);
                }
                return TagList.newUncheckedTag(list);
            }
            if (element.isJsonObject()) {
                JsonObject json = element.getAsJsonObject();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry entry : json.entrySet()) {
                    Object e = ChatComponent.tagFromJson((JsonElement)entry.getValue());
                    if (e == null) continue;
                    map.put((String)entry.getKey(), e);
                }
                return TagCompound.newUncheckedTag(map);
            }
        }
        throw new IllegalArgumentException("Cannot get value from json: " + element);
    }

    public static Object toPrettyComponent(Object tag, String indent) {
        return ChatComponent.toPrettyComponent(tag, indent, NBT_PALETTE);
    }

    public static Object toPrettyComponent(Object tag, String indent, String[] palette) {
        return ChatComponent.fromString(ChatComponent.toPrettyString(tag, indent, palette));
    }

    public static String toPrettyJson(Object tag, String indent) {
        return ChatComponent.toPrettyJson(tag, indent, NBT_PALETTE);
    }

    public static String toPrettyJson(Object tag, String indent, String[] palette) {
        return ChatComponent.toJson(ChatComponent.toPrettyString(tag, indent, palette));
    }

    public static String toPrettyString(Object tag, String indent) {
        return ChatComponent.toPrettyString(tag, indent, NBT_PALETTE);
    }

    public static String toPrettyString(Object tag, String indent, String[] palette) {
        return ChatComponent.pretty(tag, 0, indent == null ? "" : indent, palette);
    }

    private static String pretty(Object tag, int count, String indent, String[] palette) {
        byte id = TagBase.getTypeId(tag);
        if (id < 1 || id > 12) {
            return palette[4] + "null";
        }
        if (id <= 6) {
            return palette[3] + TagBase.getValue(tag) + palette[4] + RAW_SUFFIX[id];
        }
        switch (id) {
            case 7: 
            case 11: 
            case 12: {
                Object suffix = palette[4] + RAW_SUFFIX[id];
                StringJoiner joiner = new StringJoiner(palette[0] + ", ", palette[0] + "[" + (String)suffix + palette[0] + "; ", palette[0] + "]");
                if (id == 11) {
                    suffix = "";
                }
                for (Object o : OptionalType.of(TagBase.getValue(tag))) {
                    joiner.add(palette[3] + o + (String)suffix);
                }
                return joiner.toString();
            }
            case 8: {
                return palette[0] + "\"" + palette[2] + TagBase.getValue(tag) + palette[0] + "\"";
            }
            case 9: {
                return ChatComponent.prettyList(tag, count, indent, palette);
            }
        }
        return ChatComponent.prettyCompound(tag, count, indent, palette);
    }

    private static String prettyList(Object tag, int count, String indent, String[] palette) {
        StringJoiner joiner;
        List<Object> list = TagList.getValue(tag);
        if (list.isEmpty()) {
            return palette[0] + "[]";
        }
        if (indent.isEmpty() || list.size() <= 8 && TagList.getValue(tag).stream().anyMatch(value -> {
            byte id = TagBase.getTypeId(value);
            return id >= 1 && id <= 6;
        })) {
            joiner = new StringJoiner(palette[0] + ", ", palette[0] + "[", palette[0] + "]");
        } else {
            String s = indent.repeat(count + 1);
            joiner = new StringJoiner(palette[0] + ",\n" + s, palette[0] + "[\n" + s, palette[0] + "\n" + indent.repeat(count) + "]");
        }
        for (Object o : list) {
            joiner.add(ChatComponent.pretty(o, count + 1, indent, palette));
        }
        return joiner.toString();
    }

    private static String prettyCompound(Object tag, int count, String indent, String[] palette) {
        StringJoiner joiner;
        Map<String, Object> map = TagCompound.getValue(tag);
        if (map.isEmpty()) {
            return palette[0] + "{}";
        }
        if (indent.isEmpty()) {
            joiner = new StringJoiner(palette[0] + ", ", palette[0] + "{", palette[0] + "}");
        } else {
            String s = indent.repeat(count + 1);
            joiner = new StringJoiner(palette[0] + ",\n" + s, palette[0] + "{\n" + s, palette[0] + "\n" + indent.repeat(count) + "}");
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            joiner.add(palette[1] + entry.getKey() + palette[0] + ": " + ChatComponent.pretty(entry.getValue(), count + 1, indent, palette));
        }
        return joiner.toString();
    }

    static {
        try {
            EasyLookup.addNMSClass("network.chat.IChatBaseComponent", "Component");
            if (ServerInstance.VERSION < 21.05f) {
                EasyLookup.addNMSClassId("ChatSerializer", "network.chat.IChatBaseComponent$ChatSerializer", "network.chat.Component$Serializer");
            }
            EasyLookup.addOBCClass("util.CraftChatMessage");
            if (ServerInstance.Release.COMPONENT) {
                EasyLookup.addNMSClass("network.chat.ComponentSerialization");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        NBT_PALETTE = new String[]{"\u00a7f", "\u00a7b", "\u00a7a", "\u00a76", "\u00a7c"};
        NBT_PALETTE_HEX = new String[]{"\u00a7#FCFCFC", "\u00a7#55E3FF", "\u00a7#55FF71", "\u00a7#FFD500", "\u00a7#FF7155"};
        NBT_PALETTE_BUNGEE = new String[]{"\u00a7x\u00a7F\u00a7C\u00a7F\u00a7C\u00a7F\u00a7C", "\u00a7x\u00a75\u00a75\u00a7E\u00a73\u00a7F\u00a7F", "\u00a7x\u00a75\u00a75\u00a7F\u00a7F\u00a77\u00a71", "\u00a7x\u00a7F\u00a7F\u00a7D\u00a75\u00a70\u00a70", "\u00a7x\u00a7F\u00a7F\u00a77\u00a71\u00a75\u00a75"};
        NBT_PALETTE_MINIMESSAGE = new String[]{"<white>", "<aqua>", "<green>", "<gold>", "<red>"};
        GSON = new GsonBuilder().disableHtmlEscaping().create();
        RAW_SUFFIX = new char[]{'\u0000', 'b', 's', '\u0000', 'L', 'f', 'd', 'B', '\u0000', '\u0000', '\u0000', 'I', 'L'};
        MethodHandle method$fromString = null;
        MethodHandle method$fromComponent = null;
        MethodHandle method$fromJson = null;
        MethodHandle method$toJson = null;
        MethodHandle component$codec = null;
        try {
            String fromJson = "a";
            String toJson = "a";
            String codec = "a";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                fromJson = "fromJson";
                toJson = "toJson";
                codec = "CODEC";
            }
            method$fromString = ServerInstance.MAJOR_VERSION >= 13 ? EasyLookup.staticMethod("CraftChatMessage", "fromStringOrNull", "IChatBaseComponent", String.class) : EasyLookup.unreflectMethod("CraftChatMessage", "fromString", String.class);
            method$fromComponent = EasyLookup.staticMethod("CraftChatMessage", "fromComponent", String.class, "IChatBaseComponent");
            if (ServerInstance.Release.COMPONENT) {
                component$codec = EasyLookup.staticGetter("ComponentSerialization", codec, Codec.class);
            } else {
                method$fromJson = EasyLookup.unreflectMethod("ChatSerializer", fromJson, String.class);
                method$toJson = EasyLookup.staticMethod("ChatSerializer", toJson, String.class, "IChatBaseComponent");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        CHAT_BASE_COMPONENT = EasyLookup.classById("IChatBaseComponent");
        fromString = method$fromString;
        fromComponent = method$fromComponent;
        fromJson = method$fromJson;
        toJson = method$toJson;
        Object componentCodec = null;
        if (component$codec != null) {
            try {
                componentCodec = component$codec.invoke();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        COMPONENT_CODEC = componentCodec;
    }

    private static final class Serialization {
        private Serialization() {
        }

        private static Object parseJson(JsonElement element) {
            return ((Codec)COMPONENT_CODEC).parse((DynamicOps)ComponentType.createGlobalContext(JsonOps.INSTANCE), (Object)element).getOrThrow(JsonParseException::new);
        }

        private static Object parseNbt(Object tag) {
            return ((Codec)COMPONENT_CODEC).parse((DynamicOps)ComponentType.createGlobalContext(ComponentType.NBT_OPS), tag).getOrThrow();
        }

        private static JsonElement encodeJson(Object component) {
            return (JsonElement)((Codec)COMPONENT_CODEC).encodeStart((DynamicOps)ComponentType.createGlobalContext(JsonOps.INSTANCE), component).getOrThrow(JsonParseException::new);
        }

        private static Object encodeNbt(Object component) {
            return ((Codec)COMPONENT_CODEC).encodeStart((DynamicOps)ComponentType.createGlobalContext(ComponentType.NBT_OPS), component).getOrThrow(IllegalArgumentException::new);
        }
    }
}

