/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.util;

import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.util.ArrayList;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public enum EnchantmentTag {
    AQUA_AFFINITY(0, 6, "WATER_WORKER"),
    BANE_OF_ARTHROPODS(0, 18, "DAMAGE_ARTHROPODS"),
    BINDING_CURSE(11, 10, "CURSE_OF_BINDING", "BINDING"),
    BLAST_PROTECTION(0, 3, "PROTECTION_EXPLOSIONS", "EXPLOSIONS_PROTECTION"),
    CHANNELING(13, 68, new String[0]),
    DEPTH_STRIDER(8, 8, new String[0]),
    EFFICIENCY(0, 32, "DIG_SPEED"),
    FEATHER_FALLING(0, 2, "PROTECTION_FALL", "FALL_PROTECTION"),
    FIRE_ASPECT(0, 20, new String[0]),
    FIRE_PROTECTION(0, 1, "PROTECTION_FIRE"),
    FLAME(1, 50, "ARROW_FIRE", "FIRE_ARROW", "FLAME_ARROW"),
    FORTUNE(0, 35, "LOOT_BONUS_BLOCKS"),
    FROST_WALKER(9, 9, new String[0]),
    IMPALING(13, 66, new String[0]),
    INFINITY(1, 51, "ARROW_INFINITE"),
    KNOCKBACK(0, 19, new String[0]),
    LOOTING(0, 21, "LOOT_BONUS_MOBS"),
    LOYALTY(13, 65, new String[0]),
    LUCK_OF_THE_SEA(7, 61, "LUCK", "LUCK_OF_SEA"),
    LURE(7, 62, new String[0]),
    MENDING(9, 70, new String[0]),
    MULTISHOT(14, 52, new String[0]),
    PIERCING(14, 53, new String[0]),
    POWER(1, 48, "ARROW_DAMAGE", "ARROW_POWER"),
    PROJECTILE_PROTECTION(0, 4, "PROTECTION_PROJECTILE"),
    PROTECTION(0, 0, "PROTECTION_ENVIRONMENTAL"),
    PUNCH(11, 49, "ARROW_KNOCKBACK"),
    QUICK_CHARGE(14, 54, "QUICKCHARGE"),
    RESPIRATION(0, 5, "OXYGEN"),
    RIPTIDE(13, 67, new String[0]),
    SHARPNESS(0, 16, "DAMAGE_ALL"),
    SILK_TOUCH(0, 33, new String[0]),
    SMITE(0, 17, "DAMAGE_UNDEAD"),
    SOUL_SPEED(16, 11, new String[0]),
    SWEEPING(11, 22, "SWEEPING_EDGE"),
    SWIFT_SNEAK(19, 12, new String[0]),
    THORNS(4, 7, new String[0]),
    UNBREAKING(0, 34, "DURABILITY"),
    VANISHING_CURSE(11, 71, "CURSE_OF_VANISHING", "VANISHING"),
    DENSITY(21, 81, new String[0]),
    BREACH(21, 82, new String[0]),
    WIND_BURST(21, 83, new String[0]);

    public static final EnchantmentTag[] VALUES;
    public static final EnchantmentTag[] LEGACY_VALUES;
    public static final EnchantmentTag[] SERVER_VALUES;
    public static final String TAG_KEY;
    public static final String STORED_KEY = "StoredEnchantments";
    private final int version;
    private final short id;
    private final String[] aliases;
    private final Enchantment enchantment;

    private EnchantmentTag(int version, int id, String ... aliases) {
        this(version, (short)id, aliases);
    }

    private EnchantmentTag(int version, short id, String ... aliases) {
        this.version = version;
        this.id = id;
        this.aliases = aliases;
        Enchantment enchantment = EnchantmentTag.parseEnchantment(this.name());
        if (enchantment == null) {
            String alias;
            String[] stringArray = aliases;
            int n2 = stringArray.length;
            for (int i = 0; i < n2 && (enchantment = EnchantmentTag.parseEnchantment(alias = stringArray[i])) == null; ++i) {
            }
        }
        this.enchantment = enchantment;
    }

    private static Enchantment parseEnchantment(String s) {
        if (ServerInstance.VERSION >= 20.03f) {
            return (Enchantment)Registry.ENCHANTMENT.match(s);
        }
        if (ServerInstance.Release.FLAT) {
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)s.toLowerCase()));
        }
        return Enchantment.getByName((String)s);
    }

    public int getVersion() {
        return this.version;
    }

    public short getId() {
        return this.id;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public Object getKey() {
        if (ServerInstance.Release.LEGACY) {
            return this.id;
        }
        return "minecraft:" + this.name().toLowerCase();
    }

    public boolean compare(Object name) {
        if (name instanceof Short) {
            return (Short)name == this.id;
        }
        if (name instanceof String) {
            String s = (String)name;
            if (this.name().equalsIgnoreCase(s)) {
                return true;
            }
            for (String alias : this.aliases) {
                if (!alias.equalsIgnoreCase(s)) continue;
                return true;
            }
        } else if (name instanceof Number) {
            try {
                return this.compareKey(Short.parseShort(String.valueOf(name)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean compareKey(Object key) {
        if (key instanceof Short) {
            return (Short)key == this.id;
        }
        if (key instanceof String) {
            return this.name().equalsIgnoreCase(((String)key).replace("minecraft:", ""));
        }
        if (key instanceof Number) {
            try {
                return this.compareKey(Short.parseShort(String.valueOf(key)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Object parseName(Object name) {
        if (name instanceof Short) {
            return name;
        }
        if (name instanceof Number) {
            try {
                return Short.parseShort(String.valueOf(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.valueOf(name).replace("minecraft:", "").toUpperCase().replace(' ', '_');
    }

    public static String getEnchantmentKey(ItemStack item) {
        if (item.getItemMeta() instanceof EnchantmentStorageMeta) {
            return STORED_KEY;
        }
        return TAG_KEY;
    }

    public static EnchantmentTag of(Object name) {
        if (name instanceof EnchantmentTag) {
            return (EnchantmentTag)((Object)name);
        }
        if (name instanceof Enchantment) {
            return EnchantmentTag.of(((Enchantment)name).getName());
        }
        Object finalName = EnchantmentTag.parseName(name);
        for (EnchantmentTag value : VALUES) {
            if (!value.compare(finalName)) continue;
            return value;
        }
        return null;
    }

    static {
        VALUES = EnchantmentTag.values();
        TAG_KEY = ServerInstance.Release.LEGACY ? "ench" : "Enchantments";
        ArrayList<EnchantmentTag> legacy = new ArrayList<EnchantmentTag>();
        ArrayList<EnchantmentTag> server = new ArrayList<EnchantmentTag>();
        for (EnchantmentTag tag : VALUES) {
            if (tag.getVersion() <= 12) {
                legacy.add(tag);
            }
            if (tag.getVersion() > ServerInstance.MAJOR_VERSION) continue;
            server.add(tag);
        }
        LEGACY_VALUES = legacy.toArray(new EnchantmentTag[0]);
        SERVER_VALUES = server.toArray(new EnchantmentTag[0]);
    }
}

