/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.listeners;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.SoulGravesAPI;
import dev.faultyfunctions.soulgraves.compatibilities.VaultHook;
import dev.faultyfunctions.soulgraves.database.MySQLDatabase;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.MessageManager;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.utils.Soul;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Ldev/faultyfunctions/soulgraves/listeners/PlayerConnectionEvent;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onPlayerJoin", "", "e", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerTeleportToSoulCrossServer", "onPlayerLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nPlayerConnectionEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerConnectionEvent.kt\ndev/faultyfunctions/soulgraves/listeners/PlayerConnectionEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1863#2,2:84\n1863#2,2:86\n*S KotlinDebug\n*F\n+ 1 PlayerConnectionEvent.kt\ndev/faultyfunctions/soulgraves/listeners/PlayerConnectionEvent\n*L\n24#1:84,2\n74#1:86,2\n*E\n"})
public final class PlayerConnectionEvent
implements Listener {
    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!ConfigManager.INSTANCE.getOfflineOwnerTimerFreeze()) {
            return;
        }
        long now = System.currentTimeMillis();
        UUID uUID = e.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Soul> playerSouls = SoulGravesAPI.INSTANCE.getPlayerSouls(uUID);
        Iterable $this$forEach$iv = playerSouls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Soul it = (Soul)element$iv;
            boolean bl = false;
            long offlineTime = now - it.getFreezeTime();
            it.setExpireTime(it.getExpireTime() + offlineTime);
            it.setFreezeTime(0L);
            if (DatabaseManagerKt.getSTORAGE_MODE() != StorageType.CROSS_SERVER) continue;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerConnectionEvent.onPlayerJoin$lambda$1$lambda$0(it));
        }
    }

    @EventHandler
    public final void onPlayerTeleportToSoulCrossServer(@NotNull PlayerJoinEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter(e, "e");
            Location location = SoulGraves.Companion.getPendingTeleports().remove(e.getPlayer().getUniqueId());
            if (location == null) break block0;
            Location location2 = location;
            boolean bl = false;
            Bukkit.getScheduler().runTaskLater((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerConnectionEvent.onPlayerTeleportToSoulCrossServer$lambda$6$lambda$5(e, location2), 100L);
        }
    }

    @EventHandler
    public final void onPlayerLeave(@NotNull PlayerQuitEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!ConfigManager.INSTANCE.getOfflineOwnerTimerFreeze()) {
            return;
        }
        long now = System.currentTimeMillis();
        UUID uUID = e.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Soul> playerSouls = SoulGravesAPI.INSTANCE.getPlayerSouls(uUID);
        Iterable $this$forEach$iv = playerSouls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Soul it = (Soul)element$iv;
            boolean bl = false;
            it.setFreezeTime(now);
            if (DatabaseManagerKt.getSTORAGE_MODE() != StorageType.CROSS_SERVER) continue;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerConnectionEvent.onPlayerLeave$lambda$8$lambda$7(it, now));
        }
    }

    private static final void onPlayerJoin$lambda$1$lambda$0(Soul $it) {
        MySQLDatabase.Companion.getInstance().updateSoulFreezeTime($it.getMarkerUUID(), 0L, $it.getExpireTime());
    }

    private static final void onPlayerTeleportToSoulCrossServer$lambda$6$lambda$5(PlayerJoinEvent $e, Location $location) {
        block3: {
            Player player;
            block5: {
                block4: {
                    Player player2 = Bukkit.getPlayer((UUID)$e.getPlayer().getUniqueId());
                    if (player2 == null) {
                        return;
                    }
                    player = player2;
                    if (!player.isOnline()) break block3;
                    if (ConfigManager.INSTANCE.getTeleportCost().compareTo(BigDecimal.ZERO) > 0) break block4;
                    Component component = MessageManager.INSTANCE.getCommandBackSuccessFree();
                    if (component != null) {
                        Component it = component;
                        boolean bl = false;
                        SoulGraves.Companion.getPlugin().adventure().player(player).sendMessage(it);
                    }
                    player.teleport($location);
                    break block3;
                }
                if (!VaultHook.INSTANCE.has(player, ConfigManager.INSTANCE.getTeleportCost())) break block5;
                VaultHook.INSTANCE.withdraw(player, ConfigManager.INSTANCE.getTeleportCost());
                Component component = MessageManager.INSTANCE.getCommandBackSuccessPaid();
                if (component != null) {
                    Component it = component;
                    boolean bl = false;
                    SoulGraves.Companion.getPlugin().adventure().player(player).sendMessage(it);
                }
                player.teleport($location);
                break block3;
            }
            Component component = MessageManager.INSTANCE.getCommandBackNoFundsComponent();
            if (component == null) break block3;
            Component it = component;
            boolean bl = false;
            SoulGraves.Companion.getPlugin().adventure().player(player).sendMessage(it);
        }
    }

    private static final void onPlayerLeave$lambda$8$lambda$7(Soul $it, long $now) {
        MySQLDatabase.Companion.getInstance().updateSoulFreezeTime($it.getMarkerUUID(), $now, $it.getExpireTime());
    }
}

