/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.listeners;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.RedisPublishAPI;
import dev.faultyfunctions.soulgraves.api.SoulGravesAPI;
import dev.faultyfunctions.soulgraves.api.event.SoulPreSpawnEvent;
import dev.faultyfunctions.soulgraves.api.event.SoulSpawnEvent;
import dev.faultyfunctions.soulgraves.listeners.DeathInfo;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.MessageManager;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.utils.Soul;
import dev.faultyfunctions.soulgraves.utils.SpigotCompatUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Ldev/faultyfunctions/soulgraves/listeners/PlayerDeathListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "soulPreSpawnEventMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Ldev/faultyfunctions/soulgraves/api/event/SoulPreSpawnEvent;", "Lkotlin/collections/HashMap;", "getSoulPreSpawnEventMap", "()Ljava/util/HashMap;", "onLowestPlayerDeathEvent", "", "e", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onHighestPlayerDeathEvent", "onMonitorPlayerDeathEvent", "spawnSoulNextTick", "deathInfo", "Ldev/faultyfunctions/soulgraves/listeners/DeathInfo;", "storeInventory", "", "storeXP", "deepCopyItemStack", "Lorg/bukkit/inventory/ItemStack;", "item", "findSafeLocation", "Lorg/bukkit/Location;", "locationToCheck", "explodeOldestSoul", "player", "Lorg/bukkit/entity/Player;", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nPlayerDeathListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerDeathListener.kt\ndev/faultyfunctions/soulgraves/listeners/PlayerDeathListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n12371#2,2:233\n11165#2:235\n11500#2,3:236\n1863#3:239\n1864#3:247\n1863#3,2:248\n1053#3:251\n1863#3,2:252\n535#4:240\n520#4,6:241\n1#5:250\n*S KotlinDebug\n*F\n+ 1 PlayerDeathListener.kt\ndev/faultyfunctions/soulgraves/listeners/PlayerDeathListener\n*L\n76#1:233,2\n92#1:235\n92#1:236,3\n104#1:239\n104#1:247\n211#1:248,2\n188#1:251\n191#1:252,2\n106#1:240\n106#1:241,6\n*E\n"})
public final class PlayerDeathListener
implements Listener {
    @NotNull
    private final HashMap<UUID, SoulPreSpawnEvent> soulPreSpawnEventMap = new HashMap();

    @NotNull
    public final HashMap<UUID, SoulPreSpawnEvent> getSoulPreSpawnEventMap() {
        return this.soulPreSpawnEventMap;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onLowestPlayerDeathEvent(@NotNull PlayerDeathEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        SoulPreSpawnEvent soulPreSpawnEvent = new SoulPreSpawnEvent(e);
        Bukkit.getPluginManager().callEvent((Event)soulPreSpawnEvent);
        if (soulPreSpawnEvent.isNotCancelled()) {
            ((Map)this.soulPreSpawnEventMap).put(e.getEntity().getUniqueId(), soulPreSpawnEvent);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onHighestPlayerDeathEvent(@NotNull PlayerDeathEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (this.soulPreSpawnEventMap.get(e.getEntity().getUniqueId()) == null) {
            return;
        }
        if (ConfigManager.INSTANCE.getSoulsStoreItems()) {
            SoulGraves.Companion.getPlugin().getLogger().info("CALL e.drops.remove(item)");
            for (ItemStack item : e.getEntity().getInventory().getContents()) {
                if (item == null) continue;
                e.getDrops().remove(item);
            }
        }
        if (ConfigManager.INSTANCE.getSoulsStoreXP()) {
            e.setDroppedExp(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.MONITOR)
    public final void onMonitorPlayerDeathEvent(@NotNull PlayerDeathEvent e) {
        void $this$mapTo$iv$iv;
        boolean keepInventoryGameRule;
        boolean bl;
        Object[] it;
        boolean storeInventory;
        SoulPreSpawnEvent soulPreSpawnEvent;
        Player player;
        block8: {
            Intrinsics.checkNotNullParameter(e, "e");
            Player player2 = e.getEntity();
            Intrinsics.checkNotNullExpressionValue(player2, "getEntity(...)");
            player = player2;
            SoulPreSpawnEvent soulPreSpawnEvent2 = this.soulPreSpawnEventMap.remove(player.getUniqueId());
            if (soulPreSpawnEvent2 == null) {
                return;
            }
            soulPreSpawnEvent = soulPreSpawnEvent2;
            if (ConfigManager.INSTANCE.getPermissionRequired() && !player.hasPermission("soulgraves.spawn")) {
                return;
            }
            if (ConfigManager.INSTANCE.getDisabledWorlds().contains(player.getWorld().getName())) {
                return;
            }
            storeInventory = true;
            ItemStack[] itemStackArray = player.getInventory().getContents();
            Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
            Object[] $this$all$iv = itemStackArray;
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                it = (Object[])element$iv;
                boolean bl2 = false;
                if (it == null || it.getType() == Material.AIR) continue;
                bl = false;
                break block8;
            }
            bl = true;
        }
        boolean isInventoryEmpty = bl;
        Boolean bl3 = (Boolean)player.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY);
        boolean bl4 = keepInventoryGameRule = bl3 != null ? bl3 : false;
        if (!ConfigManager.INSTANCE.getSoulsStoreItems() || soulPreSpawnEvent.getKeepInventory() || e.getKeepInventory() || keepInventoryGameRule || isInventoryEmpty) {
            storeInventory = false;
        }
        boolean storeXP = true;
        if (!ConfigManager.INSTANCE.getSoulsStoreXP() || soulPreSpawnEvent.getKeepLevel() || e.getKeepLevel() || player.getLevel() == 0) {
            storeXP = false;
        }
        if (!storeInventory && !storeXP) {
            return;
        }
        ItemStack[] itemStackArray = player.getInventory().getContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
        Object[] $this$map$iv = itemStackArray;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ItemStack itemStack = (ItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(this.deepCopyItemStack((ItemStack)it2));
        }
        List inventoryCopy = (List)destination$iv$iv;
        int n = player.getLevel();
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        DeathInfo deathInfo = new DeathInfo(player, inventoryCopy, n, location);
        this.spawnSoulNextTick(deathInfo, storeInventory, storeXP);
    }

    private final void spawnSoulNextTick(DeathInfo deathInfo, boolean storeInventory, boolean storeXP) {
        Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerDeathListener.spawnSoulNextTick$lambda$4(storeInventory, deathInfo, storeXP, this));
    }

    private final ItemStack deepCopyItemStack(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        return ItemStack.deserialize((Map)item.serialize());
    }

    private final Location findSafeLocation(Location locationToCheck) {
        Location safeLocation = locationToCheck;
        Block block = safeLocation.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        World world = locationToCheck.getWorld();
        Intrinsics.checkNotNull(world);
        World.Environment environment = world.getEnvironment();
        Intrinsics.checkNotNullExpressionValue(environment, "getEnvironment(...)");
        World.Environment environment2 = environment;
        while (block2.getType().isSolid() || block2.isLiquid() || block2.getType() == Material.VOID_AIR) {
            if (environment2 == World.Environment.NETHER) {
                if (locationToCheck.getY() < 128.0 && safeLocation.getY() >= 127.0) {
                    return safeLocation;
                }
                if (locationToCheck.getY() >= 128.0 && safeLocation.getY() >= 254.0) {
                    return safeLocation;
                }
            }
            if (safeLocation.getY() >= 319.0) {
                return safeLocation;
            }
            safeLocation.add(0.0, 1.0, 0.0);
            block2 = safeLocation.getBlock();
        }
        return safeLocation;
    }

    private final void explodeOldestSoul(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerDeathListener.explodeOldestSoul$lambda$15(player));
    }

    /*
     * WARNING - void declaration
     */
    private static final void spawnSoulNextTick$lambda$4(boolean $storeInventory, DeathInfo $deathInfo, boolean $storeXP, PlayerDeathListener this$0) {
        List soulInventory = new ArrayList();
        if ($storeInventory) {
            Iterable $this$forEach$iv = $deathInfo.getInventoryContents();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                ItemStack item = (ItemStack)element$iv;
                boolean bl2 = false;
                if (item != null) {
                    void $this$filterTo$iv$iv;
                    Map $this$filter$iv;
                    Intrinsics.checkNotNullExpressionValue(item.getEnchantments(), "getEnchantments(...)");
                    boolean $i$f$filter = false;
                    Map map = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$filterTo = false;
                    Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv$iv;
                        Map.Entry it = element$iv$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(((Enchantment)it.getKey()).getKey().toString(), "minecraft:vanishing_curse")) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    if (!destination$iv$iv.isEmpty()) continue;
                    bl = soulInventory.add(item);
                    continue;
                }
                bl = soulInventory.add(null);
            }
        }
        int xp = 0;
        if ($storeXP) {
            xp = SpigotCompatUtils.INSTANCE.calculateTotalExperiencePoints($deathInfo.getLevel());
        }
        long deathTime = System.currentTimeMillis();
        long expireTime = deathTime + (long)((ConfigManager.INSTANCE.getTimeStable() + ConfigManager.INSTANCE.getTimeUnstable()) * 1000);
        Location location = $deathInfo.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location safeLocation = this$0.findSafeLocation(location);
        World world = $deathInfo.getLocation().getWorld();
        if (world == null || (world = world.spawnEntity(safeLocation, EntityType.MARKER)) == null) {
            return;
        }
        World marker = world;
        marker.setPersistent(true);
        marker.setSilent(true);
        marker.setInvulnerable(true);
        UUID uUID = $deathInfo.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Soul soul = Soul.Companion.createNewForPlayerDeath(uUID, (Entity)marker, safeLocation, soulInventory, xp, deathTime, expireTime);
        SoulSpawnEvent soulSpawnEvent = new SoulSpawnEvent($deathInfo.getPlayer(), soul);
        Bukkit.getPluginManager().callEvent((Event)soulSpawnEvent);
        if (ConfigManager.INSTANCE.getMaxSoulsPerPlayer() > 0) {
            this$0.explodeOldestSoul($deathInfo.getPlayer());
        }
    }

    private static final void explodeOldestSoul$lambda$15$lambda$10$lambda$8$lambda$7(Soul $soul) {
        $soul.explode();
    }

    private static final Unit explodeOldestSoul$lambda$15$lambda$13(Player $player, List soulList) {
        block2: {
            int toRemove;
            if (soulList.size() <= ConfigManager.INSTANCE.getMaxSoulsPerPlayer() || (toRemove = soulList.size() - ConfigManager.INSTANCE.getMaxSoulsPerPlayer()) <= 0) break block2;
            Intrinsics.checkNotNull(soulList);
            Iterable $this$forEach$iv = CollectionsKt.take(soulList, toRemove);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Soul soul = (Soul)element$iv;
                boolean bl = false;
                RedisPublishAPI.INSTANCE.explodeSoul(soul.getMarkerUUID());
            }
            Component component = MessageManager.INSTANCE.getSoulLimitExplodeComponent();
            if (component != null) {
                Component it = component;
                boolean bl = false;
                SoulGraves.Companion.getPlugin().adventure().player($player).sendMessage(it);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void explodeOldestSoul$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void explodeOldestSoul$lambda$15(Player $player) {
        switch (WhenMappings.$EnumSwitchMapping$0[DatabaseManagerKt.getSTORAGE_MODE().ordinal()]) {
            case 1: {
                List<Soul> list;
                List<Soul> list2;
                UUID uUID = $player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                List<Soul> it = list2 = SoulGravesAPI.INSTANCE.getPlayerSouls(uUID);
                boolean bl = false;
                List<Soul> list3 = list = it.size() > ConfigManager.INSTANCE.getMaxSoulsPerPlayer() ? list2 : null;
                if (list == null) break;
                List<Soul> souls = list;
                boolean bl2 = false;
                Iterable $this$sortedBy$iv = souls;
                boolean $i$f$sortedBy = false;
                List sorted2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Soul it = (Soul)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getExpireTime());
                        it = (Soul)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getExpireTime());
                    }
                });
                int toRemove = souls.size() - ConfigManager.INSTANCE.getMaxSoulsPerPlayer();
                if (toRemove <= 0) break;
                Iterable $this$forEach$iv = CollectionsKt.take(sorted2, toRemove);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Soul soul = (Soul)element$iv;
                    boolean bl3 = false;
                    Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerDeathListener.explodeOldestSoul$lambda$15$lambda$10$lambda$8$lambda$7(soul));
                }
                Component component = MessageManager.INSTANCE.getSoulLimitExplodeComponent();
                if (component != null) {
                    Component it2 = component;
                    boolean bl4 = false;
                    SoulGraves.Companion.getPlugin().adventure().player($player).sendMessage(it2);
                }
                break;
            }
            case 2: {
                UUID uUID = $player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                CompletableFuture<List<Soul>> future = SoulGravesAPI.INSTANCE.getPlayerSoulsCrossServer(uUID);
                future.thenAccept(arg_0 -> PlayerDeathListener.explodeOldestSoul$lambda$15$lambda$14(arg_0 -> PlayerDeathListener.explodeOldestSoul$lambda$15$lambda$13($player, arg_0), arg_0));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.PDC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.CROSS_SERVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

