/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.managers;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.YamlDocument;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.dvs.versioning.BasicVersioning;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.settings.Settings;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.settings.dumper.DumperSettings;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.settings.general.GeneralSettings;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.settings.loader.LoaderSettings;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.settings.updater.UpdaterSettings;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR+\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R+\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Ldev/faultyfunctions/soulgraves/managers/DatabaseManager;", "", "<init>", "()V", "databaseConfig", "Ldev/faultyfunctions/soulgraves/libs/boostedyaml/YamlDocument;", "getDatabaseConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "setDatabaseConfig", "(Ldev/dejvokep/boostedyaml/YamlDocument;)V", "<set-?>", "Ldev/faultyfunctions/soulgraves/managers/StorageType;", "storageMode", "getStorageMode", "()Ldev/faultyfunctions/soulgraves/managers/StorageType;", "setStorageMode", "(Ldev/faultyfunctions/soulgraves/managers/StorageType;)V", "storageMode$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "serverName", "getServerName", "()Ljava/lang/String;", "setServerName", "(Ljava/lang/String;)V", "serverName$delegate", "loadConfig", "", "soulgraves"})
public final class DatabaseManager {
    @NotNull
    public static final DatabaseManager INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    public static YamlDocument databaseConfig;
    @NotNull
    private static final ReadWriteProperty storageMode$delegate;
    @NotNull
    private static final ReadWriteProperty serverName$delegate;

    private DatabaseManager() {
    }

    @NotNull
    public final YamlDocument getDatabaseConfig() {
        YamlDocument yamlDocument = databaseConfig;
        if (yamlDocument != null) {
            return yamlDocument;
        }
        Intrinsics.throwUninitializedPropertyAccessException("databaseConfig");
        return null;
    }

    public final void setDatabaseConfig(@NotNull YamlDocument yamlDocument) {
        Intrinsics.checkNotNullParameter(yamlDocument, "<set-?>");
        databaseConfig = yamlDocument;
    }

    @NotNull
    public final StorageType getStorageMode() {
        return (StorageType)((Object)storageMode$delegate.getValue(this, $$delegatedProperties[0]));
    }

    public final void setStorageMode(@NotNull StorageType storageType) {
        Intrinsics.checkNotNullParameter((Object)storageType, "<set-?>");
        storageMode$delegate.setValue(this, $$delegatedProperties[0], storageType);
    }

    @NotNull
    public final String getServerName() {
        return (String)serverName$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setServerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        serverName$delegate.setValue(this, $$delegatedProperties[1], string);
    }

    public final void loadConfig() {
        try {
            File file = new File(SoulGraves.Companion.getPlugin().getDataFolder(), "database.yml");
            InputStream inputStream = SoulGraves.Companion.getPlugin().getResource("database.yml");
            Intrinsics.checkNotNull(inputStream);
            Settings[] settingsArray = new Settings[]{GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("file-version")).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build()};
            this.setDatabaseConfig(YamlDocument.create(file, inputStream, settingsArray));
            this.getDatabaseConfig().update();
            this.getDatabaseConfig().save();
        }
        catch (IOException iOException) {
            SoulGraves.Companion.getPlugin().getLogger().severe("Failed to load database.yml! The plugin will now shut down.");
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)SoulGraves.Companion.getPlugin());
        }
        String string = this.getDatabaseConfig().getString("storage-mode", "PDC");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        this.setStorageMode(StorageType.valueOf(string));
        this.setServerName(this.getDatabaseConfig().getString("server-name"));
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(DatabaseManager.class, "storageMode", "getStorageMode()Ldev/faultyfunctions/soulgraves/managers/StorageType;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(DatabaseManager.class, "serverName", "getServerName()Ljava/lang/String;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new DatabaseManager();
        storageMode$delegate = Delegates.INSTANCE.notNull();
        serverName$delegate = Delegates.INSTANCE.notNull();
    }
}

