/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.tasks;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.event.SoulExplodeEvent;
import dev.faultyfunctions.soulgraves.database.MessageAction;
import dev.faultyfunctions.soulgraves.database.RedisDatabase;
import dev.faultyfunctions.soulgraves.database.RedisPacket;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.MessageManager;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.utils.Soul;
import dev.faultyfunctions.soulgraves.utils.SoulState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/faultyfunctions/soulgraves/tasks/SoulExplodeTask;", "Lorg/bukkit/scheduler/BukkitRunnable;", "soul", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "<init>", "(Ldev/faultyfunctions/soulgraves/utils/Soul;)V", "getSoul", "()Ldev/faultyfunctions/soulgraves/utils/Soul;", "run", "", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nSoulExplodeTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulExplodeTask.kt\ndev/faultyfunctions/soulgraves/tasks/SoulExplodeTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1863#2,2:105\n1872#2,3:107\n1872#2,3:110\n808#2,11:113\n827#2:124\n855#2,2:125\n1863#2:127\n1872#2,3:129\n1864#2:132\n1#3:128\n*S KotlinDebug\n*F\n+ 1 SoulExplodeTask.kt\ndev/faultyfunctions/soulgraves/tasks/SoulExplodeTask\n*L\n30#1:105,2\n46#1:107,3\n52#1:110,3\n83#1:113,11\n84#1:124\n84#1:125,2\n85#1:127\n90#1:129,3\n85#1:132\n*E\n"})
public final class SoulExplodeTask
extends BukkitRunnable {
    @NotNull
    private final Soul soul;

    public SoulExplodeTask(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        this.soul = soul;
    }

    @NotNull
    public final Soul getSoul() {
        return this.soul;
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        block33: {
            String soundKey;
            int index;
            int n;
            World world;
            if (this.soul.getState() != SoulState.EXPLODING) break block33;
            World world2 = this.soul.getLocation().getWorld();
            if (world2 != null) {
                world2.loadChunk(this.soul.getLocation().getChunk());
            }
            SoulExplodeEvent soulSpawnEvent = new SoulExplodeEvent(this.soul);
            Bukkit.getPluginManager().callEvent((Event)soulSpawnEvent);
            if (soulSpawnEvent.isCancelled()) {
                return;
            }
            if (ConfigManager.INSTANCE.getSoulsDropItems()) {
                Iterable $this$forEach$iv = this.soul.getInventory();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ItemStack i = (ItemStack)element$iv;
                    boolean bl = false;
                    if (i == null) continue;
                    World world3 = this.soul.getLocation().getWorld();
                    if (world3 != null) {
                        world3.dropItemNaturally(this.soul.getLocation(), i);
                    }
                }
            }
            if (ConfigManager.INSTANCE.getSoulsDropXP() && this.soul.getXp() != 0 && (world = this.soul.getLocation().getWorld()) != null && (world = (ExperienceOrb)world.spawn(this.soul.getLocation(), ExperienceOrb.class)) != null) {
                world.setExperience((int)((double)this.soul.getXp() * ConfigManager.INSTANCE.getXpPercentageBurst()));
            }
            Player owner = Bukkit.getPlayer((UUID)this.soul.getOwnerUUID());
            if (ConfigManager.INSTANCE.getBurstSound().getEnabled()) {
                Iterable $this$forEachIndexed$iv = ConfigManager.INSTANCE.getBurstSound().getSounds();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv;
                    index = n;
                    boolean bl = false;
                    World world4 = this.soul.getLocation().getWorld();
                    if (world4 != null) {
                        world4.playSound(this.soul.getLocation(), soundKey, ((Number)ConfigManager.INSTANCE.getBurstSound().getVolumes().get(index)).floatValue(), ((Number)ConfigManager.INSTANCE.getBurstSound().getPitches().get(index)).floatValue());
                    }
                }
            }
            if (ConfigManager.INSTANCE.getNotifyOwnerBurstSound().getEnabled()) {
                Iterable $this$forEachIndexed$iv = ConfigManager.INSTANCE.getNotifyOwnerBurstSound().getSounds();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    soundKey = (String)item$iv;
                    index = n;
                    boolean bl = false;
                    Player player = owner;
                    if (player != null) {
                        player.playSound(owner.getLocation(), soundKey, ((Number)ConfigManager.INSTANCE.getNotifyOwnerBurstSound().getVolumes().get(index)).floatValue(), ((Number)ConfigManager.INSTANCE.getNotifyOwnerBurstSound().getPitches().get(index)).floatValue());
                    }
                }
            }
            World world5 = this.soul.getLocation().getWorld();
            if (world5 != null) {
                world5.spawnParticle(Particle.POOF, this.soul.getLocation().clone().add(0.0, 1.0, 0.0), 50, 0.0, 0.0, 0.0, 0.1, null, true);
            }
            World world6 = this.soul.getLocation().getWorld();
            if (world6 != null) {
                world6.spawnParticle(Particle.END_ROD, this.soul.getLocation().clone().add(0.0, 1.0, 0.0), 200, 0.0, 0.0, 0.0, 0.5, null, true);
            }
            World world7 = this.soul.getLocation().getWorld();
            if (world7 != null) {
                world7.spawnParticle(Particle.SCULK_SOUL, this.soul.getLocation().clone().add(0.0, 1.0, 0.0), 100, 0.0, 0.0, 0.0, 0.1, null, true);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[DatabaseManagerKt.getSTORAGE_MODE().ordinal()]) {
                case 1: {
                    Player player = owner;
                    if (player != null) {
                        Player it = player;
                        boolean bl = false;
                        if (MessageManager.INSTANCE.getSoulBurstComponent() != null) {
                            Audience audience = SoulGraves.Companion.getPlugin().adventure().player(owner);
                            Component component = MessageManager.INSTANCE.getSoulBurstComponent();
                            Intrinsics.checkNotNull(component);
                            audience.sendMessage(component);
                        }
                        if (ConfigManager.INSTANCE.getSoulsDropItems() && MessageManager.INSTANCE.getSoulBurstDropItemsComponent() != null) {
                            Audience audience = SoulGraves.Companion.getPlugin().adventure().player(owner);
                            Component component = MessageManager.INSTANCE.getSoulBurstDropItemsComponent();
                            Intrinsics.checkNotNull(component);
                            audience.sendMessage(component);
                            break;
                        }
                        if (MessageManager.INSTANCE.getSoulBurstLoseItemsComponent() == null) break;
                        Audience audience = SoulGraves.Companion.getPlugin().adventure().player(owner);
                        Component component = MessageManager.INSTANCE.getSoulBurstLoseItemsComponent();
                        Intrinsics.checkNotNull(component);
                        audience.sendMessage(component);
                    }
                    break;
                }
                case 2: {
                    RedisDatabase redisDatabase = RedisDatabase.Companion.getInstance();
                    String string = DatabaseManagerKt.getSERVER_NAME();
                    String string2 = this.soul.getOwnerUUID().toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                    redisDatabase.publish(new RedisPacket(string, MessageAction.NOTIFY_SOUL_EXPLODE, string2));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (ConfigManager.INSTANCE.getNotifyNearbyPlayers()) {
                Collection collection;
                double radii = ConfigManager.INSTANCE.getNotifyRadius();
                World world8 = this.soul.getLocation().getWorld();
                if (world8 != null && (collection = world8.getNearbyEntities(this.soul.getLocation(), radii, radii, radii)) != null) {
                    void $this$forEach$iv;
                    void $this$filterNotTo$iv$iv;
                    Iterable $this$filterNot$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    Iterable iterable = collection;
                    boolean $i$f$filterIsInstance22 = false;
                    void index2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Player)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
                    boolean $i$f$filterNot = false;
                    destination$iv$iv = $this$filterNot$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        Player it = (Player)element$iv$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual(it.getUniqueId(), this.soul.getOwnerUUID())) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filterNot$iv = (List)destination$iv$iv2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Player player = (Player)element$iv;
                        boolean bl = false;
                        if (MessageManager.INSTANCE.getSoulBurstNearbyComponent() != null) {
                            Component it;
                            boolean bl2 = false;
                            SoulGraves.Companion.getPlugin().adventure().player(player).sendMessage(it);
                        }
                        if (!ConfigManager.INSTANCE.getNotifyNearbySound().getEnabled()) continue;
                        Iterable $this$forEachIndexed$iv = ConfigManager.INSTANCE.getNotifyNearbySound().getSounds();
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            void soundKey2;
                            int n2;
                            if ((n2 = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            String string = (String)item$iv;
                            int index3 = n2;
                            boolean bl3 = false;
                            player.playSound(player.getLocation(), (String)soundKey2, ((Number)ConfigManager.INSTANCE.getNotifyNearbySound().getVolumes().get(index3)).floatValue(), ((Number)ConfigManager.INSTANCE.getNotifyNearbySound().getPitches().get(index3)).floatValue());
                        }
                    }
                }
            }
            this.soul.delete();
            World world9 = this.soul.getLocation().getWorld();
            if (world9 != null) {
                world9.unloadChunk(this.soul.getLocation().getChunk());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.PDC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.CROSS_SERVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

