/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.tasks;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.SoulGravesAPI;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.utils.Soul;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/faultyfunctions/soulgraves/tasks/SoulHintParticlesTask;", "Lorg/bukkit/scheduler/BukkitRunnable;", "soul", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "<init>", "(Ldev/faultyfunctions/soulgraves/utils/Soul;)V", "run", "", "handleRadiusFollow", "world", "Lorg/bukkit/World;", "owner", "Lorg/bukkit/entity/Player;", "startHintParticles", "targetPlayer", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nSoulHintParticlesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulHintParticlesTask.kt\ndev/faultyfunctions/soulgraves/tasks/SoulHintParticlesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n2341#2,14:116\n1971#2,14:130\n808#2,11:144\n295#2,2:155\n1#3:157\n*S KotlinDebug\n*F\n+ 1 SoulHintParticlesTask.kt\ndev/faultyfunctions/soulgraves/tasks/SoulHintParticlesTask\n*L\n30#1:116,14\n32#1:130,14\n53#1:144,11\n54#1:155,2\n*E\n"})
public final class SoulHintParticlesTask
extends BukkitRunnable {
    @NotNull
    private final Soul soul;

    public SoulHintParticlesTask(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        this.soul = soul;
    }

    public void run() {
        Object object;
        World world;
        block23: {
            block22: {
                Player player;
                if (!ConfigManager.INSTANCE.getHintParticlesEnabled()) {
                    return;
                }
                World world2 = this.soul.getLocation().getWorld();
                if (world2 == null) {
                    return;
                }
                world = world2;
                object = Bukkit.getPlayer((UUID)this.soul.getOwnerUUID());
                if (object == null) break block22;
                Player it = player = object;
                boolean bl = false;
                object = it.isOnline() && !it.isDead() && it.getGameMode() != GameMode.SPECTATOR && Intrinsics.areEqual(this.soul.getLocation().getWorld(), world) ? player : null;
                if (object != null) break block23;
            }
            return;
        }
        Player owner = object;
        Soul trackedSoul = null;
        if (Intrinsics.areEqual(ConfigManager.INSTANCE.getHintParticlesTrackedSoul(), "OLDEST")) {
            Object v3;
            UUID uUID = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable $this$minByOrNull$iv = SoulGravesAPI.INSTANCE.getPlayerSouls(uUID);
            boolean $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = minElem$iv;
                } else {
                    Soul it = (Soul)minElem$iv;
                    boolean bl = false;
                    long minValue$iv = it.getDeathTime();
                    do {
                        Object e$iv = iterator$iv.next();
                        Soul it2 = (Soul)e$iv;
                        $i$a$-minByOrNull-SoulHintParticlesTask$run$1 = false;
                        long v$iv = it2.getDeathTime();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = minElem$iv;
                }
            }
            trackedSoul = v3;
        } else if (Intrinsics.areEqual(ConfigManager.INSTANCE.getHintParticlesTrackedSoul(), "NEWEST")) {
            Object v5;
            UUID uUID = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable $this$maxByOrNull$iv = SoulGravesAPI.INSTANCE.getPlayerSouls(uUID);
            boolean $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v5 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v5 = maxElem$iv;
                } else {
                    Soul it = (Soul)maxElem$iv;
                    boolean bl = false;
                    long maxValue$iv = it.getDeathTime();
                    do {
                        Object e$iv = iterator$iv.next();
                        Soul it3 = (Soul)e$iv;
                        $i$a$-maxByOrNull-SoulHintParticlesTask$run$2 = false;
                        long v$iv = it3.getDeathTime();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v5 = maxElem$iv;
                }
            }
            trackedSoul = v5;
        }
        if (trackedSoul == null || !Intrinsics.areEqual(this.soul.getMarkerUUID(), trackedSoul.getMarkerUUID())) {
            return;
        }
        if (ConfigManager.INSTANCE.getHintParticlesActivationRadius() > 0) {
            this.handleRadiusFollow(world, owner);
        } else if (ConfigManager.INSTANCE.getHintParticlesActivationRadius() == 0) {
            this.startHintParticles(owner);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRadiusFollow(World world, Player owner) {
        block4: {
            Object v1;
            block3: {
                void $this$firstOrNull$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                if (!world.isChunkLoaded((int)this.soul.getLocation().getX() >> 4, (int)this.soul.getLocation().getZ() >> 4)) {
                    return;
                }
                Collection collection = world.getNearbyEntities(this.soul.getLocation(), (double)ConfigManager.INSTANCE.getHintParticlesActivationRadius(), (double)ConfigManager.INSTANCE.getHintParticlesActivationRadius(), (double)ConfigManager.INSTANCE.getHintParticlesActivationRadius());
                Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
                Iterable iterable = collection;
                boolean $i$f$filterIsInstance = false;
                void var6_6 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof Player)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Player it = (Player)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it, owner)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            Player player = v1;
            if (player == null) break block4;
            Player p0 = player;
            boolean $i$f$handleRadiusFollow$stub_for_inlining = false;
            boolean bl = false;
            this.startHintParticles(p0);
        }
    }

    private final void startHintParticles(Player targetPlayer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> SoulHintParticlesTask.startHintParticles$lambda$9(targetPlayer, this));
    }

    private static final void startHintParticles$lambda$9$lambda$6(Location $particleStartLocation, Player $targetPlayer, Particle $particleType, Vector $soulDirectionVector) {
        if ($particleStartLocation.getBlock().getType().isSolid()) {
            $particleStartLocation.add(0.0, 1.0, 0.0);
        }
        $targetPlayer.spawnParticle($particleType, $particleStartLocation, 1, 0.2, 0.0, 0.2, 0.0);
        $particleStartLocation.add($soulDirectionVector.clone().multiply(1.0 / (double)ConfigManager.INSTANCE.getHintParticlesTrailDensity()));
    }

    private static final void startHintParticles$lambda$9(Player $targetPlayer, SoulHintParticlesTask this$0) {
        block6: {
            String string;
            Runnable trailRunnable;
            block5: {
                Vector vector;
                if (!Intrinsics.areEqual($targetPlayer.getWorld(), this$0.soul.getLocation().getWorld())) {
                    return;
                }
                Vector $this$startHintParticles_u24lambda_u249_u24lambda_u244 = vector = $targetPlayer.getEyeLocation().getDirection();
                boolean bl = false;
                $this$startHintParticles_u24lambda_u249_u24lambda_u244.setY(0.0);
                Vector vector2 = vector;
                Intrinsics.checkNotNullExpressionValue(vector2, "apply(...)");
                Vector eyeDirectionVector = vector2;
                Location location = $targetPlayer.getEyeLocation().add(eyeDirectionVector.multiply(ConfigManager.INSTANCE.getHintParticlesStartDistance())).subtract(0.0, 1.0, 0.0);
                Intrinsics.checkNotNullExpressionValue(location, "subtract(...)");
                Location particleStartLocation = location;
                Vector $this$startHintParticles_u24lambda_u249_u24lambda_u245 = bl = this$0.soul.getLocation().toVector().subtract(particleStartLocation.toVector()).normalize();
                boolean bl2 = false;
                $this$startHintParticles_u24lambda_u249_u24lambda_u245.setY(0.0);
                Vector vector3 = bl;
                Intrinsics.checkNotNullExpressionValue(vector3, "apply(...)");
                Vector soulDirectionVector = vector3;
                Particle particleType = Particle.valueOf((String)ConfigManager.INSTANCE.getHintParticlesParticleType());
                trailRunnable = () -> SoulHintParticlesTask.startHintParticles$lambda$9$lambda$6(particleStartLocation, $targetPlayer, particleType, soulDirectionVector);
                if ($targetPlayer.getLocation().distance(this$0.soul.getLocation()) < 8.0) {
                    return;
                }
                string = ConfigManager.INSTANCE.getHintParticlesMode();
                if (!Intrinsics.areEqual(string, "WANDER")) break block5;
                int n = ConfigManager.INSTANCE.getHintParticlesWanderCount();
                for (int i = 0; i < n; ++i) {
                    int it = i;
                    boolean bl3 = false;
                    double startX = particleStartLocation.getX() + Random.Default.nextDouble(-1.0, 3.0);
                    double startY = particleStartLocation.getY() + Random.Default.nextDouble(-1.0, 3.0);
                    double startZ = particleStartLocation.getZ() + Random.Default.nextDouble(-1.0, 3.0);
                    Location startLocation = new Location($targetPlayer.getWorld(), startX, startY, startZ);
                    if (startLocation.getBlock().getType().isSolid()) {
                        startLocation.add(0.0, 1.0, 0.0);
                    }
                    double speed = Random.Default.nextDouble(ConfigManager.INSTANCE.getHintParticlesWanderMinSpeed(), ConfigManager.INSTANCE.getHintParticlesWanderMaxSpeed());
                    $targetPlayer.spawnParticle(particleType, startLocation, 0, soulDirectionVector.getX(), soulDirectionVector.getY(), soulDirectionVector.getZ(), speed);
                }
                break block6;
            }
            if (!Intrinsics.areEqual(string, "TRAIL")) break block6;
            long tickDelay = 0L;
            tickDelay = 1L;
            int repeatAmount = ConfigManager.INSTANCE.getHintParticlesTrailLength() * ConfigManager.INSTANCE.getHintParticlesTrailDensity();
            int n = 0;
            while (n < repeatAmount) {
                int it = n++;
                boolean bl = false;
                Bukkit.getScheduler().runTaskLater((Plugin)SoulGraves.Companion.getPlugin(), trailRunnable, tickDelay);
                ++tickDelay;
            }
        }
    }
}

