/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.tasks;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.event.SoulPickupEvent;
import dev.faultyfunctions.soulgraves.database.MessageAction;
import dev.faultyfunctions.soulgraves.database.RedisDatabase;
import dev.faultyfunctions.soulgraves.database.RedisPacket;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.MessageManager;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.utils.Soul;
import dev.faultyfunctions.soulgraves.utils.SoulState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/faultyfunctions/soulgraves/tasks/SoulPickupTask;", "Lorg/bukkit/scheduler/BukkitRunnable;", "soul", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "<init>", "(Ldev/faultyfunctions/soulgraves/utils/Soul;)V", "getSoul", "()Ldev/faultyfunctions/soulgraves/utils/Soul;", "run", "", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nSoulPickupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulPickupTask.kt\ndev/faultyfunctions/soulgraves/tasks/SoulPickupTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,94:1\n1#2:95\n808#3,11:96\n827#3:107\n855#3,2:108\n827#3:110\n855#3,2:111\n774#3:113\n865#3,2:114\n1863#3:116\n1872#3,3:117\n1872#3,3:124\n1864#3:127\n37#4,2:120\n216#5,2:122\n*S KotlinDebug\n*F\n+ 1 SoulPickupTask.kt\ndev/faultyfunctions/soulgraves/tasks/SoulPickupTask\n*L\n25#1:96,11\n26#1:107\n26#1:108,2\n27#1:110\n27#1:111,2\n29#1:113\n29#1:114,2\n30#1:116\n38#1:117,3\n59#1:124,3\n30#1:127\n47#1:120,2\n48#1:122,2\n*E\n"})
public final class SoulPickupTask
extends BukkitRunnable {
    @NotNull
    private final Soul soul;

    public SoulPickupTask(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        this.soul = soul;
    }

    @NotNull
    public final Soul getSoul() {
        return this.soul;
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        Collection collection;
        if (this.soul.getState() == SoulState.EXPLODING) {
            return;
        }
        World world = this.soul.getLocation().getWorld();
        if (!(world != null ? world.isChunkLoaded((int)this.soul.getLocation().getX() >> 4, (int)this.soul.getLocation().getZ() >> 4) : false)) {
            return;
        }
        World world2 = this.soul.getLocation().getWorld();
        if (world2 != null && (collection = world2.getNearbyEntities(this.soul.getLocation(), 0.5, 0.5, 0.5)) != null) {
            Collection collection2;
            Collection collection3;
            Iterable it = collection3 = collection;
            boolean bl = false;
            Collection collection4 = collection2 = Bukkit.getEntity((UUID)this.soul.getMarkerUUID()) != null ? collection3 : null;
            if (collection2 != null) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                void $this$filterNotTo$iv$iv2;
                void $this$filterNot$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                it = collection2;
                boolean $i$f$filterIsInstance232 = false;
                void var7_8 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Player)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $i$f$filterIsInstance232 = (List)destination$iv$iv;
                boolean $i$f$filterNot232 = false;
                destination$iv$iv = $this$filterNot$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                    Player it2 = (Player)element$iv$iv;
                    boolean bl2 = false;
                    if (it2.isDead()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $i$f$filterNot232 = (List)destination$iv$iv2;
                boolean $i$f$filterNot332 = false;
                destination$iv$iv2 = $this$filterNot$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterNotTo2 = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    Player it3 = (Player)element$iv$iv;
                    boolean bl3 = false;
                    if (it3.getGameMode() == GameMode.SPECTATOR) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                Iterable $i$f$filterNot332 = (List)destination$iv$iv3;
                boolean $i$f$filter = false;
                destination$iv$iv3 = $this$filter$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Player it4 = (Player)element$iv$iv;
                    boolean bl4 = false;
                    if (!(!ConfigManager.INSTANCE.getOwnerLocked() || Intrinsics.areEqual(it4.getUniqueId(), this.soul.getOwnerUUID()))) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv4;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HashMap missHashMap;
                    Player player = (Player)element$iv;
                    boolean bl5 = false;
                    SoulPickupEvent soulPickupEvent = new SoulPickupEvent(player, this.soul);
                    Bukkit.getPluginManager().callEvent((Event)soulPickupEvent);
                    if (soulPickupEvent.isCancelled()) continue;
                    List missedItems = new ArrayList();
                    Iterable $this$forEachIndexed$iv = this.soul.getInventory();
                    boolean $i$f$forEachIndexed = false;
                    int index$iv232 = 0;
                    for (Object t : $this$forEachIndexed$iv) {
                        void item;
                        int n;
                        if ((n = index$iv232++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ItemStack itemStack = (ItemStack)t;
                        int index = n;
                        boolean bl6 = false;
                        if (item == null) continue;
                        if (player.getInventory().getItem(index) == null) {
                            player.getInventory().setItem(index, (ItemStack)item);
                            continue;
                        }
                        missedItems.add(item);
                    }
                    Collection $this$toTypedArray$iv = missedItems;
                    boolean bl2 = false;
                    Object thisCollection$iv = $this$toTypedArray$iv;
                    ItemStack[] index$iv232 = thisCollection$iv.toArray(new ItemStack[0]);
                    Intrinsics.checkNotNullExpressionValue(player.getInventory().addItem(Arrays.copyOf(index$iv232, index$iv232.length)), "addItem(...)");
                    Map $this$forEach$iv2 = missHashMap;
                    boolean $i$f$forEach2 = false;
                    for (Map.Entry entry : $this$forEach$iv2.entrySet()) {
                        thisCollection$iv = entry;
                        boolean bl7 = false;
                        ItemStack item = (ItemStack)thisCollection$iv.getValue();
                        World world3 = this.soul.getLocation().getWorld();
                        Intrinsics.checkNotNull(world3);
                        world3.dropItem(this.soul.getLocation(), item);
                    }
                    Player owner = Bukkit.getPlayer((UUID)this.soul.getOwnerUUID());
                    Player player2 = owner;
                    double xpMultiplier = Intrinsics.areEqual(player.getUniqueId(), player2 != null ? player2.getUniqueId() : null) ? ConfigManager.INSTANCE.getXpPercentageOwner() : ConfigManager.INSTANCE.getXpPercentageOthers();
                    player.giveExp((int)((double)this.soul.getXp() * xpMultiplier));
                    if (ConfigManager.INSTANCE.getPickupSound().getEnabled()) {
                        Iterable iterable = ConfigManager.INSTANCE.getPickupSound().getSounds();
                        boolean $i$f$forEachIndexed2 = false;
                        int index$iv = 0;
                        for (Object item$iv : iterable) {
                            void soundKey;
                            int n;
                            if ((n = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            String string = (String)item$iv;
                            int index = n;
                            boolean bl8 = false;
                            player.playSound(player.getLocation(), (String)soundKey, ((Number)ConfigManager.INSTANCE.getPickupSound().getVolumes().get(index)).floatValue(), ((Number)ConfigManager.INSTANCE.getPickupSound().getPitches().get(index)).floatValue());
                        }
                    }
                    player.getWorld().spawnParticle(Particle.END_ROD, this.soul.getLocation(), 200, 1.0, 1.0, 1.0, 0.5);
                    player.getWorld().spawnParticle(Particle.FIREWORK, this.soul.getLocation(), 50, 1.0, 1.0, 1.0, 0.1);
                    if (MessageManager.INSTANCE.getSoulCollectComponent() != null) {
                        Audience audience = SoulGraves.Companion.getPlugin().adventure().player(player);
                        Component component = MessageManager.INSTANCE.getSoulCollectComponent();
                        Intrinsics.checkNotNull(component);
                        audience.sendMessage(component);
                    }
                    if (!Intrinsics.areEqual(player.getUniqueId(), this.soul.getOwnerUUID()) && ConfigManager.INSTANCE.getNotifyOwnerPickup()) {
                        switch (WhenMappings.$EnumSwitchMapping$0[DatabaseManager.INSTANCE.getStorageMode().ordinal()]) {
                            case 1: {
                                if (owner != null) {
                                    boolean bl9 = false;
                                    if (MessageManager.INSTANCE.getSoulBurstComponent() != null) {
                                        Audience audience = SoulGraves.Companion.getPlugin().adventure().player(owner);
                                        Component component = MessageManager.INSTANCE.getSoulBurstComponent();
                                        Intrinsics.checkNotNull(component);
                                        audience.sendMessage(component);
                                    }
                                    if (ConfigManager.INSTANCE.getSoulsDropItems() && MessageManager.INSTANCE.getSoulBurstDropItemsComponent() != null) {
                                        Audience audience = SoulGraves.Companion.getPlugin().adventure().player(owner);
                                        Component component = MessageManager.INSTANCE.getSoulBurstDropItemsComponent();
                                        Intrinsics.checkNotNull(component);
                                        audience.sendMessage(component);
                                        break;
                                    }
                                    if (MessageManager.INSTANCE.getSoulBurstLoseItemsComponent() == null) break;
                                    Audience audience = SoulGraves.Companion.getPlugin().adventure().player(owner);
                                    Component component = MessageManager.INSTANCE.getSoulBurstLoseItemsComponent();
                                    Intrinsics.checkNotNull(component);
                                    audience.sendMessage(component);
                                }
                                break;
                            }
                            case 2: {
                                RedisDatabase redisDatabase = RedisDatabase.Companion.getInstance();
                                String string = DatabaseManagerKt.getSERVER_NAME();
                                String string2 = this.soul.getOwnerUUID().toString();
                                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                                redisDatabase.publish(new RedisPacket(string, MessageAction.NOTIFY_SOUL_OTHER_PICKUP, string2));
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    this.soul.delete();
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.PDC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.CROSS_SERVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

