/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.tasks;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.utils.Soul;
import dev.faultyfunctions.soulgraves.utils.SoulState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/faultyfunctions/soulgraves/tasks/SoulRenderTask;", "Lorg/bukkit/scheduler/BukkitRunnable;", "soul", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "<init>", "(Ldev/faultyfunctions/soulgraves/utils/Soul;)V", "getSoul", "()Ldev/faultyfunctions/soulgraves/utils/Soul;", "particleLocation", "Lorg/bukkit/Location;", "run", "", "renderNormalState", "world", "Lorg/bukkit/World;", "renderPanicState", "handleExplosion", "soulgraves"})
public final class SoulRenderTask
extends BukkitRunnable {
    @NotNull
    private final Soul soul;
    @NotNull
    private final Location particleLocation;

    public SoulRenderTask(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        this.soul = soul;
        this.particleLocation = new Location(null, 0.0, 0.0, 0.0);
    }

    @NotNull
    public final Soul getSoul() {
        return this.soul;
    }

    public void run() {
        World world = this.soul.getLocation().getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        if (!world2.isChunkLoaded((int)this.soul.getLocation().getX() >> 4, (int)this.soul.getLocation().getZ() >> 4)) {
            return;
        }
        this.particleLocation.setWorld(world2);
        this.particleLocation.setX(this.soul.getLocation().getX());
        this.particleLocation.setY(this.soul.getLocation().getY() + 1.0);
        this.particleLocation.setZ(this.soul.getLocation().getZ());
        Enum<SoulState> enum_ = this.soul.getState();
        if (enum_ == SoulState.NORMAL) {
            this.renderNormalState(world2);
        } else if (enum_ == SoulState.PANIC) {
            this.renderPanicState(world2);
        } else if (enum_ == SoulState.EXPLODING) {
            this.handleExplosion(world2);
        }
    }

    private final void renderNormalState(World world) {
        this.particleLocation.setY(this.soul.getLocation().getY() + 1.0 + Math.sin((double)System.currentTimeMillis() * 0.001) * 0.5);
        world.spawnParticle(Particle.END_ROD, this.particleLocation, 5, 0.01, 0.01, 0.01, 0.01, null, true);
        this.particleLocation.setY(this.soul.getLocation().getY() + 1.0);
        world.spawnParticle(Particle.SCULK_SOUL, this.particleLocation, 1, 0.3, 0.5, 0.3, 0.01, null, true);
        Particle shineParticle = this.soul.isOnlyXP() ? Particle.COMPOSTER : Particle.ELECTRIC_SPARK;
        world.spawnParticle(shineParticle, this.particleLocation, 1, 0.8, 0.5, 0.8, 0.0, null, true);
    }

    private final void renderPanicState(World world) {
        if (this.soul.getTimeLeft() > 1) {
            int sculkParticleCount = Math.min(this.soul.getTimeLeft() / 6, 5);
            world.spawnParticle(Particle.SCULK_SOUL, this.particleLocation, sculkParticleCount, 0.01, 0.01, 0.01, 0.1, null, true);
            world.spawnParticle(Particle.END_ROD, this.particleLocation, 1, 0.01, 0.01, 0.01, 0.01, null, true);
        }
    }

    private final void handleExplosion(World world) {
        if (!this.soul.getImplosion()) {
            this.soul.setImplosion(true);
            double x = this.particleLocation.getX();
            double y = this.particleLocation.getY();
            double z = this.particleLocation.getZ();
            new BukkitRunnable(world, x, y, z){
                final /* synthetic */ World $world;
                final /* synthetic */ double $x;
                final /* synthetic */ double $y;
                final /* synthetic */ double $z;
                {
                    this.$world = $world;
                    this.$x = $x;
                    this.$y = $y;
                    this.$z = $z;
                }

                public void run() {
                    this.$world.spawnParticle(Particle.SONIC_BOOM, new Location(this.$world, this.$x, this.$y, this.$z), 1, 0.0, 0.0, 0.0, 0.0, null, true);
                    this.cancel();
                }
            }.runTaskLater((Plugin)SoulGraves.Companion.getPlugin(), 8L);
        }
    }
}

