/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Ldev/faultyfunctions/soulgraves/utils/SpigotCompatUtils;", "", "<init>", "()V", "getChunkKey", "", "chunk", "Lorg/bukkit/Chunk;", "getChunkAt", "chunkKey", "world", "Lorg/bukkit/World;", "calculateTotalExperiencePoints", "", "level", "isPluginLoaded", "", "plugin", "", "soulgraves"})
public final class SpigotCompatUtils {
    @NotNull
    public static final SpigotCompatUtils INSTANCE = new SpigotCompatUtils();

    private SpigotCompatUtils() {
    }

    public final long getChunkKey(@NotNull Chunk chunk) {
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        return (long)chunk.getZ() << 32 | (long)chunk.getX() & 0xFFFFFFFFL;
    }

    @NotNull
    public final Chunk getChunkAt(long chunkKey, @NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        int x = (int)(chunkKey << 32 >> 32);
        int z = (int)(chunkKey >> 32);
        Chunk chunk = world.getChunkAt(x, z);
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunkAt(...)");
        return chunk;
    }

    public final int calculateTotalExperiencePoints(int level) {
        return level <= 16 ? level * level + 6 * level : (level <= 31 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + (double)360) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + (double)2220));
    }

    public final boolean isPluginLoaded(@NotNull String plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return Bukkit.getPluginManager().getPlugin(plugin) != null;
    }
}

