/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.api;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.database.MessageAction;
import dev.faultyfunctions.soulgraves.database.MySQLDatabase;
import dev.faultyfunctions.soulgraves.database.RedisDatabase;
import dev.faultyfunctions.soulgraves.database.RedisPacket;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.utils.Soul;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Ldev/faultyfunctions/soulgraves/api/RedisPublishAPI;", "", "<init>", "()V", "pendingAnswersRequests", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/CompletableFuture;", "", "getPendingAnswersRequests", "()Ljava/util/concurrent/ConcurrentHashMap;", "deleteSoul", "markerUUID", "Ljava/util/UUID;", "explodeSoul", "syncSoul", "soul", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "soulgraves"})
public final class RedisPublishAPI {
    @NotNull
    public static final RedisPublishAPI INSTANCE = new RedisPublishAPI();
    @NotNull
    private static final ConcurrentHashMap<String, CompletableFuture<Boolean>> pendingAnswersRequests = new ConcurrentHashMap();

    private RedisPublishAPI() {
    }

    @NotNull
    public final ConcurrentHashMap<String, CompletableFuture<Boolean>> getPendingAnswersRequests() {
        return pendingAnswersRequests;
    }

    @NotNull
    public final CompletableFuture<Boolean> deleteSoul(@NotNull UUID markerUUID) {
        Intrinsics.checkNotNullParameter(markerUUID, "markerUUID");
        if (DatabaseManagerKt.getSTORAGE_MODE() == StorageType.PDC) {
            throw new RuntimeException("DO NOT USE REDIS PUBLISH API WITH PDC STORAGE MODE!");
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> RedisPublishAPI.deleteSoul$lambda$2(markerUUID, future));
        CompletableFuture<Boolean> completableFuture = future.orTimeout(5L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(completableFuture, "orTimeout(...)");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<Boolean> explodeSoul(@NotNull UUID markerUUID) {
        Intrinsics.checkNotNullParameter(markerUUID, "markerUUID");
        if (DatabaseManagerKt.getSTORAGE_MODE() == StorageType.PDC) {
            throw new RuntimeException("DO NOT USE REDIS PUBLISH API WITH PDC STORAGE MODE!");
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> RedisPublishAPI.explodeSoul$lambda$5(markerUUID, future));
        CompletableFuture<Boolean> completableFuture = future.orTimeout(5L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(completableFuture, "orTimeout(...)");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<Boolean> syncSoul(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        if (DatabaseManagerKt.getSTORAGE_MODE() == StorageType.PDC) {
            throw new RuntimeException("DO NOT USE REDIS PUBLISH API WITH PDC STORAGE MODE!");
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> RedisPublishAPI.syncSoul$lambda$8(soul, future));
        CompletableFuture<Boolean> completableFuture = future.orTimeout(5L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(completableFuture, "orTimeout(...)");
        return completableFuture;
    }

    private static final Unit deleteSoul$lambda$2$lambda$0(UUID $msgUUID, Boolean bl, Throwable throwable) {
        pendingAnswersRequests.remove($msgUUID.toString());
        return Unit.INSTANCE;
    }

    private static final void deleteSoul$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void deleteSoul$lambda$2(UUID $markerUUID, CompletableFuture $future) {
        try {
            Soul soul = MySQLDatabase.Companion.getInstance().getSoul($markerUUID);
            if (soul == null) {
                $future.complete(false);
                return;
            }
            if (RedisDatabase.Companion.getInstance().isServerOnline(soul.getServerId())) {
                UUID msgUUID = UUID.randomUUID();
                String target = soul.getServerId();
                ((Map)pendingAnswersRequests).put(msgUUID.toString(), $future);
                $future.whenComplete((arg_0, arg_1) -> RedisPublishAPI.deleteSoul$lambda$2$lambda$1((arg_0, arg_1) -> RedisPublishAPI.deleteSoul$lambda$2$lambda$0(msgUUID, arg_0, arg_1), arg_0, arg_1));
                RedisDatabase.Companion.getInstance().publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.REMOVE_SOUL, msgUUID + "|" + target + "|" + $markerUUID));
            } else {
                MySQLDatabase.Companion.getInstance().markSoulDelete($markerUUID);
                $future.complete(true);
            }
        }
        catch (Exception e) {
            $future.completeExceptionally(e);
        }
    }

    private static final Unit explodeSoul$lambda$5$lambda$3(UUID $msgUUID, Boolean bl, Throwable throwable) {
        pendingAnswersRequests.remove($msgUUID.toString());
        return Unit.INSTANCE;
    }

    private static final void explodeSoul$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void explodeSoul$lambda$5(UUID $markerUUID, CompletableFuture $future) {
        try {
            Soul soul = MySQLDatabase.Companion.getInstance().getSoul($markerUUID);
            if (soul == null) {
                $future.complete(false);
                return;
            }
            if (RedisDatabase.Companion.getInstance().isServerOnline(soul.getServerId())) {
                UUID msgUUID = UUID.randomUUID();
                String target = soul.getServerId();
                ((Map)pendingAnswersRequests).put(msgUUID.toString(), $future);
                $future.whenComplete((arg_0, arg_1) -> RedisPublishAPI.explodeSoul$lambda$5$lambda$4((arg_0, arg_1) -> RedisPublishAPI.explodeSoul$lambda$5$lambda$3(msgUUID, arg_0, arg_1), arg_0, arg_1));
                RedisDatabase.Companion.getInstance().publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.EXPLODE_SOUL, msgUUID + "|" + target + "|" + $markerUUID));
            } else {
                MySQLDatabase.Companion.getInstance().markSoulExplode($markerUUID);
                $future.complete(true);
            }
        }
        catch (Exception e) {
            $future.completeExceptionally(e);
        }
    }

    private static final Unit syncSoul$lambda$8$lambda$6(UUID $msgUUID, Boolean bl, Throwable throwable) {
        pendingAnswersRequests.remove($msgUUID.toString());
        return Unit.INSTANCE;
    }

    private static final void syncSoul$lambda$8$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void syncSoul$lambda$8(Soul $soul, CompletableFuture $future) {
        try {
            Soul checkSoul = MySQLDatabase.Companion.getInstance().getSoul($soul.getMarkerUUID());
            if (checkSoul == null) {
                $future.complete(false);
                return;
            }
            MySQLDatabase.Companion.getInstance().saveSoulCopy($soul);
            UUID msgUUID = UUID.randomUUID();
            ((Map)pendingAnswersRequests).put(msgUUID.toString(), $future);
            $future.whenComplete((arg_0, arg_1) -> RedisPublishAPI.syncSoul$lambda$8$lambda$7((arg_0, arg_1) -> RedisPublishAPI.syncSoul$lambda$8$lambda$6(msgUUID, arg_0, arg_1), arg_0, arg_1));
            RedisDatabase redisDatabase = RedisDatabase.Companion.getInstance();
            String string = DatabaseManagerKt.getSERVER_NAME();
            String string2 = $soul.getMarkerUUID().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            redisDatabase.publish(new RedisPacket(string, MessageAction.UPDATE_SOUL, string2));
        }
        catch (Exception e) {
            $future.completeExceptionally(e);
        }
    }
}

