/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.compatibilities;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.event.SoulPreSpawnEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Ldev/faultyfunctions/soulgraves/compatibilities/WorldGuardHook;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "registry", "Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;", "getRegistry", "()Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;", "setRegistry", "(Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;)V", "flagRegisteredSuccess", "", "getFlagRegisteredSuccess", "()Z", "setFlagRegisteredSuccess", "(Z)V", "registerFlags", "", "registerEvents", "onSoulPreSpawn", "event", "Ldev/faultyfunctions/soulgraves/api/event/SoulPreSpawnEvent;", "Companion", "soulgraves"})
public final class WorldGuardHook
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FlagRegistry registry;
    private boolean flagRegisteredSuccess;
    @NotNull
    private static final Lazy<WorldGuardHook> instance$delegate = LazyKt.lazy(WorldGuardHook::instance_delegate$lambda$0);
    @Nullable
    private static StateFlag soulGravesSpawningFlag;

    public WorldGuardHook() {
        FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
        Intrinsics.checkNotNullExpressionValue(flagRegistry, "getFlagRegistry(...)");
        this.registry = flagRegistry;
    }

    @NotNull
    public final FlagRegistry getRegistry() {
        return this.registry;
    }

    public final void setRegistry(@NotNull FlagRegistry flagRegistry) {
        Intrinsics.checkNotNullParameter(flagRegistry, "<set-?>");
        this.registry = flagRegistry;
    }

    public final boolean getFlagRegisteredSuccess() {
        return this.flagRegisteredSuccess;
    }

    public final void setFlagRegisteredSuccess(boolean bl) {
        this.flagRegisteredSuccess = bl;
    }

    public final void registerFlags() {
        try {
            StateFlag flag = new StateFlag("soulgraves-spawning", true);
            this.registry.register((Flag)flag);
            soulGravesSpawningFlag = flag;
            this.flagRegisteredSuccess = true;
        }
        catch (FlagConflictException e) {
            Flag existing = this.registry.get("my-custom-flag");
            if (existing instanceof StateFlag) {
                soulGravesSpawningFlag = (StateFlag)existing;
                this.flagRegisteredSuccess = true;
            }
            this.flagRegisteredSuccess = false;
            return;
        }
    }

    public final void registerEvents() {
        if (!this.flagRegisteredSuccess) {
            SoulGraves.Companion.getPlugin().getLogger().warning("WorldGuard has registered the soulgraves-spawning flag!");
            return;
        }
        SoulGraves.Companion.getPlugin().getServer().getPluginManager().registerEvents((Listener)new WorldGuardHook(), (Plugin)SoulGraves.Companion.getPlugin());
        SoulGraves.Companion.getPlugin().getLogger().info("[\u221a] WorldGuard Hooked!");
    }

    @EventHandler
    public final void onSoulPreSpawn(@NotNull SoulPreSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(event.getPlayer());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet regions = query.getApplicableRegions(localPlayer.getLocation());
        StateFlag.State value = (StateFlag.State)regions.queryValue((RegionAssociable)localPlayer, (Flag)soulGravesSpawningFlag);
        if (value == StateFlag.State.DENY) {
            event.setCancelled(true);
        }
    }

    private static final WorldGuardHook instance_delegate$lambda$0() {
        return new WorldGuardHook();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/faultyfunctions/soulgraves/compatibilities/WorldGuardHook$Companion;", "", "<init>", "()V", "instance", "Ldev/faultyfunctions/soulgraves/compatibilities/WorldGuardHook;", "getInstance", "()Ldev/faultyfunctions/soulgraves/compatibilities/WorldGuardHook;", "instance$delegate", "Lkotlin/Lazy;", "soulGravesSpawningFlag", "Lcom/sk89q/worldguard/protection/flags/StateFlag;", "getSoulGravesSpawningFlag", "()Lcom/sk89q/worldguard/protection/flags/StateFlag;", "setSoulGravesSpawningFlag", "(Lcom/sk89q/worldguard/protection/flags/StateFlag;)V", "soulgraves"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorldGuardHook getInstance() {
            Lazy lazy = instance$delegate;
            return (WorldGuardHook)lazy.getValue();
        }

        @Nullable
        public final StateFlag getSoulGravesSpawningFlag() {
            return soulGravesSpawningFlag;
        }

        public final void setSoulGravesSpawningFlag(@Nullable StateFlag stateFlag) {
            soulGravesSpawningFlag = stateFlag;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

