/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.database;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.database.PDCDatabaseKt;
import dev.faultyfunctions.soulgraves.libs.morepersistentdatatypes.DataType;
import dev.faultyfunctions.soulgraves.utils.Soul;
import dev.faultyfunctions.soulgraves.utils.SpigotCompatUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Marker;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Ldev/faultyfunctions/soulgraves/database/PDCDatabase;", "", "<init>", "()V", "initSouls", "", "saveSoul", "", "soul", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "deleteSoul", "Companion", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nPDCDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PDCDatabase.kt\ndev/faultyfunctions/soulgraves/database/PDCDatabase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1863#2:131\n774#2:143\n865#2,2:144\n1863#2,2:146\n1864#2:148\n4135#3,11:132\n37#4,2:149\n1#5:151\n*S KotlinDebug\n*F\n+ 1 PDCDatabase.kt\ndev/faultyfunctions/soulgraves/database/PDCDatabase\n*L\n37#1:131\n40#1:143\n40#1:144,2\n41#1:146,2\n37#1:148\n39#1:132,11\n93#1:149,2\n*E\n"})
public final class PDCDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<PDCDatabase> instance$delegate = LazyKt.lazy(PDCDatabase::instance_delegate$lambda$8);

    private PDCDatabase() {
    }

    /*
     * WARNING - void declaration
     */
    private final void initSouls() {
        for (World world : Bukkit.getWorlds()) {
            List chunkKeyList;
            if (!world.getPersistentDataContainer().has(PDCDatabaseKt.getSoulChunksKey())) {
                world.getPersistentDataContainer().set(PDCDatabaseKt.getSoulChunksKey(), (PersistentDataType)DataType.asList(DataType.LONG), (Object)new ArrayList());
                continue;
            }
            List list = (List)world.getPersistentDataContainer().get(PDCDatabaseKt.getSoulChunksKey(), (PersistentDataType)DataType.asList(DataType.LONG));
            List list2 = chunkKeyList = list != null ? CollectionsKt.distinct(list) : null;
            if (list2 == null) continue;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                long chunkKey = ((Number)element$iv).longValue();
                boolean bl = false;
                Intrinsics.checkNotNull(world);
                Entity[] entityArray = SpigotCompatUtils.INSTANCE.getChunkAt(chunkKey, world).getEntities();
                Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
                Object[] objectArray = entityArray;
                boolean $i$f$filterIsInstance = false;
                Iterator iterator2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Marker)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Marker it = (Marker)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.getPersistentDataContainer().has(PDCDatabaseKt.getSoulKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Marker it = (Marker)element$iv2;
                    boolean bl3 = false;
                    Object object = it.getPersistentDataContainer().get(PDCDatabaseKt.getSoulOwnerKey(), DataType.UUID);
                    Intrinsics.checkNotNull(object);
                    UUID ownerUUID = (UUID)object;
                    Object object2 = (ItemStack[])it.getPersistentDataContainer().get(PDCDatabaseKt.getSoulInvKey(), DataType.ITEM_STACK_ARRAY);
                    if (object2 == null || (object2 = ArraysKt.toMutableList(object2)) == null) {
                        object2 = new ArrayList();
                    }
                    Object inventory = object2;
                    Integer n = (Integer)it.getPersistentDataContainer().get(PDCDatabaseKt.getSoulXpKey(), DataType.INTEGER);
                    int xp = n != null ? n : 0;
                    Long l = (Long)it.getPersistentDataContainer().get(PDCDatabaseKt.getSoulDeathTimeKey(), DataType.LONG);
                    long deathTime = l != null ? l : 0L;
                    Long l2 = (Long)it.getPersistentDataContainer().get(PDCDatabaseKt.getSoulExpireTimeKey(), DataType.LONG);
                    long expireTime = l2 != null ? l2 : 0L;
                    Long l3 = (Long)it.getPersistentDataContainer().get(PDCDatabaseKt.getSoulFreezeTimeKey(), DataType.LONG);
                    long freezeTime = l3 != null ? l3 : 0L;
                    UUID uUID = it.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    Location location = it.getLocation();
                    Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                    Soul loadSoul = Soul.Companion.initAndStart(uUID, ownerUUID, location, (List<ItemStack>)inventory, xp, deathTime, expireTime, freezeTime);
                    if (loadSoul.isValid(true)) {
                        SoulGraves.Companion.getSoulList().add(loadSoul);
                        loadSoul.startTasks();
                        continue;
                    }
                    loadSoul.delete();
                }
            }
        }
    }

    public final boolean saveSoul(@NotNull Soul soul) {
        Soul soul2;
        Intrinsics.checkNotNullParameter(soul, "soul");
        Soul $this$saveSoul_u24lambda_u245 = soul2 = soul;
        boolean bl = false;
        World world = $this$saveSoul_u24lambda_u245.getLocation().getWorld();
        if (world != null) {
            world.loadChunk($this$saveSoul_u24lambda_u245.getLocation().getChunk());
        }
        Entity entity = Bukkit.getEntity((UUID)$this$saveSoul_u24lambda_u245.getMarkerUUID());
        if (entity != null) {
            Soul soul3;
            Entity marker = entity;
            boolean bl2 = false;
            List chunkList = (List)marker.getWorld().getPersistentDataContainer().get(PDCDatabaseKt.getSoulChunksKey(), (PersistentDataType)DataType.asList(DataType.LONG));
            if (chunkList != null) {
                Chunk chunk = marker.getLocation().getChunk();
                Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
                if (!chunkList.contains(SpigotCompatUtils.INSTANCE.getChunkKey(chunk))) {
                    Chunk chunk2 = marker.getLocation().getChunk();
                    Intrinsics.checkNotNullExpressionValue(chunk2, "getChunk(...)");
                    chunkList.add(SpigotCompatUtils.INSTANCE.getChunkKey(chunk2));
                    marker.getWorld().getPersistentDataContainer().set(PDCDatabaseKt.getSoulChunksKey(), (PersistentDataType)DataType.asList(DataType.LONG), (Object)chunkList);
                }
            }
            Soul $this$saveSoul_u24lambda_u245_u24lambda_u244_u24lambda_u243 = soul3 = soul;
            boolean bl3 = false;
            marker.getPersistentDataContainer().set(PDCDatabaseKt.getSoulKey(), DataType.BOOLEAN, (Object)true);
            marker.getPersistentDataContainer().set(PDCDatabaseKt.getSoulOwnerKey(), DataType.UUID, (Object)$this$saveSoul_u24lambda_u245_u24lambda_u244_u24lambda_u243.getOwnerUUID());
            Collection $this$toTypedArray$iv = $this$saveSoul_u24lambda_u245_u24lambda_u244_u24lambda_u243.getInventory();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            marker.getPersistentDataContainer().set(PDCDatabaseKt.getSoulInvKey(), DataType.ITEM_STACK_ARRAY, (Object)thisCollection$iv.toArray(new ItemStack[0]));
            marker.getPersistentDataContainer().set(PDCDatabaseKt.getSoulXpKey(), DataType.INTEGER, (Object)$this$saveSoul_u24lambda_u245_u24lambda_u244_u24lambda_u243.getXp());
            marker.getPersistentDataContainer().set(PDCDatabaseKt.getSoulDeathTimeKey(), DataType.LONG, (Object)$this$saveSoul_u24lambda_u245_u24lambda_u244_u24lambda_u243.getDeathTime());
            marker.getPersistentDataContainer().set(PDCDatabaseKt.getSoulExpireTimeKey(), DataType.LONG, (Object)$this$saveSoul_u24lambda_u245_u24lambda_u244_u24lambda_u243.getExpireTime());
            marker.getPersistentDataContainer().set(PDCDatabaseKt.getSoulFreezeTimeKey(), DataType.LONG, (Object)$this$saveSoul_u24lambda_u245_u24lambda_u244_u24lambda_u243.getFreezeTime());
            return true;
        }
        return false;
    }

    public final boolean deleteSoul(@NotNull Soul soul) {
        block3: {
            List chunkList;
            Soul soul2;
            Intrinsics.checkNotNullParameter(soul, "soul");
            Soul $this$deleteSoul_u24lambda_u246 = soul2 = soul;
            boolean bl = false;
            boolean removeChunk = true;
            for (Entity entityInChunk : $this$deleteSoul_u24lambda_u246.getLocation().getChunk().getEntities()) {
                if (!entityInChunk.getPersistentDataContainer().has(PDCDatabaseKt.getSoulKey()) || Intrinsics.areEqual($this$deleteSoul_u24lambda_u246.getMarkerUUID(), entityInChunk.getUniqueId())) continue;
                removeChunk = false;
                break;
            }
            if (!removeChunk) break block3;
            World world = $this$deleteSoul_u24lambda_u246.getLocation().getWorld();
            List list = world != null && (world = world.getPersistentDataContainer()) != null ? (List)world.get(PDCDatabaseKt.getSoulChunksKey(), (PersistentDataType)DataType.asList(DataType.LONG)) : (chunkList = null);
            if (chunkList != null) {
                Chunk chunk = $this$deleteSoul_u24lambda_u246.getLocation().getChunk();
                Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
                chunkList.remove(SpigotCompatUtils.INSTANCE.getChunkKey(chunk));
                World world2 = $this$deleteSoul_u24lambda_u246.getLocation().getWorld();
                if (world2 != null && (world2 = world2.getPersistentDataContainer()) != null) {
                    world2.set(PDCDatabaseKt.getSoulChunksKey(), (PersistentDataType)DataType.asList(DataType.LONG), (Object)chunkList);
                }
            }
        }
        return true;
    }

    private static final PDCDatabase instance_delegate$lambda$8() {
        PDCDatabase pDCDatabase;
        PDCDatabase $this$instance_delegate_u24lambda_u248_u24lambda_u247 = pDCDatabase = new PDCDatabase();
        boolean bl = false;
        $this$instance_delegate_u24lambda_u248_u24lambda_u247.initSouls();
        return pDCDatabase;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/faultyfunctions/soulgraves/database/PDCDatabase$Companion;", "", "<init>", "()V", "instance", "Ldev/faultyfunctions/soulgraves/database/PDCDatabase;", "getInstance", "()Ldev/faultyfunctions/soulgraves/database/PDCDatabase;", "instance$delegate", "Lkotlin/Lazy;", "soulgraves"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PDCDatabase getInstance() {
            Lazy lazy = instance$delegate;
            return (PDCDatabase)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

