/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.database;

import com.google.gson.JsonSyntaxException;
import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.RedisPublishAPI;
import dev.faultyfunctions.soulgraves.api.SoulGraveAPI;
import dev.faultyfunctions.soulgraves.database.MessageAction;
import dev.faultyfunctions.soulgraves.database.MySQLDatabase;
import dev.faultyfunctions.soulgraves.database.RedisPacket;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.YamlDocument;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.MessageManager;
import dev.faultyfunctions.soulgraves.utils.Soul;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001bJ\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\bJ\u0006\u0010!\u001a\u00020\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/faultyfunctions/soulgraves/database/RedisDatabase;", "", "<init>", "()V", "redisClient", "Lio/lettuce/core/RedisClient;", "connection", "Lio/lettuce/core/api/StatefulRedisConnection;", "", "pubSubConnection", "Lio/lettuce/core/pubsub/StatefulRedisPubSubConnection;", "callbackExecutor", "Ljava/util/concurrent/ExecutorService;", "pluginChannel", "heartbeatInterval", "", "heartbeatTimeout", "serverStatus", "Ljava/util/concurrent/ConcurrentHashMap;", "startHeartbeatTask", "", "startCleanupTask", "shutdownHeartbeat", "isServerOnline", "", "server", "getOnlineServers", "", "publish", "packet", "Ldev/faultyfunctions/soulgraves/database/RedisPacket;", "handleMessage", "message", "shutdown", "Companion", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nRedisDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisDatabase.kt\ndev/faultyfunctions/soulgraves/database/RedisDatabase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n774#2:290\n865#2,2:291\n1872#2,3:293\n*S KotlinDebug\n*F\n+ 1 RedisDatabase.kt\ndev/faultyfunctions/soulgraves/database/RedisDatabase\n*L\n102#1:290\n102#1:291,2\n232#1:293,3\n*E\n"})
public final class RedisDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RedisClient redisClient;
    @Nullable
    private StatefulRedisConnection<String, String> connection;
    @Nullable
    private StatefulRedisPubSubConnection<String, String> pubSubConnection;
    @Nullable
    private ExecutorService callbackExecutor;
    @NotNull
    private final String pluginChannel;
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    @NotNull
    private final ConcurrentHashMap<String, Long> serverStatus = new ConcurrentHashMap();
    @NotNull
    private static final Lazy<RedisDatabase> instance$delegate = LazyKt.lazy(RedisDatabase::instance_delegate$lambda$17);

    private RedisDatabase() {
        this.pluginChannel = "soulgraves:main";
        this.heartbeatInterval = 5L;
        this.heartbeatTimeout = 15L;
        YamlDocument config = DatabaseManager.INSTANCE.getDatabaseConfig();
        String uri = config.getString("Redis.uri");
        try {
            RedisClient redisClient = this.redisClient = RedisClient.create((String)uri);
            Intrinsics.checkNotNull(redisClient);
            this.connection = redisClient.connect();
            RedisClient redisClient2 = this.redisClient;
            Intrinsics.checkNotNull(redisClient2);
            this.pubSubConnection = redisClient2.connectPubSub();
            this.callbackExecutor = Executors.newWorkStealingPool(6);
            StatefulRedisPubSubConnection<String, String> statefulRedisPubSubConnection = this.pubSubConnection;
            Intrinsics.checkNotNull(statefulRedisPubSubConnection);
            Object[] objectArray = new String[]{this.pluginChannel};
            statefulRedisPubSubConnection.async().subscribe(objectArray);
            StatefulRedisPubSubConnection<String, String> statefulRedisPubSubConnection2 = this.pubSubConnection;
            Intrinsics.checkNotNull(statefulRedisPubSubConnection2);
            statefulRedisPubSubConnection2.addListener((RedisPubSubListener)new RedisPubSubAdapter<String, String>(){

                public void message(String channel, String message) {
                    Intrinsics.checkNotNullParameter(channel, "channel");
                    Intrinsics.checkNotNullParameter(message, "message");
                    if (!Intrinsics.areEqual(pluginChannel, channel)) {
                        return;
                    }
                    this.handleMessage(message);
                }
            });
            this.startHeartbeatTask();
            this.startCleanupTask();
            SoulGraves.Companion.getPlugin().getLogger().info("Redis Database Connect Successed!");
        }
        catch (Exception e) {
            SoulGraves.Companion.getPlugin().getLogger().info("Redis Database Can Not Connect!");
            e.printStackTrace();
            SoulGraves.Companion.getPlugin().getServer().getPluginManager().disablePlugin((Plugin)SoulGraves.Companion.getPlugin());
        }
    }

    private final void startHeartbeatTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> RedisDatabase.startHeartbeatTask$lambda$0(this), 0L, this.heartbeatInterval * (long)20);
    }

    private final void startCleanupTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> RedisDatabase.startCleanupTask$lambda$3(this), 0L, this.heartbeatTimeout * 10L * (long)20);
    }

    private final void shutdownHeartbeat() {
        this.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.HEARTBEAT_SHUTDOWN, DatabaseManagerKt.getSERVER_NAME()));
    }

    public final boolean isServerOnline(@NotNull String server) {
        Intrinsics.checkNotNullParameter(server, "server");
        Long l = this.serverStatus.get(server);
        if (l == null) {
            return false;
        }
        long lastSeen = l;
        return System.currentTimeMillis() - lastSeen < TimeUnit.SECONDS.toMillis(this.heartbeatTimeout);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getOnlineServers() {
        void $this$filterTo$iv$iv;
        long currentTime = System.currentTimeMillis();
        Set set = this.serverStatus.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String server = (String)element$iv$iv;
            boolean bl = false;
            Long l = this.serverStatus.get(server);
            if (!(currentTime - (l != null ? l : 0L) < TimeUnit.SECONDS.toMillis(this.heartbeatTimeout))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void publish(@NotNull RedisPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        String message = packet.toJson();
        StatefulRedisConnection<String, String> statefulRedisConnection = this.connection;
        Intrinsics.checkNotNull(statefulRedisConnection);
        RedisAsyncCommands async = statefulRedisConnection.async();
        async.publish((Object)this.pluginChannel, (Object)message);
    }

    public final void handleMessage(@Nullable String message) {
        if (message == null) {
            SoulGraves.Companion.getPlugin().getLogger().warning("Received null message from Redis");
            return;
        }
        try {
            RedisPacket packet = RedisPacket.Companion.fromJson(message);
            String sender = packet.getSenderId();
            switch (WhenMappings.$EnumSwitchMapping$0[packet.getAction().ordinal()]) {
                case 1: {
                    ExecutorService executorService = this.callbackExecutor;
                    Intrinsics.checkNotNull(executorService);
                    executorService.execute(() -> RedisDatabase.handleMessage$lambda$6(packet, this, sender));
                    break;
                }
                case 2: {
                    ExecutorService executorService = this.callbackExecutor;
                    Intrinsics.checkNotNull(executorService);
                    executorService.execute(() -> RedisDatabase.handleMessage$lambda$8(packet, this, sender));
                    break;
                }
                case 3: {
                    ExecutorService executorService = this.callbackExecutor;
                    Intrinsics.checkNotNull(executorService);
                    executorService.execute(() -> RedisDatabase.handleMessage$lambda$10(packet, this, sender));
                    break;
                }
                case 4: {
                    ExecutorService executorService = this.callbackExecutor;
                    Intrinsics.checkNotNull(executorService);
                    executorService.execute(() -> RedisDatabase.handleMessage$lambda$11(packet));
                    break;
                }
                case 5: {
                    ExecutorService executorService = this.callbackExecutor;
                    Intrinsics.checkNotNull(executorService);
                    executorService.execute(() -> RedisDatabase.handleMessage$lambda$13(packet));
                    break;
                }
                case 6: {
                    ExecutorService executorService = this.callbackExecutor;
                    Intrinsics.checkNotNull(executorService);
                    executorService.execute(() -> RedisDatabase.handleMessage$lambda$14(packet));
                    break;
                }
                case 7: {
                    ExecutorService executorService = this.callbackExecutor;
                    Intrinsics.checkNotNull(executorService);
                    executorService.execute(() -> RedisDatabase.handleMessage$lambda$15(packet, this));
                    break;
                }
                case 8: {
                    ExecutorService executorService = this.callbackExecutor;
                    Intrinsics.checkNotNull(executorService);
                    executorService.execute(() -> RedisDatabase.handleMessage$lambda$16(packet, this));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (JsonSyntaxException e) {
            SoulGraves.Companion.getPlugin().getLogger().severe("JSON PARSED FAILED: " + e.getMessage());
            SoulGraves.Companion.getPlugin().getLogger().severe("ORIGIN MESSAGE: " + StringsKt.take(message, 200) + "...");
        }
        catch (Exception e) {
            SoulGraves.Companion.getPlugin().getLogger().severe("Unexpected Error: " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public final void shutdown() {
        block3: {
            this.shutdownHeartbeat();
            ExecutorService executorService = this.callbackExecutor;
            if (executorService != null) {
                executorService.shutdown();
            }
            StatefulRedisPubSubConnection<String, String> statefulRedisPubSubConnection = this.pubSubConnection;
            if (statefulRedisPubSubConnection != null) {
                statefulRedisPubSubConnection.close();
            }
            StatefulRedisConnection<String, String> statefulRedisConnection = this.connection;
            if (statefulRedisConnection != null) {
                statefulRedisConnection.close();
            }
            RedisClient redisClient = this.redisClient;
            if (redisClient == null) break block3;
            redisClient.shutdown();
        }
    }

    private static final void startHeartbeatTask$lambda$0(RedisDatabase this$0) {
        long timestamp = System.currentTimeMillis();
        String message = DatabaseManagerKt.getSERVER_NAME() + "|" + timestamp;
        this$0.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.HEARTBEAT, message));
    }

    private static final boolean startCleanupTask$lambda$3$lambda$1(long $currentTime, RedisDatabase this$0, Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        Object v = entry.getValue();
        Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
        Long lastSeen = (Long)v;
        return $currentTime - lastSeen > TimeUnit.SECONDS.toMillis(this$0.heartbeatTimeout);
    }

    private static final boolean startCleanupTask$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void startCleanupTask$lambda$3(RedisDatabase this$0) {
        long currentTime = System.currentTimeMillis();
        this$0.serverStatus.entrySet().removeIf(arg_0 -> RedisDatabase.startCleanupTask$lambda$3$lambda$2(arg_0 -> RedisDatabase.startCleanupTask$lambda$3$lambda$1(currentTime, this$0, arg_0), arg_0));
    }

    private static final void handleMessage$lambda$6$lambda$5(String $makerUUID, RedisDatabase this$0, String $msgUUID, String $sender) {
        UUID uUID = UUID.fromString($makerUUID);
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        Soul soul = SoulGraveAPI.INSTANCE.getSoul(uUID);
        if (soul != null) {
            soul.delete();
            this$0.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.API_ANSWER, $msgUUID + "|" + $sender + "|true"));
        } else {
            this$0.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.API_ANSWER, $msgUUID + "|" + $sender + "|false"));
        }
    }

    private static final void handleMessage$lambda$6(RedisPacket $packet, RedisDatabase this$0, String $sender) {
        String[] stringArray = new String[]{"|"};
        List list = StringsKt.split$default((CharSequence)$packet.getPayload(), stringArray, false, 3, 2, null);
        String msgUUID = (String)list.get(0);
        String targetServer = (String)list.get(1);
        String makerUUID = (String)list.get(2);
        if (!Intrinsics.areEqual(targetServer, DatabaseManagerKt.getSERVER_NAME())) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> RedisDatabase.handleMessage$lambda$6$lambda$5(makerUUID, this$0, msgUUID, $sender));
    }

    private static final void handleMessage$lambda$8$lambda$7(String $makerUUID, RedisDatabase this$0, String $msgUUID, String $sender) {
        UUID uUID = UUID.fromString($makerUUID);
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        Soul soul = SoulGraveAPI.INSTANCE.getSoul(uUID);
        if (soul != null) {
            soul.explode();
            this$0.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.API_ANSWER, $msgUUID + "|" + $sender + "|true"));
        } else {
            this$0.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.API_ANSWER, $msgUUID + "|" + $sender + "|false"));
        }
    }

    private static final void handleMessage$lambda$8(RedisPacket $packet, RedisDatabase this$0, String $sender) {
        String[] stringArray = new String[]{"|"};
        List list = StringsKt.split$default((CharSequence)$packet.getPayload(), stringArray, false, 3, 2, null);
        String msgUUID = (String)list.get(0);
        String targetServer = (String)list.get(1);
        String makerUUID = (String)list.get(2);
        if (!Intrinsics.areEqual(targetServer, DatabaseManagerKt.getSERVER_NAME())) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> RedisDatabase.handleMessage$lambda$8$lambda$7(makerUUID, this$0, msgUUID, $sender));
    }

    private static final void handleMessage$lambda$10$lambda$9(String $makerUUID, Soul $remoteCopySoul, RedisDatabase this$0, String $msgUUID, String $sender) {
        UUID uUID = UUID.fromString($makerUUID);
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        Soul currentServerSoul = SoulGraveAPI.INSTANCE.getSoul(uUID);
        if (currentServerSoul != null) {
            currentServerSoul.setOwnerUUID($remoteCopySoul.getOwnerUUID());
            currentServerSoul.setInventory($remoteCopySoul.getInventory());
            currentServerSoul.setXp($remoteCopySoul.getXp());
            currentServerSoul.setExpireTime($remoteCopySoul.getExpireTime());
            currentServerSoul.setTimeLeft((int)($remoteCopySoul.getExpireTime() - System.currentTimeMillis() / (long)1000));
            currentServerSoul.setFreezeTime($remoteCopySoul.getFreezeTime());
            this$0.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.API_ANSWER, $msgUUID + "|" + $sender + "|true"));
        } else {
            this$0.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.API_ANSWER, $msgUUID + "|" + $sender + "|false"));
        }
    }

    private static final void handleMessage$lambda$10(RedisPacket $packet, RedisDatabase this$0, String $sender) {
        String[] stringArray = new String[]{"|"};
        List list = StringsKt.split$default((CharSequence)$packet.getPayload(), stringArray, false, 3, 2, null);
        String msgUUID = (String)list.get(0);
        String targetServer = (String)list.get(1);
        String makerUUID = (String)list.get(2);
        if (!Intrinsics.areEqual(targetServer, DatabaseManagerKt.getSERVER_NAME())) {
            return;
        }
        MySQLDatabase mySQLDatabase = MySQLDatabase.Companion.getInstance();
        UUID uUID = UUID.fromString(makerUUID);
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        Soul remoteCopySoul = mySQLDatabase.getSoul(uUID);
        if (remoteCopySoul != null) {
            Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> RedisDatabase.handleMessage$lambda$10$lambda$9(makerUUID, remoteCopySoul, this$0, msgUUID, $sender));
        } else {
            this$0.publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.API_ANSWER, msgUUID + "|" + $sender + "|false"));
        }
    }

    private static final void handleMessage$lambda$11(RedisPacket $packet) {
        Player player;
        UUID ownerUUID = UUID.fromString($packet.getPayload());
        Player player2 = player = Bukkit.getPlayer((UUID)ownerUUID);
        boolean bl = player2 != null ? player2.isOnline() : false;
        if (bl) {
            if (MessageManager.INSTANCE.getSoulBurstComponent() != null) {
                Audience audience = SoulGraves.Companion.getPlugin().adventure().player(player);
                Component component = MessageManager.INSTANCE.getSoulBurstComponent();
                Intrinsics.checkNotNull(component);
                audience.sendMessage(component);
            }
            if (ConfigManager.INSTANCE.getSoulsDropItems() && MessageManager.INSTANCE.getSoulBurstDropItemsComponent() != null) {
                Audience audience = SoulGraves.Companion.getPlugin().adventure().player(player);
                Component component = MessageManager.INSTANCE.getSoulBurstDropItemsComponent();
                Intrinsics.checkNotNull(component);
                audience.sendMessage(component);
            } else if (MessageManager.INSTANCE.getSoulBurstLoseItemsComponent() != null) {
                Audience audience = SoulGraves.Companion.getPlugin().adventure().player(player);
                Component component = MessageManager.INSTANCE.getSoulBurstLoseItemsComponent();
                Intrinsics.checkNotNull(component);
                audience.sendMessage(component);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void handleMessage$lambda$13(RedisPacket $packet) {
        Player player;
        UUID ownerUUID = UUID.fromString($packet.getPayload());
        Player player2 = player = Bukkit.getPlayer((UUID)ownerUUID);
        boolean bl = player2 != null ? player2.isOnline() : false;
        if (bl) {
            if (MessageManager.INSTANCE.getSoulCollectOtherComponent() != null) {
                Audience audience = SoulGraves.Companion.getPlugin().adventure().player(player);
                Component component = MessageManager.INSTANCE.getSoulCollectOtherComponent();
                Intrinsics.checkNotNull(component);
                audience.sendMessage(component);
            }
            if (ConfigManager.INSTANCE.getNotifyOwnerPickupSound().getEnabled()) {
                Iterable $this$forEachIndexed$iv = ConfigManager.INSTANCE.getNotifyOwnerPickupSound().getSounds();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void soundKey;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    player.playSound(player.getLocation(), (String)soundKey, ((Number)ConfigManager.INSTANCE.getNotifyOwnerPickupSound().getVolumes().get(index)).floatValue(), ((Number)ConfigManager.INSTANCE.getNotifyOwnerPickupSound().getPitches().get(index)).floatValue());
                }
            }
        }
    }

    private static final void handleMessage$lambda$14(RedisPacket $packet) {
        block1: {
            String[] stringArray = new String[]{"|"};
            List list = StringsKt.split$default((CharSequence)$packet.getPayload(), stringArray, false, 3, 2, null);
            String msgUUID = (String)list.get(0);
            String targetServer = (String)list.get(1);
            String answer = (String)list.get(2);
            if (!Intrinsics.areEqual(targetServer, DatabaseManagerKt.getSERVER_NAME())) {
                return;
            }
            CompletableFuture<Boolean> completableFuture = RedisPublishAPI.INSTANCE.getPendingAnswersRequests().get(msgUUID);
            if (completableFuture == null) break block1;
            completableFuture.complete(Boolean.parseBoolean(answer));
        }
    }

    private static final void handleMessage$lambda$15(RedisPacket $packet, RedisDatabase this$0) {
        String[] stringArray = new String[]{"|"};
        List list = StringsKt.split$default((CharSequence)$packet.getPayload(), stringArray, false, 2, 2, null);
        String server = (String)list.get(0);
        String timestampStr = (String)list.get(1);
        long timestamp = Long.parseLong(timestampStr);
        Long l = timestamp;
        ((Map)this$0.serverStatus).put(server, l);
    }

    private static final void handleMessage$lambda$16(RedisPacket $packet, RedisDatabase this$0) {
        String server = $packet.getPayload();
        this$0.serverStatus.remove(server);
    }

    private static final RedisDatabase instance_delegate$lambda$17() {
        return new RedisDatabase();
    }

    @JvmStatic
    @NotNull
    public static final RedisDatabase getInstanceByJava() {
        return Companion.getInstanceByJava();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ldev/faultyfunctions/soulgraves/database/RedisDatabase$Companion;", "", "<init>", "()V", "instance", "Ldev/faultyfunctions/soulgraves/database/RedisDatabase;", "getInstance", "()Ldev/faultyfunctions/soulgraves/database/RedisDatabase;", "instance$delegate", "Lkotlin/Lazy;", "getInstanceByJava", "soulgraves"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RedisDatabase getInstance() {
            Lazy lazy = instance$delegate;
            return (RedisDatabase)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final RedisDatabase getInstanceByJava() {
            return this.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageAction.values().length];
            try {
                nArray[MessageAction.REMOVE_SOUL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageAction.EXPLODE_SOUL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageAction.UPDATE_SOUL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageAction.NOTIFY_SOUL_EXPLODE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageAction.NOTIFY_SOUL_OTHER_PICKUP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageAction.API_ANSWER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageAction.HEARTBEAT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageAction.HEARTBEAT_SHUTDOWN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

