/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.faultyfunctions.soulgraves.libs.rtag.Rtag;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.util.EasyLookup;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ComponentType {
    private static final Class<?> COMPONENT_TYPE = EasyLookup.classById("DataComponentType");
    private static final Class<?> REGISTRY_OPS_TYPE = EasyLookup.classById("RegistryOps");
    private static final Class<?> ERROR_TYPE;
    private static final Map<String, Object> TYPES;
    private static final Map<String, Codec<Object>> CODECS;
    @ApiStatus.Experimental
    public static final DynamicOps<Object> NBT_OPS;
    @ApiStatus.Experimental
    public static final DynamicOps<Object> JAVA_OPS;
    private static final MethodHandle CREATE;
    private static final MethodHandle RESULT;
    private static final MethodHandle CODEC;
    private static DynamicOps<Object> REGISTRY_NBT_OPS;
    private static DynamicOps<JsonElement> REGISTRY_JSON_OPS;
    private static DynamicOps<Object> REGISTRY_JAVA_OPS;

    ComponentType() {
    }

    public static Object of(Object type) {
        if (COMPONENT_TYPE.isInstance(type)) {
            return type;
        }
        return ComponentType.of(String.valueOf(type));
    }

    public static Object of(String name) {
        return TYPES.get(ComponentType.key(name));
    }

    public static Map<String, Object> all() {
        return Collections.unmodifiableMap(TYPES);
    }

    public static Codec<Object> codec(Object type) {
        if (COMPONENT_TYPE.isInstance(type)) {
            try {
                return CODEC.invoke(type);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot get codec from component type", t);
            }
        }
        return ComponentType.codec(String.valueOf(type));
    }

    public static Codec<Object> codec(String name) {
        return CODECS.get(ComponentType.key(name));
    }

    public static String key(String name) {
        if (name.startsWith("minecraft:") || name.contains(":")) {
            return name;
        }
        return "minecraft:" + name;
    }

    public static boolean isType(Object object) {
        return COMPONENT_TYPE.isInstance(object);
    }

    public static boolean exists(String name) {
        return TYPES.containsKey(ComponentType.key(name));
    }

    public static Optional<Object> parse(Object type, Object object) {
        if (TagBase.isTag(object)) {
            return ComponentType.parseNbt(type, object);
        }
        if (object instanceof JsonElement) {
            return ComponentType.parseJson(type, (JsonElement)object);
        }
        return ComponentType.parseJava(type, object);
    }

    public static <T> Optional<Object> parse(Object type, DynamicOps<T> dynamicOps, T object) {
        Codec<Object> codec = ComponentType.codec(type);
        if (codec == null) {
            return Optional.empty();
        }
        try {
            DynamicOps registryOps = REGISTRY_OPS_TYPE.isInstance(dynamicOps) ? dynamicOps : CREATE.invoke(dynamicOps, Rtag.getMinecraftRegistry());
            DataResult dataResult = codec.parse(registryOps, object);
            if (ERROR_TYPE.isInstance(dataResult)) {
                throw new IllegalArgumentException("" + dataResult);
            }
            return RESULT.invoke(dataResult);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot parse component" + (String)(type instanceof String ? " '" + type + "'" : ""), t);
        }
    }

    public static Optional<Object> parseNbt(Object type, Object nbt) {
        return ComponentType.parse(type, REGISTRY_NBT_OPS, nbt);
    }

    public static Optional<Object> parseJson(Object type, JsonElement json) {
        return ComponentType.parse(type, REGISTRY_JSON_OPS, json);
    }

    public static Optional<Object> parseJava(Object type, Object object) {
        return ComponentType.parse(type, REGISTRY_JAVA_OPS, object);
    }

    public static <T> Optional<T> encode(Object type, DynamicOps<T> dynamicOps, Object component) {
        if (component == null) {
            return Optional.empty();
        }
        Codec<Object> codec = ComponentType.codec(type);
        if (codec == null) {
            return Optional.empty();
        }
        try {
            DynamicOps registryOps = REGISTRY_OPS_TYPE.isInstance(dynamicOps) ? dynamicOps : CREATE.invoke(dynamicOps, Rtag.getMinecraftRegistry());
            DataResult dataResult = codec.encodeStart(registryOps, component);
            if (ERROR_TYPE.isInstance(dataResult)) {
                throw new IllegalArgumentException("" + dataResult);
            }
            return RESULT.invoke(dataResult);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot encode component" + (String)(type instanceof String ? " '" + type + "'" : ""), t);
        }
    }

    public static Optional<Object> encodeNbt(Object type, Object component) {
        return ComponentType.encode(type, REGISTRY_NBT_OPS, component);
    }

    public static Optional<JsonElement> encodeJson(Object type, Object component) {
        return ComponentType.encode(type, REGISTRY_JSON_OPS, component);
    }

    public static Optional<Object> encodeJava(Object type, Object component) {
        return ComponentType.encode(type, REGISTRY_JAVA_OPS, component);
    }

    static {
        TYPES = new HashMap<String, Object>();
        CODECS = new HashMap<String, Codec<Object>>();
        Class<?> class$Error = null;
        DynamicOps nbtOps = null;
        DynamicOps javaOps = null;
        MethodHandle method$create = null;
        MethodHandle method$result = null;
        MethodHandle method$codec = null;
        if (ServerInstance.Release.COMPONENT) {
            try {
                EasyLookup.addNMSClass("core.RegistryMaterials", "MappedRegistry");
                EasyLookup.addNMSClass("core.Holder");
                String nbtOps$instance = "a";
                String registry$create = "a";
                String registry$components = "as";
                String registry$map = "f";
                String resource$key = "a";
                String holder$value = "a";
                String codec = "b";
                if (ServerInstance.Type.MOJANG_MAPPED) {
                    nbtOps$instance = "INSTANCE";
                    registry$create = "create";
                    registry$components = "DATA_COMPONENT_TYPE";
                    registry$map = "byLocation";
                    resource$key = "getPath";
                    holder$value = "value";
                    codec = "codec";
                } else if (ServerInstance.VERSION >= 21.02f) {
                    registry$components = "ao";
                    registry$map = "e";
                } else if (ServerInstance.MAJOR_VERSION >= 21) {
                    registry$components = "aq";
                }
                class$Error = EasyLookup.addClass("com.mojang.serialization.DataResult$Error");
                nbtOps = (DynamicOps)EasyLookup.classById("DynamicOpsNBT").getDeclaredField(nbtOps$instance).get(null);
                javaOps = (DynamicOps)Class.forName("com.mojang.serialization.JavaOps").getDeclaredField("INSTANCE").get(null);
                method$create = EasyLookup.staticMethod("RegistryOps", registry$create, "RegistryOps", DynamicOps.class, "HolderLookup.Provider");
                Object componentsRegistry = EasyLookup.classById("BuiltInRegistries").getDeclaredField(registry$components).get(null);
                Map componentsMap = (Map)EasyLookup.field("RegistryMaterials", registry$map).get(componentsRegistry);
                Method keyMethod = EasyLookup.classById("MinecraftKey").getDeclaredMethod(resource$key, new Class[0]);
                Method valueMethod = EasyLookup.classById("Holder").getDeclaredMethod(holder$value, new Class[0]);
                Method codecMethod = EasyLookup.classById("DataComponentType").getDeclaredMethod(codec, new Class[0]);
                method$result = EasyLookup.unreflectMethod(DataResult.class.getDeclaredMethod("result", new Class[0]));
                method$codec = EasyLookup.unreflectMethod(codecMethod);
                for (Map.Entry entry : componentsMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    String key = (String)keyMethod.invoke(entry.getKey(), new Object[0]);
                    Object value = valueMethod.invoke(entry.getValue(), new Object[0]);
                    TYPES.put(ComponentType.key(key), value);
                    Codec valueCodec = (Codec)codecMethod.invoke(value, new Object[0]);
                    if (valueCodec == null) continue;
                    CODECS.put(ComponentType.key(key), (Codec<Object>)valueCodec);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        ERROR_TYPE = class$Error;
        NBT_OPS = nbtOps;
        JAVA_OPS = javaOps;
        CREATE = method$create;
        RESULT = method$result;
        CODEC = method$codec;
        try {
            REGISTRY_NBT_OPS = CREATE.invoke(NBT_OPS, Rtag.getMinecraftRegistry());
            REGISTRY_JSON_OPS = CREATE.invoke(JsonOps.INSTANCE, Rtag.getMinecraftRegistry());
            REGISTRY_JAVA_OPS = CREATE.invoke(JAVA_OPS, Rtag.getMinecraftRegistry());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

