/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item;

import dev.faultyfunctions.soulgraves.libs.rtag.Rtag;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ChatComponent;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ItemMaterialTag;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public class ItemData {
    private static final String ROOT_PATH = "==root";
    private static final Map<String, Object> COMPONENT_PATHS = new LinkedHashMap<String, Object>();
    private static final Map<String, Object> TAG_PATHS = new LinkedHashMap<String, Object>();
    private static final TreeMap<Float, Function<Map<String, Object>, Boolean>> COMPONENT_DETECTORS = new TreeMap(Comparator.reverseOrder());
    private static final TreeMap<Float, Function<Map<String, Object>, Boolean>> TAG_DETECTORS = new TreeMap(Comparator.reverseOrder());

    ItemData() {
    }

    public static Object[] getComponentPath(Object ... path) throws IndexOutOfBoundsException {
        return ItemData.getComponentPath(0, 0, path);
    }

    public static Object[] getComponentPath(int srcPos, int destPos, Object ... src) throws IndexOutOfBoundsException {
        int i;
        if (src == null) {
            return null;
        }
        if (srcPos < 0 || srcPos >= src.length) {
            throw new IndexOutOfBoundsException("Source position out of range:" + srcPos);
        }
        Map map = TAG_PATHS;
        Object[] componentPath = null;
        for (i = srcPos; i < src.length; ++i) {
            Object value = map.get(String.valueOf(src[i]));
            if (!(value instanceof Map)) {
                if (value instanceof Object[]) {
                    componentPath = (Object[])value;
                    break;
                }
                componentPath = (Object[])map.get(ROOT_PATH);
                --i;
                break;
            }
            map = (Map)value;
        }
        if (componentPath == null) {
            return src;
        }
        if (destPos < 0 || destPos >= componentPath.length) {
            throw new IndexOutOfBoundsException("Destination position out of range:" + srcPos);
        }
        int srcLength = src.length - ++i;
        int destLength = componentPath.length - destPos;
        Object[] path = new Object[srcLength + destLength];
        System.arraycopy(componentPath, destPos, path, 0, destLength);
        if (i < src.length) {
            System.arraycopy(src, i, path, destLength, srcLength);
        }
        return path;
    }

    public static Object[] getTagPath(Object ... path) throws IndexOutOfBoundsException {
        return ItemData.getTagPath(1, 0, path);
    }

    public static Object[] getTagPath(int srcPos, int destPos, Object ... src) throws IndexOutOfBoundsException {
        int i;
        if (src == null) {
            return null;
        }
        if (srcPos < 0 || srcPos >= src.length) {
            throw new IndexOutOfBoundsException("Source position out of range:" + srcPos);
        }
        Map map = COMPONENT_PATHS;
        Object[] tagPath = null;
        for (i = srcPos; i < src.length; ++i) {
            Object value;
            Object key = String.valueOf(src[i]);
            if (i == srcPos && !((String)key).contains(":")) {
                key = "minecraft:" + (String)key;
            }
            if (!((value = map.get(key)) instanceof Map)) {
                if (value instanceof Object[]) {
                    tagPath = (Object[])value;
                    break;
                }
                return src;
            }
            map = (Map)value;
        }
        if (tagPath == null) {
            return src;
        }
        if (destPos < 0 || destPos >= tagPath.length) {
            throw new IndexOutOfBoundsException("Destination position out of range:" + srcPos);
        }
        int srcLength = src.length - ++i;
        int destLength = tagPath.length - destPos;
        Object[] path = new Object[srcLength + destLength];
        System.arraycopy(tagPath, destPos, path, 0, destLength);
        if (i < src.length) {
            System.arraycopy(src, i, path, destLength, srcLength);
        }
        return path;
    }

    public static Float getItemVersion(Object compound) {
        int damage;
        if (compound == null) {
            return null;
        }
        Map<String, Object> value = TagCompound.getValue(compound);
        if (value.isEmpty()) {
            return null;
        }
        Object providedVersion = TagBase.getValue(value.get("DataVersion"));
        if (providedVersion == null) {
            providedVersion = TagBase.getValue(value.get("v"));
        }
        if (providedVersion instanceof Number) {
            int dataVersion = ((Number)providedVersion).intValue();
            int release = ServerInstance.release(dataVersion);
            return Float.valueOf(Float.parseFloat(ServerInstance.verNumber(dataVersion) + "." + (release < 10 ? "0" : "") + release));
        }
        Float detectedVersion = ItemData.detectVersion(compound, value);
        Object id = (String)TagBase.getValue(value.get("id"));
        if (id == null) {
            return null;
        }
        if (((String)id).startsWith("minecraft:")) {
            id = ((String)id).substring(10);
        }
        if (detectedVersion != null && detectedVersion.floatValue() < 13.0f && (damage = Rtag.INSTANCE.getOptional(compound, "Damage").asInt(0).intValue()) > 0) {
            id = (String)id + ":" + damage;
        }
        Float materialVersion = ItemData.findMaterialVersion((String)id, detectedVersion == null ? 8.0f : detectedVersion.floatValue());
        float finalVersion = Math.max(detectedVersion == null ? 0.0f : detectedVersion.floatValue(), materialVersion == null ? 0.0f : materialVersion.floatValue());
        return finalVersion > 0.0f ? Float.valueOf(finalVersion) : null;
    }

    private static Float detectVersion(Object compound, Map<String, Object> value) {
        String entity;
        Object components = value.get("components");
        if (components != null || TagBase.getValue(value.get("Count")) instanceof Integer) {
            Float version = ItemData.detectComponentVersion(components);
            return Float.valueOf(version == null ? 20.04f : version.floatValue());
        }
        Float version = ItemData.detectTagVersion(value.get("tag"));
        if ((version == null || version.floatValue() < 9.01f) && (entity = (String)Rtag.INSTANCE.get(compound, "EntityTag", "id")) != null) {
            if (entity.equals(entity.toLowerCase())) {
                if (entity.startsWith("minecraft:")) {
                    return Float.valueOf(11.01f);
                }
                return Float.valueOf(12.01f);
            }
            return Float.valueOf(9.01f);
        }
        return version;
    }

    private static Float detectComponentVersion(Object compound) {
        if (compound == null) {
            return null;
        }
        Float result = null;
        Map<String, Object> components = TagCompound.getValue(compound);
        if (components.containsKey("minecraft:bundle_contents")) {
            result = ItemData.detectListVersion(components.get("minecraft:bundle_contents"), null);
        }
        if (components.containsKey("minecraft:container")) {
            result = ItemData.maxVersion(result, ItemData.detectListVersion(components.get("minecraft:container"), "item"));
        }
        return ItemData.maxVersion(result, ItemData.detectMapVersion(components, COMPONENT_DETECTORS));
    }

    private static Float detectTagVersion(Object compound) {
        Object items;
        Object blockEntityTag;
        if (compound == null) {
            return null;
        }
        Float result = null;
        Map<String, Object> tag = TagCompound.getValue(compound);
        if (tag.containsKey("Items") && ((result = ItemData.detectListVersion(tag.get("Items"), null)) == null || result.floatValue() < 17.01f)) {
            result = Float.valueOf(17.01f);
        }
        if (TagCompound.isTagCompound(blockEntityTag = tag.get("BlockEntityTag")) && ((result = ItemData.maxVersion(result, ItemData.detectListVersion(items = TagCompound.get(blockEntityTag, "Items"), null))) == null || result.floatValue() < 9.01f)) {
            result = Float.valueOf(9.01f);
        }
        return ItemData.maxVersion(result, ItemData.detectMapVersion(tag, TAG_DETECTORS));
    }

    private static Float detectListVersion(Object iterable, String key) {
        if (!TagList.isTagList(iterable)) {
            return null;
        }
        Float result = null;
        for (Object compound : TagList.getValue(iterable)) {
            Float version = key == null ? ItemData.getItemVersion(compound) : ItemData.getItemVersion(TagCompound.get(compound, key));
            result = ItemData.maxVersion(result, version);
        }
        return result;
    }

    private static Float detectMapVersion(Map<String, Object> map, TreeMap<Float, Function<Map<String, Object>, Boolean>> detectors) {
        for (Map.Entry<Float, Function<Map<String, Object>, Boolean>> entry : detectors.entrySet()) {
            if (!entry.getValue().apply(map).booleanValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    private static Float maxVersion(Float version1, Float version2) {
        if (version1 == null) {
            return version2;
        }
        if (version2 == null) {
            return version1;
        }
        return Float.valueOf(Math.max(version1.floatValue(), version2.floatValue()));
    }

    private static Float findMaterialVersion(String id, float minimumVersion) {
        String mat = id.contains(":") ? id.substring(id.indexOf(58) + 1) : id;
        for (ItemMaterialTag material : ItemMaterialTag.VALUES) {
            for (Map.Entry<Float, String> entry : material.getNames().entrySet()) {
                if (entry.getKey().floatValue() < minimumVersion || !entry.getValue().equalsIgnoreCase(mat)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private static void loadPaths() {
        ItemData.loadPath("minecraft:repair_cost", "tag", "RepairCost");
        ItemData.loadPath("minecraft:unbreakable", "tag", "Unbreakable");
        ItemData.loadPath("minecraft:stored_enchantments", "tag", "StoredEnchantments");
        ItemData.loadPath("minecraft:custom_name", "tag", "display", "Name");
        ItemData.loadPath("minecraft:lore", "tag", "display", "Lore");
        ItemData.loadPath("minecraft:dyed_color", "tag", "display", "color");
        ItemData.loadPath("minecraft:map_color", "tag", "display", "MapColor");
        ItemData.loadPath("minecraft:map_decorations", "tag", "Decorations");
        ItemData.loadPath("minecraft:map_id", "tag", "map");
        ItemData.loadPath("minecraft:can_break", "tag", "CanDestroy");
        ItemData.loadPath("minecraft:can_place_on", "tag", "CanPlaceOn");
        ItemData.loadPath("minecraft:attribute_modifiers", "tag", "AttributeModifiers");
        ItemData.loadPath("minecraft:charged_projectiles", "tag", "ChargedProjectiles");
        ItemData.loadPath("minecraft:bundle_contents", "tag", "Items");
        ItemData.loadPath("minecraft:custom_model_data", "tag", "CustomModelData");
        ItemData.loadPath("minecraft:trim", "tag", "Trim");
        ItemData.loadPath("minecraft:suspicious_stew_effects", "tag", "effects");
        ItemData.loadPath("minecraft:debug_stick_state", "tag", "DebugProperty");
        ItemData.loadPath("minecraft:entity_data", "tag", "EntityTag");
        ItemData.loadPath("minecraft:instrument", "tag", "instrument");
        ItemData.loadPath("minecraft:recipes", "tag", "Recipes");
        ItemData.loadPath("minecraft:profile", new Object[]{"tag", "SkullOwner"}, Map.of("name", "Name", "id", "Id", "properties", "Properties"));
        ItemData.loadPath("minecraft:note_block_sound", "tag", "BlockEntityTag", "note_block_sound");
        ItemData.loadPath("minecraft:base_color", "tag", "BlockEntityTag", "Base");
        ItemData.loadPath("minecraft:banner_patterns", "tag", "BlockEntityTag", "Patterns");
        ItemData.loadPath("minecraft:pot_decorations", "tag", "BlockEntityTag", "sherds");
        ItemData.loadPath("minecraft:container", "tag", "BlockEntityTag", "Items");
        ItemData.loadPath("minecraft:bees", "tag", "BlockEntityTag", "Bees");
        ItemData.loadPath("minecraft:lock", "tag", "BlockEntityTag", "Lock");
        ItemData.loadPath("minecraft:container_loot", new Object[]{"tag", "BlockEntityTag"}, Map.of("loot_table", "LootTable", "seed", "LootTableSeed"));
        ItemData.loadPath("minecraft:block_entity_data", "tag", "BlockEntityTag");
        ItemData.loadPath("minecraft:block_state", "tag", "BlockStateTag");
        ItemData.loadPath("minecraft:potion_contents", Map.of("potion", "Potion", "custom_color", "CustomPotionColor", "custom_effects", "custom_potion_effects"));
        ItemData.loadPath("minecraft:written_book_content", Map.of("filtered_pages", "filtered_pages", "filtered_title", "filtered_title", "pages", "pages", "title", "title", "author", "author", "generation", "generation", "resolved", "resolved"));
        ItemData.loadPath("minecraft:bucket_entity_data", Map.of("NoAI", "NoAI", "Silent", "Silent", "NoGravity", "NoGravity", "Glowing", "Glowing", "Invulnerable", "Invulnerable", "Health", "Health", "Age", "Age", "Variant", "Variant", "HuntingCooldown", "HuntingCooldown", "BucketVariantTag", "BucketVariantTag"));
        ItemData.loadPath("minecraft:lodestone_tracker", Map.of("tracked", "LodestoneTracked", "target", Map.of("pos", "LodestonePos", "dimension", "LodestoneDimension")));
        ItemData.loadPath("minecraft:firework_explosion", new Object[]{"tag", "Explosion"}, Map.of("shape", "Type", "colors", "Colors", "fade_colors", "FadeColors", "has_trail", "Trail", "has_twinkle", "Flicker"));
        ItemData.loadPath("minecraft:fireworks", new Object[]{"tag", "Fireworks"}, Map.of("explosions", "Explosions", "flight_duration", "Flight"));
        ItemData.loadPath("minecraft:damage", "tag", "Damage");
        ItemData.loadPath("minecraft:enchantments", "tag", "Enchantments");
        ItemData.loadPath("minecraft:custom_data", "tag");
        ItemData.loadPath("minecraft:creative_slot_lock", "tag", "components", "minecraft:creative_slot_lock");
        ItemData.loadPath("minecraft:intangible_projectile", "tag", "components", "minecraft:intangible_projectile");
        ItemData.loadPath("minecraft:enchantment_glint_override", "tag", "components", "minecraft:enchantment_glint_override");
        ItemData.loadPath("minecraft:map_post_processing", "tag", "components", "minecraft:map_post_processing");
        ItemData.loadPath("minecraft:food", "tag", "components", "minecraft:food");
        ItemData.loadPath("minecraft:max_stack_size", "tag", "components", "minecraft:max_stack_size");
        ItemData.loadPath("minecraft:max_damage", "tag", "components", "minecraft:max_damage");
        ItemData.loadPath("minecraft:fire_resistant", "tag", "components", "minecraft:fire_resistant");
        ItemData.loadPath("minecraft:rarity", "tag", "components", "minecraft:rarity");
        ItemData.loadPath("minecraft:tool", "tag", "components", "minecraft:tool");
        ItemData.loadPath("minecraft:hide_tooltip", "tag", "components", "minecraft:hide_tooltip");
        ItemData.loadPath("minecraft:item_name", "tag", "components", "minecraft:item_name");
        ItemData.loadPath("minecraft:ominous_bottle_amplifier", "tag", "components", "minecraft:ominous_bottle_amplifier");
        ItemData.loadPath("minecraft:jukebox_playable", "tag", "components", "minecraft:jukebox_playable");
        ItemData.loadPath("minecraft:repairable", "tag", "components", "minecraft:repairable");
        ItemData.loadPath("minecraft:enchantable", "tag", "components", "minecraft:enchantable");
        ItemData.loadPath("minecraft:consumable", "tag", "components", "minecraft:consumable");
        ItemData.loadPath("minecraft:use_cooldown", "tag", "components", "minecraft:use_cooldown");
        ItemData.loadPath("minecraft:use_remainder", "tag", "components", "minecraft:use_remainder");
        ItemData.loadPath("minecraft:item_model", "tag", "components", "minecraft:item_model");
        ItemData.loadPath("minecraft:equippable", "tag", "components", "minecraft:equippable");
        ItemData.loadPath("minecraft:glider", "tag", "components", "minecraft:glider");
        ItemData.loadPath("minecraft:tooltip_style", "tag", "components", "minecraft:tooltip_style");
        ItemData.loadPath("minecraft:death_protection", "tag", "components", "minecraft:death_protection");
        ItemData.loadPath("minecraft:damage_resistant", "tag", "components", "minecraft:damage_resistant");
    }

    private static void loadPath(String name, Object ... path) {
        COMPONENT_PATHS.put(name, path);
        ItemData.loadTagPath(path, new Object[]{name});
    }

    private static void loadPath(String name, Map<String, Object> aliases) {
        ItemData.loadPath(name, new Object[]{"tag"}, aliases);
    }

    private static void loadPath(String name, Object[] path, Map<String, Object> aliases) {
        COMPONENT_PATHS.put(name, ItemData.loadComponentPath(new Object[]{name}, path, aliases));
    }

    private static Map<String, Object> loadComponentPath(Object[] root, Object[] start, Map<String, Object> path) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : path.entrySet()) {
            if (entry.getValue() instanceof Map) {
                map.put(entry.getKey(), ItemData.loadComponentPath(ItemData.append(root, entry.getKey()), start, (Map)entry.getValue()));
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            Object[] tagPath = ItemData.append(start, entry.getValue());
            map.put(entry.getKey(), tagPath);
            ItemData.loadTagPath(tagPath, ItemData.append(root, entry.getKey()));
        }
        return map;
    }

    private static void loadTagPath(Object[] tagPath, Object[] componentPath) {
        String key;
        HashMap<String, Object> map = TAG_PATHS;
        if (tagPath.length >= 2) {
            for (int i = 0; i < tagPath.length - 1; ++i) {
                String key2 = String.valueOf(tagPath[i]);
                HashMap<String, Object> subMap = (HashMap<String, Object>)map.get(key2);
                if (subMap == null) {
                    subMap = new HashMap<String, Object>();
                    map.put(key2, subMap);
                }
                map = subMap;
            }
        }
        if (map.get(key = String.valueOf(tagPath[tagPath.length - 1])) instanceof Map) {
            ((Map)map.get(key)).put(ROOT_PATH, ItemData.appendFirst(componentPath, "components"));
        } else {
            map.put(key, ItemData.appendFirst(componentPath, "components"));
        }
    }

    private static void loadComponentDetectors() {
        COMPONENT_DETECTORS.put(Float.valueOf(21.02f), components -> components.containsKey("minecraft:repairable") || components.containsKey("minecraft:enchantable") || components.containsKey("minecraft:consumable") || components.containsKey("minecraft:use_cooldown") || components.containsKey("minecraft:use_remainder"));
        COMPONENT_DETECTORS.put(Float.valueOf(21.01f), components -> {
            if (components.containsKey("minecraft:jukebox_playable")) {
                return true;
            }
            Object food = components.get("minecraft:food");
            if (food != null && TagCompound.get(food, "using_converts_to") != null) {
                return true;
            }
            Object attributeModifiers = components.get("minecraft:attribute_modifiers");
            return attributeModifiers != null && TagCompound.get(attributeModifiers, "id") != null;
        });
    }

    private static void loadTagDetectors() {
        TAG_DETECTORS.put(Float.valueOf(20.02f), tag -> tag.containsKey("custom_potion_effects") || tag.containsKey("effects"));
        TAG_DETECTORS.put(Float.valueOf(19.03f), tag -> ItemData.hasHideFlag(tag, 128));
        TAG_DETECTORS.put(Float.valueOf(16.02f), tag -> ItemData.hasHideFlag(tag, 64));
        TAG_DETECTORS.put(Float.valueOf(16.01f), tag -> tag.containsKey("SkullOwner") && TagBase.getValue(TagCompound.get(tag.get("SkullOwner"), "Id")) instanceof int[]);
        TAG_DETECTORS.put(Float.valueOf(14.01f), tag -> {
            Object lore;
            if (tag.containsKey("CustomModelData") || tag.containsKey("BlockStateTag")) {
                return true;
            }
            if (tag.containsKey("display") && (lore = TagCompound.get(tag.get("display"), "Lore")) != null) {
                for (Object line : TagList.getValue(lore)) {
                    if (ChatComponent.isChatComponent(TagBase.getValue(line))) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
        TAG_DETECTORS.put(Float.valueOf(13.01f), tag -> {
            Object name;
            if (tag.containsKey("Damage") || tag.containsKey("Enchantments")) {
                return true;
            }
            if (tag.containsKey("StoredEnchantments")) {
                Object storedEnchantments = tag.get("StoredEnchantments");
                for (Object entry : TagList.getValue(storedEnchantments)) {
                    Object id = TagBase.getValue(TagCompound.get(entry, "id"));
                    if (!(id instanceof String)) continue;
                    return true;
                }
            }
            if (tag.containsKey("display") && (name = TagCompound.get(tag.get("display"), "Name")) != null) {
                return ChatComponent.isChatComponent(TagBase.getValue(name));
            }
            return false;
        });
        TAG_DETECTORS.put(Float.valueOf(11.01f), tag -> ItemData.hasEnchantment(tag, 10, 22, 49, 71));
        TAG_DETECTORS.put(Float.valueOf(9.01f), tag -> tag.containsKey("Potion") || ItemData.hasEnchantment(tag, 9, 70));
        TAG_DETECTORS.put(Float.valueOf(8.01f), tag -> tag.containsKey("CanDestroy") || tag.containsKey("HideFlags") || tag.containsKey("BlockEntityTag"));
        TAG_DETECTORS.put(Float.valueOf(7.01f), tag -> tag.containsKey("Unbreakable"));
    }

    private static boolean hasHideFlag(Map<String, Object> tag, int flag) {
        if (tag.containsKey("HideFlags")) {
            int flags = (Integer)TagBase.getValue(tag.get("HideFlags"));
            if ((flags & flag) != flag) {
                return false;
            }
            return flags > 0;
        }
        return false;
    }

    private static boolean hasEnchantment(Map<String, Object> tag, int ... enchants) {
        Object enchantments = tag.getOrDefault("ench", tag.get("StoredEnchantments"));
        if (enchantments != null) {
            for (Object entry : TagList.getValue(enchantments)) {
                short id = (Short)TagBase.getValue(TagCompound.get(entry, "id"));
                for (int enchant : enchants) {
                    if (id != enchant) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Object[] append(Object[] array, Object obj) {
        Object[] a = new Object[array.length + 1];
        System.arraycopy(array, 0, a, 0, array.length);
        a[a.length - 1] = obj;
        return a;
    }

    private static Object[] appendFirst(Object[] array, Object obj) {
        Object[] a = new Object[array.length + 1];
        System.arraycopy(array, 0, a, 1, array.length);
        a[0] = obj;
        return a;
    }

    static {
        ItemData.loadPaths();
        ItemData.loadComponentDetectors();
        ItemData.loadTagDetectors();
    }
}

