/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item.mirror;

import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class IAttributeMirror
implements ItemMirror {
    private static final String PREFIX = "minecraft:";
    private static final Map<String, String> NEW_NAMES;
    private static final Map<String, String> OLD_NAMES;

    @Override
    public float getDeprecationVersion() {
        return 16.0f;
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        if (to >= 16.0f && from < 16.0f) {
            this.rename(components, NEW_NAMES);
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (from >= 16.0f && to < 16.0f && id.equals("minecraft:player_head")) {
            this.rename(components, OLD_NAMES);
        }
    }

    protected void rename(Object compound, Map<String, String> names) {
        Object modifiers = TagCompound.get(compound, "AttributeModifiers");
        if (modifiers == null) {
            return;
        }
        for (Object modifier : TagList.getValue(modifiers)) {
            Map<String, Object> map = TagCompound.getValue(modifier);
            Object name = map.remove("AttributeName");
            if (name == null) continue;
            map.put("type", TagBase.newTag(IAttributeMirror.rename((String)TagBase.getValue(name), nameValue -> names.getOrDefault(nameValue, (String)nameValue))));
        }
    }

    @NotNull
    public static String rename(@NotNull String type, @NotNull Function<String, String> function) {
        boolean starts = type.startsWith(PREFIX);
        String renamed = function.apply(starts ? type.substring(PREFIX.length()) : type);
        return starts ? PREFIX + renamed : renamed;
    }

    static {
        HashMap<String, String> names = new HashMap<String, String>();
        names.put("generic.maxHealth", "generic.max_health");
        names.put("zombie.spawnReinforcements", "zombie.spawn_reinforcements");
        names.put("horse.jumpStrength", "horse.jump_strength");
        names.put("generic.followRange", "generic.follow_range");
        names.put("generic.knockbackResistance", "generic.knockback_resistance");
        names.put("generic.movementSpeed", "generic.movement_speed");
        names.put("generic.flyingSpeed", "generic.flying_speed");
        names.put("generic.attackDamage", "generic.attack_damage");
        names.put("generic.attackKnockback", "generic.attack_knockback");
        names.put("generic.attackSpeed", "generic.attack_speed");
        names.put("generic.armorToughness", "generic.armor_toughness");
        HashMap<String, String> oldNames = new HashMap<String, String>();
        for (Map.Entry entry : names.entrySet()) {
            oldNames.put((String)entry.getValue(), (String)entry.getKey());
        }
        NEW_NAMES = Collections.unmodifiableMap(names);
        OLD_NAMES = Collections.unmodifiableMap(oldNames);
    }
}

