/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item.mirror;

import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemTagStream;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.util.List;

public class IBundleMirror
implements ItemMirror {
    private final ItemTagStream stream;
    private final String key;

    public IBundleMirror(ItemTagStream stream) {
        this(stream, ServerInstance.VERSION >= 20.04f);
    }

    public IBundleMirror(ItemTagStream stream, boolean component) {
        this.stream = stream;
        this.key = component ? "minecraft:bundle_contents" : "Items";
    }

    @Override
    public float getMinVersion() {
        return 17.0f;
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        if (this.matches(id, from)) {
            this.processTag(components, from, to);
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (this.matches(id, from)) {
            this.processTag(components, from, to);
        }
    }

    private boolean matches(String id, float from) {
        if (from >= 21.02f) {
            return id.endsWith("_bundle");
        }
        return id.equals("minecraft:bundle");
    }

    public void processTag(Object tag, float from, float to) {
        Object contents = TagCompound.get(tag, this.key);
        if (contents != null) {
            List<Object> items = TagList.getValue(contents);
            for (Object item : items) {
                this.stream.onLoad(item, from, to);
            }
        }
    }
}

