/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item.mirror;

import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ChatComponent;

public class IDisplayMirror
implements ItemMirror {
    private final boolean convertName;

    public IDisplayMirror() {
        this(true);
    }

    public IDisplayMirror(boolean convertName) {
        this.convertName = convertName;
    }

    @Override
    public float getDeprecationVersion() {
        return 14.0f;
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        if (this.convertName && to >= 13.0f && from < 13.0f && !this.processName(TagCompound.get(components, "display"), true)) {
            return;
        }
        if (to >= 14.0f && from < 14.0f) {
            this.processLore(TagCompound.get(components, "display"), true);
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (from >= 13.0f && to < 13.0f && !this.processName(TagCompound.get(components, "display"), false)) {
            return;
        }
        if (from >= 14.0f && to < 14.0f) {
            this.processLore(TagCompound.get(components, "display"), false);
        }
    }

    public void processLore(Object display, boolean toJson) {
        if (display == null) {
            return;
        }
        Object displayLore = TagCompound.get(display, "Lore");
        if (displayLore != null) {
            int size = TagList.size(displayLore);
            for (int i = 0; i < size; ++i) {
                Object tag = this.processTag(TagList.get(displayLore, i), toJson);
                if (tag == null) continue;
                TagList.set(displayLore, i, tag);
            }
        }
    }

    public boolean processName(Object display, boolean toJson) {
        if (display == null) {
            return false;
        }
        Object tag = this.processTag(TagCompound.get(display, "Name"), toJson);
        if (tag != null) {
            TagCompound.set(display, "Name", tag);
        }
        return true;
    }

    public Object processTag(Object tag, boolean toJson) {
        String string;
        Object tagValue = TagBase.getValue(tag);
        if (tagValue != null && !(string = String.valueOf(tagValue)).isBlank()) {
            return TagBase.newTag(this.processString(string, toJson));
        }
        return null;
    }

    public Object processString(String string, boolean toJson) {
        return toJson ? ChatComponent.toJsonOrNull(string) : ChatComponent.toString(string);
    }
}

