/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item.mirror;

import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.util.List;
import java.util.Map;
import org.bukkit.potion.PotionEffectType;

public class IEffectMirror
implements ItemMirror {
    private static final Map<Integer, String> ALIASES = Map.of(24, "glowing", 25, "levitation", 26, "luck", 27, "unluck", 28, "slow_falling", 29, "conduit_power", 30, "dolphins_grace", 31, "bad_omen", 32, "hero_of_the_village", 33, "darkness");
    private final String fromId;
    private final String toId;
    private final String fromDuration;
    private final String toDuration;

    public IEffectMirror() {
        this(ServerInstance.VERSION);
    }

    public IEffectMirror(float version) {
        if ((double)version >= 20.02) {
            this.fromId = "EffectId";
            this.toId = "id";
            this.fromDuration = "EffectDuration";
            this.toDuration = "duration";
        } else {
            this.fromId = "id";
            this.toId = "EffectId";
            this.fromDuration = "duration";
            this.toDuration = "EffectDuration";
        }
    }

    public IEffectMirror(String fromId, String toId, String fromDuration, String toDuration) {
        this.fromId = fromId;
        this.toId = toId;
        this.fromDuration = fromDuration;
        this.toDuration = toDuration;
    }

    @Override
    public float getMinVersion() {
        return 14.0f;
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        if (from <= 20.01f && to >= 20.02f && id.equals("minecraft:suspicious_stew")) {
            this.processEffects(components, "Effects", "effects", true);
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (to <= 20.01f && from >= 20.02f && id.equals("minecraft:suspicious_stew")) {
            this.processEffects(components, "effects", "Effects", false);
        }
    }

    public void processEffects(Object tag, String fromKey, String toKey, boolean useKey) {
        List effects;
        try {
            effects = (List)TagCompound.remove(tag, fromKey);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return;
        }
        if (effects == null) {
            return;
        }
        for (Object effect : effects) {
            Object duration;
            if (!TagCompound.isTagCompound(effect)) continue;
            Map<String, Object> map = TagCompound.getValue(effect);
            Object id = TagBase.getValue(map.remove(this.fromId));
            if (id != null) {
                if (useKey) {
                    if (id instanceof Number) {
                        id = "minecraft:" + this.getEffectKey(((Number)id).intValue());
                    }
                } else if (id instanceof String) {
                    id = this.getEffectId((String)id).byteValue();
                }
                map.put(this.toId, TagBase.newTag(id));
            }
            if ((duration = map.remove(this.fromDuration)) == null) continue;
            map.put(this.toDuration, duration);
        }
        TagCompound.set(tag, toKey, effects);
    }

    public String getEffectKey(int id) {
        PotionEffectType type = PotionEffectType.getById((int)id);
        if (type != null) {
            return type.getName().toLowerCase();
        }
        return ALIASES.getOrDefault(id, "speed");
    }

    public Integer getEffectId(String key) {
        String name = key.replace("minecraft:", "");
        PotionEffectType type = PotionEffectType.getByName((String)name);
        if (type != null) {
            return type.getId();
        }
        for (Map.Entry<Integer, String> entry : ALIASES.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        return 1;
    }
}

