/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.item.mirror;

import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import java.math.BigInteger;

public class ISkullOwnerMirror
implements ItemMirror {
    @Override
    public float getDeprecationVersion() {
        return 16.0f;
    }

    @Override
    public void upgrade(Object compound, String id, Object components, float from, float to) {
        if (to >= 19.0f && from < 16.0f && (id.equals("minecraft:player_head") || id.equals("minecraft:skull"))) {
            int[] uuid;
            Object skullOwner = TagCompound.get(components, "SkullOwner");
            if (skullOwner == null) {
                return;
            }
            Object ownerID = TagBase.getValue(TagCompound.get(skullOwner, "Id"));
            if (ownerID instanceof String && (uuid = ISkullOwnerMirror.getIntArrayUUID((String)ownerID)) != null) {
                TagCompound.set(skullOwner, "Id", TagBase.newTag(uuid));
            }
        }
    }

    @Override
    public void downgrade(Object compound, String id, Object components, float from, float to) {
        if (from >= 16.0f && to < 16.0f && id.equals("minecraft:player_head")) {
            String uuid;
            Object skullOwner = TagCompound.get(components, "SkullOwner");
            if (skullOwner == null) {
                return;
            }
            Object ownerID = TagBase.getValue(TagCompound.get(skullOwner, "Id"));
            if (ownerID instanceof int[] && (uuid = ISkullOwnerMirror.getHexadecimalUUID((int[])ownerID)) != null) {
                TagCompound.set(skullOwner, "Id", TagBase.newTag(uuid));
            }
        }
    }

    public static String getHexadecimalUUID(int[] array) {
        if (array.length == 4) {
            StringBuilder builder = new StringBuilder();
            for (int i : array) {
                String hex = Integer.toHexString(i);
                builder.append(new String(new char[8 - hex.length()]).replace('\u0000', '0')).append(hex);
            }
            if (builder.length() == 32) {
                return builder.insert(20, '-').insert(16, '-').insert(12, '-').insert(8, '-').toString();
            }
        }
        return null;
    }

    public static int[] getIntArrayUUID(String uuid) {
        int[] array = new int[4];
        String rawUUID = uuid.replace("-", "");
        try {
            for (int i = 0; i < 32; i += 8) {
                array[i / 8] = new BigInteger(rawUUID.substring(i, i + 8), 16).intValue();
            }
        }
        catch (Throwable t) {
            return null;
        }
        return array;
    }
}

