/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.stream;

import dev.faultyfunctions.soulgraves.libs.rtag.RtagMirror;
import dev.faultyfunctions.soulgraves.libs.rtag.stream.TStreamTools;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagBase;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagCompound;
import dev.faultyfunctions.soulgraves.libs.rtag.tag.TagList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class TStream<T> {
    public static final TStream<Object> COMPOUND = new TStream<Object>(){

        @Override
        public Object clone(Object object) {
            return TagCompound.safeClone(object);
        }
    };

    public T clone(T object) {
        return this.fromCompound(this.toCompound(object));
    }

    public Object extract(T object) {
        return object;
    }

    public T build(Object compound) {
        return (T)compound;
    }

    public Object toCompound(T object) {
        if (object == null) {
            return null;
        }
        Object compound = this.extract(object);
        if (TagCompound.isTagCompound(compound)) {
            return compound;
        }
        return null;
    }

    public void fromBase(Object nbt, Consumer<T> consumer) {
        switch (TagBase.getTypeId(nbt)) {
            case 7: {
                this.fromBytes((byte[])TagBase.getValue(nbt), consumer);
                break;
            }
            case 9: {
                this.fromList(nbt, consumer);
                break;
            }
            case 10: {
                this.fromCompound(nbt, consumer);
                break;
            }
        }
    }

    public T fromCompound(Object compound) {
        List<Object> list;
        if (TagCompound.isTagCompound(compound)) {
            try {
                return this.build(compound);
            }
            catch (Throwable t) {
                return null;
            }
        }
        if (TagList.isTagList(compound) && !(list = TagList.getValue(compound)).isEmpty()) {
            return this.fromCompound(list.get(0));
        }
        return null;
    }

    public void fromCompound(Object compound, Consumer<T> consumer) {
        T t = this.fromCompound(compound);
        if (t != null) {
            consumer.accept(t);
        }
    }

    public void fromList(Object list, Consumer<T> consumer) {
        switch (TagList.getType(list)) {
            case 7: {
                for (Object o : TagList.getValue(list)) {
                    this.fromBytes((byte[])TagBase.getValue(o), consumer);
                }
                break;
            }
            case 9: {
                for (Object o : TagList.getValue(list)) {
                    this.fromList(o, consumer);
                }
                break;
            }
            case 10: {
                for (Object o : TagList.getValue(list)) {
                    this.fromCompound(o, consumer);
                }
                break;
            }
        }
    }

    public Map<String, Object> toMap(T object) {
        return TagCompound.getValue(RtagMirror.INSTANCE, this.toCompound(object));
    }

    public String toString(T object) {
        return this.toCompound(object).toString();
    }

    public File toFile(T object, File file) {
        try {
            TStreamTools.write(this.toCompound(object), file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    @SafeVarargs
    public final String toBase64(T ... object) {
        return this.listToBase64(Arrays.asList(object));
    }

    public String listToBase64(List<T> objects) {
        String data = "";
        if (!objects.isEmpty()) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                 BukkitObjectOutputStream output = new BukkitObjectOutputStream((OutputStream)out);){
                for (T object : objects) {
                    byte[] bytes = this.toBytes(object);
                    if (bytes == null) continue;
                    output.writeObject((Object)bytes);
                }
                output.writeObject(null);
                data = Base64Coder.encodeLines((byte[])out.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public byte[] toBytes(T object) {
        byte[] byArray;
        Object compound = this.toCompound(object);
        if (compound == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            TStreamTools.write(compound, out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        out.close();
        return byArray;
    }

    public T fromMap(Map<String, Object> map) {
        return this.fromCompound(TagCompound.newTag(RtagMirror.INSTANCE, map));
    }

    public T fromString(String snbt) {
        return this.fromCompound(TagCompound.newTag(snbt));
    }

    public T fromFile(File file) {
        try {
            return this.fromCompound(TStreamTools.read(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void fromFile(File file, Consumer<T> consumer) {
        try {
            this.fromBase(TStreamTools.read(file), consumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public T[] fromBase64(String base64) {
        return this.listFromBase64(base64).toArray();
    }

    public void fromBase64(String base64, Consumer<T> consumer) {
        if (base64.equalsIgnoreCase("null")) {
            return;
        }
        this.fromBytes(Base64Coder.decodeLines((String)base64), consumer);
    }

    public List<T> listFromBase64(String base64) {
        if (base64.equalsIgnoreCase("null")) {
            return new ArrayList();
        }
        return this.listFromBytes(Base64Coder.decodeLines((String)base64));
    }

    public List<T> listFromBytes(byte[] bytes) {
        ArrayList list = new ArrayList();
        this.fromBytes(bytes, list::add);
        return list;
    }

    public T fromBytes(byte[] bytes) {
        try {
            return this.fromCompound(TStreamTools.read(bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void fromBytes(byte[] bytes, Consumer<T> consumer) {
        Boolean gzip;
        if (bytes.length < 3) {
            return;
        }
        Boolean bl = TStreamTools.isGzipHeader(bytes) ? Boolean.TRUE : (gzip = TStreamTools.isNbtHeader(bytes) ? Boolean.FALSE : null);
        if (gzip != null) {
            Object nbt;
            try (DataInputStream in = TStreamTools.getDataInput(new ByteArrayInputStream(bytes), gzip);){
                nbt = TStreamTools.read((DataInput)in);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (nbt != null) {
                this.fromBase(nbt, consumer);
            }
            return;
        }
        this.fromBukkitObject(bytes, consumer);
    }

    public void fromBukkitObject(byte[] bytes, Consumer<T> consumer) {
        try (ByteArrayInputStream in2 = new ByteArrayInputStream(bytes);
             BukkitObjectInputStream input = new BukkitObjectInputStream((InputStream)in2);){
            Object o;
            while ((o = input.readObject()) != null) {
                if (o instanceof byte[]) {
                    this.fromBytes((byte[])o, consumer);
                    continue;
                }
                try {
                    Object t = o;
                    consumer.accept(t);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (EOFException in2) {
        }
        catch (IOException | ClassNotFoundException e) {
            if (e.getMessage().contains("invalid stream header")) {
                throw new IllegalArgumentException("Unsupported serialization format", e);
            }
            e.printStackTrace();
        }
    }
}

