/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.util;

import dev.faultyfunctions.soulgraves.libs.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;

public class EasyLookup {
    private static final boolean DEBUG = "true".equals(System.getProperty("saicone.easylookup.debug"));
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final Map<Class<?>, MethodHandles.Lookup> privateLookups = new HashMap();
    private static final Map<String, Class<?>> classes = new HashMap();
    private static final MethodPredicate[] methodPredicates = new MethodPredicate[]{(m, type, params) -> m.getReturnType().equals(type) && Arrays.equals(m.getParameterTypes(), params), (m, type, params) -> type.isAssignableFrom(m.getReturnType()) && Arrays.equals(m.getParameterTypes(), params), (m, type, params) -> m.getReturnType().equals(type) && EasyLookup.isAssignableFrom(params, m.getParameterTypes()), (m, type, params) -> type.isAssignableFrom(m.getReturnType()) && EasyLookup.isAssignableFrom(params, m.getParameterTypes()), (m, type, params) -> Arrays.equals(m.getParameterTypes(), params), (m, type, params) -> EasyLookup.isAssignableFrom(params, m.getParameterTypes())};
    private static final String nmsPackage = ServerInstance.Release.UNIVERSAL ? "net.minecraft." : "net.minecraft.server." + ServerInstance.PACKAGE_VERSION + ".";
    private static final String obcPackage = Bukkit.getServer().getClass().getPackage().getName() + ".";

    EasyLookup() {
    }

    public static boolean testClass(String name) {
        boolean test = false;
        try {
            Class.forName(name);
            test = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return test;
    }

    public static Class<?> classById(String id) {
        return classes.get(id);
    }

    public static Class<?> classOf(Object object) {
        if (object instanceof Class) {
            return (Class)object;
        }
        return EasyLookup.classById(String.valueOf(object));
    }

    public static Class<?>[] classesOf(Object ... classes) {
        Class[] array = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            array[i] = EasyLookup.classOf(classes[i]);
        }
        return array;
    }

    public static Class<?> addClass(String name) throws ClassNotFoundException {
        return EasyLookup.addClass(name, new String[0]);
    }

    public static Class<?> addClass(String name, String ... aliases) throws ClassNotFoundException {
        return EasyLookup.addClassId(name.contains(".") ? name.substring(name.lastIndexOf(46) + 1) : name, name, aliases);
    }

    public static Class<?> addClassId(String id, String name, String ... aliases) throws ClassNotFoundException {
        Object finalName = null;
        if (EasyLookup.testClass(name)) {
            finalName = name;
        } else if (aliases.length > 0) {
            String pkg = name.contains(".") ? name.substring(0, name.lastIndexOf(46) + 1) : "";
            for (String alias : aliases) {
                String aliasName = (alias.contains(".") ? "" : pkg) + alias;
                if (!EasyLookup.testClass(aliasName)) continue;
                finalName = aliasName;
                break;
            }
        }
        if (finalName == null) {
            throw new ClassNotFoundException(name);
        }
        return EasyLookup.addClassId(id, Class.forName((String)finalName));
    }

    public static Class<?> addClassId(String id, Class<?> clazz) {
        if (!classes.containsKey(id)) {
            classes.put(id, clazz);
        }
        return clazz;
    }

    public static Class<?> addNMSClass(String name) throws ClassNotFoundException {
        return EasyLookup.addNMSClass(name, new String[0]);
    }

    public static Class<?> addNMSClass(String name, String ... aliases) throws ClassNotFoundException {
        return EasyLookup.addClass(EasyLookup.nmsClass(name, aliases), aliases);
    }

    public static Class<?> addNMSClassId(String id, String name, String ... aliases) throws ClassNotFoundException {
        return EasyLookup.addClassId(id, EasyLookup.nmsClass(name, aliases), aliases);
    }

    private static String nmsClass(String name, String ... aliases) {
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (!alias.contains(".")) continue;
            aliases[i] = nmsPackage + alias;
        }
        if (ServerInstance.Release.UNIVERSAL) {
            return nmsPackage + name;
        }
        return nmsPackage + (name.contains(".") ? name.substring(name.lastIndexOf(46) + 1) : name);
    }

    public static Class<?> addOBCClass(String name) throws ClassNotFoundException {
        return EasyLookup.addOBCClass(name, new String[0]);
    }

    public static Class<?> addOBCClass(String name, String ... aliases) throws ClassNotFoundException {
        return EasyLookup.addClass(EasyLookup.obcClass(name, aliases), aliases);
    }

    public static Class<?> addOBCClassId(String id, String name, String ... aliases) throws ClassNotFoundException {
        return EasyLookup.addClassId(id, EasyLookup.obcClass(name, aliases), aliases);
    }

    private static String obcClass(String name, String ... aliases) {
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (!alias.contains(".")) continue;
            aliases[i] = obcPackage + alias;
        }
        return obcPackage + name;
    }

    public static MethodHandles.Lookup privateLookup(Class<?> clazz) {
        return privateLookups.computeIfAbsent(clazz, c -> {
            try {
                return MethodHandles.privateLookupIn(clazz, lookup);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public static MethodHandle constructor(Object clazz, Object ... parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        Class<?> from = EasyLookup.classOf(clazz);
        try {
            return lookup.findConstructor(from, EasyLookup.type(Void.TYPE, parameterTypes));
        }
        catch (IllegalAccessException e) {
            if (DEBUG) {
                System.out.println("[Rtag] unreflectConstructor = '" + from.getName() + "(" + String.join((CharSequence)", ", EasyLookup.names(EasyLookup.classesOf(parameterTypes))) + ")'");
            }
            return EasyLookup.unreflectConstructor(from, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (DEBUG) {
                System.out.println("[Rtag] findConstructor = '" + from.getName() + "(" + String.join((CharSequence)", ", EasyLookup.names(EasyLookup.classesOf(parameterTypes))) + ")'");
            }
            return EasyLookup.unreflectConstructor(EasyLookup.findConstructor(from, EasyLookup.classesOf(parameterTypes)));
        }
    }

    public static MethodHandle unreflectConstructor(Constructor<?> constructor) throws IllegalAccessException {
        try {
            return lookup.unreflectConstructor(constructor);
        }
        catch (IllegalAccessException e) {
            constructor.setAccessible(true);
            return lookup.unreflectConstructor(constructor);
        }
    }

    public static MethodHandle unreflectConstructor(Object clazz, Object ... parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        Constructor<?> c = EasyLookup.classOf(clazz).getDeclaredConstructor(EasyLookup.classesOf(parameterTypes));
        c.setAccessible(true);
        return lookup.unreflectConstructor(c);
    }

    public static Constructor<?> findConstructor(Class<?> from, Class<?> ... parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        try {
            return from.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (Constructor<?> constructor : from.getDeclaredConstructors()) {
                if (!EasyLookup.isAssignableFrom(parameterTypes, constructor.getParameterTypes())) continue;
                return constructor;
            }
            throw new NoSuchMethodException("Cannot find a constructor like '" + from.getName() + "(" + String.join((CharSequence)", ", EasyLookup.names(parameterTypes)) + ")'");
        }
    }

    public static MethodHandle method(Object clazz, String name, Object returnType, Object ... parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        Class<?> from = EasyLookup.classOf(clazz);
        try {
            return lookup.findVirtual(from, name, EasyLookup.type(returnType, parameterTypes));
        }
        catch (IllegalAccessException e) {
            if (DEBUG) {
                System.out.println("[Rtag] unreflectMethod = '" + EasyLookup.classOf(returnType).getName() + " " + name + "(" + String.join((CharSequence)", ", EasyLookup.names(EasyLookup.classesOf(parameterTypes))) + ")' inside class " + from.getName());
            }
            return EasyLookup.unreflectMethod(from, name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (DEBUG) {
                System.out.println("[Rtag] findMethod = '" + EasyLookup.classOf(returnType).getName() + " " + name + "(" + String.join((CharSequence)", ", EasyLookup.names(EasyLookup.classesOf(parameterTypes))) + ")' inside class " + from.getName());
            }
            return EasyLookup.unreflectMethod(EasyLookup.findMethod(from, false, name, EasyLookup.classOf(returnType), EasyLookup.classesOf(parameterTypes)));
        }
    }

    public static MethodHandle unreflectMethod(Method method) throws IllegalAccessException {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            method.setAccessible(true);
            return lookup.unreflect(method);
        }
    }

    public static MethodHandle unreflectMethod(Object clazz, String name, Object ... parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        Method m = EasyLookup.classOf(clazz).getDeclaredMethod(name, EasyLookup.classesOf(parameterTypes));
        m.setAccessible(true);
        return lookup.unreflect(m);
    }

    public static MethodHandle staticMethod(Object clazz, String name, Object returnType, Object ... parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        Class<?> from = EasyLookup.classOf(clazz);
        try {
            return lookup.findStatic(from, name, EasyLookup.type(returnType, parameterTypes));
        }
        catch (IllegalAccessException e) {
            if (DEBUG) {
                System.out.println("[Rtag] unreflectMethod = 'static " + EasyLookup.classOf(returnType).getName() + " " + name + "(" + String.join((CharSequence)", ", EasyLookup.names(EasyLookup.classesOf(parameterTypes))) + ")' inside class " + from.getName());
            }
            return EasyLookup.unreflectMethod(from, name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (DEBUG) {
                System.out.println("[Rtag] findMethod = 'static " + EasyLookup.classOf(returnType).getName() + " " + name + "(" + String.join((CharSequence)", ", EasyLookup.names(EasyLookup.classesOf(parameterTypes))) + ")' inside class " + from.getName());
            }
            return EasyLookup.unreflectMethod(EasyLookup.findMethod(from, true, name, EasyLookup.classOf(returnType), EasyLookup.classesOf(parameterTypes)));
        }
    }

    public static Method findMethod(Class<?> from, boolean isStatic, String name, Class<?> returnType, Class<?> ... parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        try {
            return from.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method[] declaredMethods = (Method[])Arrays.stream(from.getDeclaredMethods()).filter(m -> Modifier.isStatic(m.getModifiers()) == isStatic).toArray(Method[]::new);
            Method foundMethod = null;
            for (MethodPredicate predicate : methodPredicates) {
                for (Method method : declaredMethods) {
                    if (!predicate.test(method, returnType, parameterTypes)) continue;
                    if (method.getName().equals(name)) {
                        return method;
                    }
                    if (foundMethod != null) continue;
                    foundMethod = method;
                }
                if (foundMethod != null) break;
            }
            if (foundMethod != null) {
                return foundMethod;
            }
            throw new NoSuchMethodException("Cannot find a method like '" + (isStatic ? "static " : "") + returnType.getName() + " " + name + "(" + String.join((CharSequence)", ", EasyLookup.names(parameterTypes)) + ")' inside class " + from.getName());
        }
    }

    public static boolean isAssignableFrom(Class<?>[] baseTypes, Class<?>[] checkedTypes) {
        if (baseTypes.length != checkedTypes.length) {
            return false;
        }
        for (int i = 0; i < baseTypes.length; ++i) {
            if (baseTypes[i].isAssignableFrom(checkedTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static MethodHandle getter(Object clazz, String name, Object returnType) throws NoSuchFieldException, IllegalAccessException {
        Class<?> from = EasyLookup.classOf(clazz);
        Class<?> type = EasyLookup.classOf(returnType);
        try {
            return lookup.findGetter(from, name, type);
        }
        catch (IllegalAccessException e) {
            if (DEBUG) {
                System.out.println("[Rtag] unreflectGetter = '" + type.getName() + " " + name + "' inside class " + from.getName());
            }
            return EasyLookup.unreflectGetter(from, name);
        }
        catch (NoSuchFieldException e) {
            if (DEBUG) {
                System.out.println("[Rtag] findGetter = '" + type.getName() + " " + name + "' inside class " + from.getName());
            }
            return EasyLookup.unreflectGetter(EasyLookup.findField(from, false, name, type));
        }
    }

    public static MethodHandle unreflectGetter(Field field) throws IllegalAccessException {
        try {
            return lookup.unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            field.setAccessible(true);
            return lookup.unreflectGetter(field);
        }
    }

    public static MethodHandle unreflectGetter(Object clazz, String name) throws NoSuchFieldException, IllegalAccessException {
        return lookup.unreflectGetter(EasyLookup.field(EasyLookup.classOf(clazz), name));
    }

    public static MethodHandle staticGetter(Object clazz, String name, Object returnType) throws NoSuchFieldException, IllegalAccessException {
        Class<?> from = EasyLookup.classOf(clazz);
        Class<?> type = EasyLookup.classOf(returnType);
        try {
            return lookup.findStaticGetter(from, name, type);
        }
        catch (IllegalAccessException e) {
            if (DEBUG) {
                System.out.println("[Rtag] unreflectGetter = 'static " + type.getName() + " " + name + "' inside class " + from.getName());
            }
            return EasyLookup.unreflectGetter(from, name);
        }
        catch (NoSuchFieldException e) {
            if (DEBUG) {
                System.out.println("[Rtag] unreflectGetter = 'static " + type.getName() + " " + name + "' inside class " + from.getName());
            }
            return EasyLookup.unreflectGetter(EasyLookup.findField(from, true, name, type));
        }
    }

    public static MethodHandle setter(Object clazz, String name, Object returnType) throws NoSuchFieldException, IllegalAccessException {
        Class<?> from = EasyLookup.classOf(clazz);
        Class<?> type = EasyLookup.classOf(returnType);
        try {
            return lookup.findSetter(from, name, type);
        }
        catch (IllegalAccessException e) {
            if (DEBUG) {
                System.out.println("[Rtag] unreflectSetter = '" + type.getName() + " " + name + "' inside class " + from.getName());
            }
            return EasyLookup.unreflectSetter(from, name);
        }
        catch (NoSuchFieldException e) {
            if (DEBUG) {
                System.out.println("[Rtag] findSetter = '" + type.getName() + " " + name + "' inside class " + from.getName());
            }
            return EasyLookup.unreflectSetter(EasyLookup.findField(from, false, name, type));
        }
    }

    public static MethodHandle unreflectSetter(Field field) throws IllegalAccessException {
        try {
            return lookup.unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            field.setAccessible(true);
            return lookup.unreflectSetter(field);
        }
    }

    public static MethodHandle unreflectSetter(Object clazz, String name) throws NoSuchFieldException, IllegalAccessException {
        return lookup.unreflectSetter(EasyLookup.field(EasyLookup.classOf(clazz), name));
    }

    public static MethodHandle staticSetter(Object clazz, String name, Object returnType) throws NoSuchFieldException, IllegalAccessException {
        Class<?> from = EasyLookup.classOf(clazz);
        Class<?> type = EasyLookup.classOf(returnType);
        try {
            return lookup.findStaticSetter(from, name, type);
        }
        catch (IllegalAccessException e) {
            if (DEBUG) {
                System.out.println("[Rtag] unreflectSetter = 'static " + type.getName() + " " + name + "' inside class " + from.getName());
            }
            return EasyLookup.unreflectSetter(from, name);
        }
        catch (NoSuchFieldException e) {
            if (DEBUG) {
                System.out.println("[Rtag] findSetter = 'static " + type.getName() + " " + name + "' inside class " + from.getName());
            }
            return EasyLookup.unreflectSetter(EasyLookup.findField(from, true, name, type));
        }
    }

    public static Field findField(Class<?> from, boolean isStatic, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
        try {
            Field field = from.getDeclaredField(name);
            if (Modifier.isStatic(field.getModifiers()) == isStatic && type.isAssignableFrom(field.getType())) {
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        for (Field field : from.getDeclaredFields()) {
            if (!field.getType().equals(type)) continue;
            return field;
        }
        for (Field field : from.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            return field;
        }
        throw new NoSuchFieldException("Cannot find a field like '" + (isStatic ? "static " : "") + type.getName() + " " + name + "' inside class " + from.getName());
    }

    public static Field field(Object clazz, String field) throws NoSuchFieldException {
        Field f = EasyLookup.classOf(clazz).getDeclaredField(field);
        f.setAccessible(true);
        return f;
    }

    private static MethodType type(Object returnType, Object ... classes) {
        return EasyLookup.type(EasyLookup.classOf(returnType), EasyLookup.classesOf(classes));
    }

    private static MethodType type(Class<?> returnType, Class<?> ... classes) {
        switch (classes.length) {
            case 0: {
                return MethodType.methodType(returnType);
            }
            case 1: {
                return MethodType.methodType(returnType, classes[0]);
            }
        }
        return MethodType.methodType(returnType, classes[0], Arrays.copyOfRange(classes, 1, classes.length));
    }

    private static String[] names(Class<?>[] classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getName();
        }
        return names;
    }

    static {
        try {
            EasyLookup.addClassId("byte[]", "[B", new String[0]);
            EasyLookup.addClassId("int[]", "[I", new String[0]);
            EasyLookup.addClassId("long[]", "[J", new String[0]);
            EasyLookup.addNMSClass("nbt.NBTBase", "Tag");
            EasyLookup.addNMSClass("nbt.NBTTagByte", "ByteTag");
            EasyLookup.addNMSClass("nbt.NBTTagByteArray", "ByteArrayTag");
            EasyLookup.addNMSClass("nbt.NBTTagCompound", "CompoundTag");
            EasyLookup.addNMSClass("nbt.NBTTagDouble", "DoubleTag");
            EasyLookup.addNMSClass("nbt.NBTTagFloat", "FloatTag");
            EasyLookup.addNMSClass("nbt.NBTTagInt", "IntTag");
            EasyLookup.addNMSClass("nbt.NBTTagIntArray", "IntArrayTag");
            EasyLookup.addNMSClass("nbt.NBTTagList", "ListTag");
            EasyLookup.addNMSClass("nbt.NBTTagLong", "LongTag");
            if (ServerInstance.MAJOR_VERSION >= 12) {
                EasyLookup.addNMSClass("nbt.NBTTagLongArray", "LongArrayTag");
            }
            EasyLookup.addNMSClass("nbt.NBTTagShort", "ShortTag");
            EasyLookup.addNMSClass("nbt.NBTTagString", "StringTag");
            if (ServerInstance.MAJOR_VERSION >= 13) {
                EasyLookup.addNMSClass("nbt.DynamicOpsNBT", "NbtOps");
                if (ServerInstance.VERSION >= 18.02f) {
                    EasyLookup.addNMSClass("resources.RegistryOps");
                    if (ServerInstance.VERSION >= 19.02f) {
                        EasyLookup.addNMSClass("core.registries.BuiltInRegistries");
                        EasyLookup.addNMSClass("resources.MinecraftKey", "ResourceLocation");
                    }
                }
            }
            if (ServerInstance.Release.COMPONENT) {
                EasyLookup.addNMSClass("core.component.DataComponentHolder");
                EasyLookup.addNMSClass("core.component.DataComponentMap");
                EasyLookup.addNMSClassId("DataComponentMap.Builder", "core.component.DataComponentMap$a", "core.component.DataComponentMap$Builder");
                EasyLookup.addNMSClassId("DataComponentMap.SimpleMap", "core.component.DataComponentMap$a$a", "core.component.DataComponentMap$Builder$SimpleMap");
                EasyLookup.addNMSClass("core.component.DataComponentPatch");
                EasyLookup.addNMSClassId("DataComponentPatch.Builder", "core.component.DataComponentPatch$a", "core.component.DataComponentPatch$Builder");
                EasyLookup.addNMSClass("core.component.PatchedDataComponentMap");
                EasyLookup.addNMSClass("core.component.TypedDataComponent");
                EasyLookup.addNMSClass("core.component.DataComponentType");
            }
            EasyLookup.addNMSClass("world.item.ItemStack");
            EasyLookup.addNMSClass("world.entity.Entity");
            EasyLookup.addNMSClass("world.level.block.entity.TileEntity", "BlockEntity");
            EasyLookup.addNMSClass("world.level.block.state.IBlockData", "BlockState");
            EasyLookup.addNMSClass("core.BlockPosition", "BlockPos");
            EasyLookup.addNMSClass("world.level.World", "Level");
            EasyLookup.addNMSClass("server.level.WorldServer", "ServerLevel");
            if (ServerInstance.MAJOR_VERSION >= 16) {
                EasyLookup.addNMSClass("core.IRegistryCustom", "RegistryAccess");
                EasyLookup.addNMSClass("world.level.IWorldReader", "LevelReader");
                if (ServerInstance.Release.COMPONENT) {
                    EasyLookup.addNMSClassId("HolderLookup.Provider", "core.HolderLookup$a", "core.HolderLookup$Provider");
                } else if (ServerInstance.VERSION >= 19.02f) {
                    EasyLookup.addNMSClassId("HolderLookup.Provider", "core.HolderLookup$b", "core.HolderLookup$Provider");
                }
            }
            EasyLookup.addOBCClass("CraftServer");
            EasyLookup.addOBCClass("inventory.CraftItemStack");
            EasyLookup.addOBCClass("entity.CraftEntity");
            EasyLookup.addOBCClass("block.CraftBlockState");
            EasyLookup.addOBCClass("CraftWorld");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface MethodPredicate {
        public boolean test(Method var1, Class<?> var2, Class<?>[] var3);
    }
}

