/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.rtag.util;

import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class IterableType<T>
implements Iterable<T> {
    protected abstract T getIterable();

    protected abstract void setIterable(T var1);

    public boolean isIterable() {
        return this.getIterable() != null && (this.getIterable() instanceof Iterable || this.getIterable().getClass().isArray());
    }

    public boolean isNotIterable() {
        return !this.isIterable();
    }

    @Override
    public Iterator<T> iterator() {
        T value = this.getIterable();
        Objects.requireNonNull(value, "Cannot iterate over empty object");
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().iterator();
        }
        if (value instanceof Object[]) {
            return new ObjectArrayIterator();
        }
        if (value.getClass().isArray()) {
            return new PrimitiveArrayIterator();
        }
        return new SingleObjectIterator();
    }

    private class ObjectArrayIterator
    extends ArrayIterator {
        private ObjectArrayIterator() {
        }

        @Override
        public int size() {
            return ((Object[])IterableType.this.getIterable()).length;
        }

        @Override
        public T get(int index) {
            return ((Object[])IterableType.this.getIterable())[index];
        }
    }

    private class PrimitiveArrayIterator
    extends ArrayIterator {
        private PrimitiveArrayIterator() {
        }

        @Override
        public int size() {
            return Array.getLength(IterableType.this.getIterable());
        }

        @Override
        public T get(int index) {
            return Array.get(IterableType.this.getIterable(), index);
        }
    }

    private class SingleObjectIterator
    implements Iterator<T> {
        private boolean consumed = false;

        private SingleObjectIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.consumed && IterableType.this.getIterable() != null;
        }

        @Override
        public T next() {
            if (this.consumed || IterableType.this.getIterable() == null) {
                throw new NoSuchElementException();
            }
            this.consumed = true;
            return IterableType.this.getIterable();
        }

        @Override
        public void remove() {
            if (!this.consumed) {
                throw new IllegalStateException();
            }
            IterableType.this.setIterable(null);
        }
    }

    private abstract class ArrayIterator
    implements Iterator<T> {
        int currentIndex;
        int lastIndex = -1;

        private ArrayIterator() {
        }

        public abstract int size();

        public abstract T get(int var1);

        @Override
        public boolean hasNext() {
            return this.currentIndex != this.size();
        }

        @Override
        public T next() {
            int i = this.currentIndex;
            if (i >= this.size()) {
                throw new NoSuchElementException();
            }
            this.currentIndex = i + 1;
            this.lastIndex = i;
            return this.get(this.lastIndex);
        }

        @Override
        public void remove() {
            if (this.lastIndex < 0) {
                throw new IllegalStateException();
            }
            this.remove(this.lastIndex);
            this.currentIndex = this.lastIndex;
            this.lastIndex = -1;
        }

        public void remove(int index) {
            int size = this.size();
            if (size == 0 || index >= size) {
                throw new ConcurrentModificationException();
            }
            Object newArray = Array.newInstance(IterableType.this.getIterable().getClass().getComponentType(), size - 1);
            boolean decrement = false;
            for (int i = 0; i < size; ++i) {
                if (i != index) {
                    Array.set(newArray, decrement ? i - 1 : i, this.get(i));
                    continue;
                }
                decrement = true;
            }
            IterableType.this.setIterable(newArray);
        }
    }
}

