/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.listeners;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.SoulGraveAPI;
import dev.faultyfunctions.soulgraves.database.MySQLDatabase;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.utils.Soul;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Ldev/faultyfunctions/soulgraves/listeners/PlayerConnectionEvent;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nPlayerConnectionEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerConnectionEvent.kt\ndev/faultyfunctions/soulgraves/listeners/PlayerConnectionEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1863#2,2:44\n1863#2,2:46\n*S KotlinDebug\n*F\n+ 1 PlayerConnectionEvent.kt\ndev/faultyfunctions/soulgraves/listeners/PlayerConnectionEvent\n*L\n20#1:44,2\n36#1:46,2\n*E\n"})
public final class PlayerConnectionEvent
implements Listener {
    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!ConfigManager.INSTANCE.getOfflineOwnerTimerFreeze()) {
            return;
        }
        long now = System.currentTimeMillis();
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Soul> playerSouls = SoulGraveAPI.INSTANCE.getPlayerSouls(uUID);
        Iterable $this$forEach$iv = playerSouls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Soul it = (Soul)element$iv;
            boolean bl = false;
            long offlineTime = now - it.getFreezeTime();
            it.setExpireTime(it.getExpireTime() + offlineTime);
            it.setFreezeTime(0L);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerConnectionEvent.onPlayerJoin$lambda$1$lambda$0(it));
        }
    }

    @EventHandler
    public final void onPlayerLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!ConfigManager.INSTANCE.getOfflineOwnerTimerFreeze()) {
            return;
        }
        long now = System.currentTimeMillis();
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Soul> playerSouls = SoulGraveAPI.INSTANCE.getPlayerSouls(uUID);
        Iterable $this$forEach$iv = playerSouls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Soul it = (Soul)element$iv;
            boolean bl = false;
            it.setFreezeTime(now);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerConnectionEvent.onPlayerLeave$lambda$3$lambda$2(it, now));
        }
    }

    private static final void onPlayerJoin$lambda$1$lambda$0(Soul $it) {
        MySQLDatabase.Companion.getInstance().updateSoulFreezeTime($it.getMarkerUUID(), 0L, $it.getExpireTime());
    }

    private static final void onPlayerLeave$lambda$3$lambda$2(Soul $it, long $now) {
        MySQLDatabase.Companion.getInstance().updateSoulFreezeTime($it.getMarkerUUID(), $now, $it.getExpireTime());
    }
}

