/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.listeners;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.RedisPublishAPI;
import dev.faultyfunctions.soulgraves.api.SoulGraveAPI;
import dev.faultyfunctions.soulgraves.api.event.SoulPreSpawnEvent;
import dev.faultyfunctions.soulgraves.api.event.SoulSpawnEvent;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.MessageManager;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.utils.Soul;
import dev.faultyfunctions.soulgraves.utils.SpigotCompatUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Ldev/faultyfunctions/soulgraves/listeners/PlayerDeathListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onPlayerDeathEvent", "", "e", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "findSafeLocation", "Lorg/bukkit/Location;", "locationToCheck", "explodeOldestSoul", "player", "Lorg/bukkit/entity/Player;", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nPlayerDeathListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerDeathListener.kt\ndev/faultyfunctions/soulgraves/listeners/PlayerDeathListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1863#2,2:162\n1863#2,2:164\n1053#2:167\n1863#2,2:168\n1#3:166\n*S KotlinDebug\n*F\n+ 1 PlayerDeathListener.kt\ndev/faultyfunctions/soulgraves/listeners/PlayerDeathListener\n*L\n50#1:162,2\n147#1:164,2\n124#1:167\n127#1:168,2\n*E\n"})
public final class PlayerDeathListener
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public final void onPlayerDeathEvent(@NotNull PlayerDeathEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = e.getEntity();
        Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
        Player player2 = player;
        if (ConfigManager.INSTANCE.getPermissionRequired() && !player2.hasPermission("soulgraves.spawn")) {
            return;
        }
        if (ConfigManager.INSTANCE.getDisabledWorlds().contains(player2.getWorld().getName())) {
            return;
        }
        if (e.getKeepInventory() || Intrinsics.areEqual(player2.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY), true)) {
            return;
        }
        if (player2.getLevel() == 0 && e.getDrops().isEmpty()) {
            return;
        }
        SoulPreSpawnEvent soulPreSpawnEvent = new SoulPreSpawnEvent(player2, e);
        Bukkit.getPluginManager().callEvent((Event)soulPreSpawnEvent);
        if (soulPreSpawnEvent.isCancelled()) {
            return;
        }
        List inventory = new ArrayList();
        PlayerInventory playerInventory = player2.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        Iterable $this$forEach$iv = (Iterable)playerInventory;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack item = (ItemStack)element$iv;
            boolean bl = false;
            boolean bl2 = item != null ? inventory.add(item) : inventory.add(null);
        }
        int xp = SpigotCompatUtils.INSTANCE.calculateTotalExperiencePoints(player2.getLevel());
        long deathTime = System.currentTimeMillis();
        long expireTime = deathTime + (long)((ConfigManager.INSTANCE.getTimeStable() + ConfigManager.INSTANCE.getTimeUnstable()) * 1000);
        World world = player2.getWorld();
        Location location = player2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Entity entity = world.spawnEntity(this.findSafeLocation(location), EntityType.MARKER);
        Intrinsics.checkNotNullExpressionValue(entity, "spawnEntity(...)");
        Entity marker = entity;
        marker.setPersistent(true);
        marker.setSilent(true);
        marker.setInvulnerable(true);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Location location2 = player2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Soul soul = Soul.Companion.createNewForPlayerDeath(uUID, marker, this.findSafeLocation(location2), inventory, xp, deathTime, expireTime);
        e.getDrops().clear();
        e.setDroppedExp(0);
        SoulSpawnEvent soulSpawnEvent = new SoulSpawnEvent(player2, soul);
        Bukkit.getPluginManager().callEvent((Event)soulSpawnEvent);
        if (ConfigManager.INSTANCE.getMaxSoulsPerPlayer() > 0) {
            this.explodeOldestSoul(player2);
        }
    }

    private final Location findSafeLocation(Location locationToCheck) {
        Location safeLocation = locationToCheck;
        Block block = safeLocation.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        World world = locationToCheck.getWorld();
        Intrinsics.checkNotNull(world);
        World.Environment environment = world.getEnvironment();
        Intrinsics.checkNotNullExpressionValue(environment, "getEnvironment(...)");
        World.Environment environment2 = environment;
        while (block2.getType().isSolid() || block2.isLiquid() || block2.getType() == Material.VOID_AIR) {
            if (environment2 == World.Environment.NETHER) {
                if (locationToCheck.getY() < 128.0 && safeLocation.getY() >= 127.0) {
                    return safeLocation;
                }
                if (locationToCheck.getY() >= 128.0 && safeLocation.getY() >= 254.0) {
                    return safeLocation;
                }
            }
            if (safeLocation.getY() >= 319.0) {
                return safeLocation;
            }
            safeLocation.add(0.0, 1.0, 0.0);
            block2 = safeLocation.getBlock();
        }
        return safeLocation;
    }

    private final void explodeOldestSoul(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerDeathListener.explodeOldestSoul$lambda$11(player));
    }

    private static final void explodeOldestSoul$lambda$11$lambda$6$lambda$4$lambda$3(Soul $soul) {
        $soul.explode();
    }

    private static final Unit explodeOldestSoul$lambda$11$lambda$9(Player $player, List it) {
        block2: {
            int toRemove;
            if (it.size() <= ConfigManager.INSTANCE.getMaxSoulsPerPlayer() || (toRemove = it.size() - ConfigManager.INSTANCE.getMaxSoulsPerPlayer()) <= 0) break block2;
            Intrinsics.checkNotNull(it);
            Iterable $this$forEach$iv = CollectionsKt.take(it, toRemove);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Soul soul = (Soul)element$iv;
                boolean bl = false;
                RedisPublishAPI.INSTANCE.explodeSoul(soul.getMarkerUUID());
            }
            Component component = MessageManager.INSTANCE.getSoulLimitExplodeComponent();
            if (component != null) {
                Component it2 = component;
                boolean bl = false;
                SoulGraves.Companion.getPlugin().adventure().player($player).sendMessage(it2);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void explodeOldestSoul$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void explodeOldestSoul$lambda$11(Player $player) {
        switch (WhenMappings.$EnumSwitchMapping$0[DatabaseManagerKt.getSTORAGE_MODE().ordinal()]) {
            case 1: {
                List<Soul> list;
                List<Soul> list2;
                UUID uUID = $player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                List<Soul> it = list2 = SoulGraveAPI.INSTANCE.getPlayerSouls(uUID);
                boolean bl = false;
                List<Soul> list3 = list = it.size() > ConfigManager.INSTANCE.getMaxSoulsPerPlayer() ? list2 : null;
                if (list == null) break;
                List<Soul> souls = list;
                boolean bl2 = false;
                Iterable $this$sortedBy$iv = souls;
                boolean $i$f$sortedBy = false;
                List sorted2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Soul it = (Soul)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getExpireTime());
                        it = (Soul)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getExpireTime());
                    }
                });
                int toRemove = souls.size() - ConfigManager.INSTANCE.getMaxSoulsPerPlayer();
                if (toRemove <= 0) break;
                Iterable $this$forEach$iv = CollectionsKt.take(sorted2, toRemove);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Soul soul = (Soul)element$iv;
                    boolean bl3 = false;
                    Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> PlayerDeathListener.explodeOldestSoul$lambda$11$lambda$6$lambda$4$lambda$3(soul));
                }
                Component component = MessageManager.INSTANCE.getSoulLimitExplodeComponent();
                if (component != null) {
                    Component it2 = component;
                    boolean bl4 = false;
                    SoulGraves.Companion.getPlugin().adventure().player($player).sendMessage(it2);
                }
                break;
            }
            case 2: {
                UUID uUID = $player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                CompletableFuture<List<Soul>> future = SoulGraveAPI.INSTANCE.getPlayerSoulsCrossServer(uUID);
                future.thenAccept(arg_0 -> PlayerDeathListener.explodeOldestSoul$lambda$11$lambda$10(arg_0 -> PlayerDeathListener.explodeOldestSoul$lambda$11$lambda$9($player, arg_0), arg_0));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.PDC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.CROSS_SERVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

