/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.tasks;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.utils.Soul;
import dev.faultyfunctions.soulgraves.utils.SoulState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/faultyfunctions/soulgraves/tasks/SoulRenderTask;", "Lorg/bukkit/scheduler/BukkitRunnable;", "soul", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "<init>", "(Ldev/faultyfunctions/soulgraves/utils/Soul;)V", "getSoul", "()Ldev/faultyfunctions/soulgraves/utils/Soul;", "run", "", "soulgraves"})
public final class SoulRenderTask
extends BukkitRunnable {
    @NotNull
    private final Soul soul;

    public SoulRenderTask(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        this.soul = soul;
    }

    @NotNull
    public final Soul getSoul() {
        return this.soul;
    }

    public void run() {
        World world = this.soul.getLocation().getWorld();
        if (!(world != null ? world.isChunkLoaded(this.soul.getLocation().getChunk()) : false)) {
            return;
        }
        double endRodOffsetY = Math.sin((double)System.currentTimeMillis() * 0.001) * 0.5;
        Enum<SoulState> enum_ = this.soul.getState();
        if (enum_ == SoulState.NORMAL) {
            World world2 = this.soul.getLocation().getWorld();
            if (world2 != null) {
                world2.spawnParticle(Particle.END_ROD, this.soul.getLocation().clone().add(0.0, 1.0 + endRodOffsetY, 0.0), 5, 0.01, 0.01, 0.01, 0.01, null, true);
            }
            World world3 = this.soul.getLocation().getWorld();
            if (world3 != null) {
                world3.spawnParticle(Particle.SCULK_SOUL, this.soul.getLocation().clone().add(0.0, 1.0, 0.0), 1, 0.3, 0.5, 0.3, 0.01, null, true);
            }
            World world4 = this.soul.getLocation().getWorld();
            if (world4 != null) {
                world4.spawnParticle(Particle.ELECTRIC_SPARK, this.soul.getLocation().clone().add(0.0, 1.0, 0.0), 1, 0.8, 0.5, 0.8, 0.0, null, true);
            }
        } else if (enum_ == SoulState.PANIC) {
            if (this.soul.getTimeLeft() > 1) {
                World world5 = this.soul.getLocation().getWorld();
                if (world5 != null) {
                    world5.spawnParticle(Particle.SCULK_SOUL, this.soul.getLocation().clone().add(0.0, 1.0, 0.0), this.soul.getTimeLeft() / 4, 0.01, 0.01, 0.01, 0.1, null, true);
                }
                World world6 = this.soul.getLocation().getWorld();
                if (world6 != null) {
                    world6.spawnParticle(Particle.END_ROD, this.soul.getLocation().clone().add(0.0, 1.0, 0.0), 1, 0.01, 0.01, 0.01, 0.01, null, true);
                }
            }
        } else if (enum_ == SoulState.EXPLODING && !this.soul.getImplosion()) {
            this.soul.setImplosion(true);
            new BukkitRunnable(this){
                final /* synthetic */ SoulRenderTask this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    World world = this.this$0.getSoul().getLocation().getWorld();
                    if (world != null) {
                        world.spawnParticle(Particle.SONIC_BOOM, this.this$0.getSoul().getLocation().clone().add(0.0, 1.0, 0.0), 1, 0.0, 0.0, 0.0, 0.0, null, true);
                    }
                    this.cancel();
                }
            }.runTaskLater((Plugin)SoulGraves.Companion.getPlugin(), 8L);
        }
    }
}

