/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.utils;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.RedisPublishAPI;
import dev.faultyfunctions.soulgraves.api.event.SoulDeleteEvent;
import dev.faultyfunctions.soulgraves.database.MySQLDatabase;
import dev.faultyfunctions.soulgraves.database.PDCDatabase;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.tasks.SoulExplodeTask;
import dev.faultyfunctions.soulgraves.tasks.SoulHintParticlesTask;
import dev.faultyfunctions.soulgraves.tasks.SoulPickupTask;
import dev.faultyfunctions.soulgraves.tasks.SoulRenderTask;
import dev.faultyfunctions.soulgraves.tasks.SoulSoundTask;
import dev.faultyfunctions.soulgraves.tasks.SoulStateTask;
import dev.faultyfunctions.soulgraves.tasks.SoulValidationTask;
import dev.faultyfunctions.soulgraves.utils.SoulState;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Marker;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 U2\u00020\u0001:\u0001UBo\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0006\u0010N\u001a\u00020OJ\u0006\u0010P\u001a\u00020OJ\u000e\u0010Q\u001a\u00020\u00142\u0006\u0010R\u001a\u00020\u0014J\u0006\u0010S\u001a\u00020\u0014J\u0006\u0010T\u001a\u00020OR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010'\"\u0004\b)\u0010*R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010-R\u000e\u0010.\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u00100\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010'\"\u0004\b2\u0010*R$\u0010\u000f\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010#\"\u0004\b4\u0010%R \u00105\u001a\b\u0012\u0004\u0012\u00020706X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010-\"\u0004\b>\u0010?R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u0004\u0018\u00010EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u0004\u0018\u00010IX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Ldev/faultyfunctions/soulgraves/utils/Soul;", "", "ownerUUID", "Ljava/util/UUID;", "markerUUID", "location", "Lorg/bukkit/Location;", "inventory", "", "Lorg/bukkit/inventory/ItemStack;", "xp", "", "deathTime", "", "expireTime", "timeLeft", "freezeTime", "serverId", "", "isLocal", "", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Lorg/bukkit/Location;Ljava/util/List;IJJIJLjava/lang/String;Z)V", "getOwnerUUID", "()Ljava/util/UUID;", "setOwnerUUID", "(Ljava/util/UUID;)V", "getMarkerUUID", "getLocation", "()Lorg/bukkit/Location;", "getInventory", "()Ljava/util/List;", "setInventory", "(Ljava/util/List;)V", "getXp", "()I", "setXp", "(I)V", "getDeathTime", "()J", "getFreezeTime", "setFreezeTime", "(J)V", "getServerId", "()Ljava/lang/String;", "()Z", "_expireTime", "_timeLeft", "value", "getExpireTime", "setExpireTime", "getTimeLeft", "setTimeLeft", "state", "", "Ldev/faultyfunctions/soulgraves/utils/SoulState;", "getState", "()Ljava/lang/Enum;", "setState", "(Ljava/lang/Enum;)V", "implosion", "getImplosion", "setImplosion", "(Z)V", "explodeTask", "Ldev/faultyfunctions/soulgraves/tasks/SoulExplodeTask;", "particleTask", "Ldev/faultyfunctions/soulgraves/tasks/SoulHintParticlesTask;", "pickupTask", "Ldev/faultyfunctions/soulgraves/tasks/SoulPickupTask;", "renderTask", "Ldev/faultyfunctions/soulgraves/tasks/SoulRenderTask;", "soundTask", "Ldev/faultyfunctions/soulgraves/tasks/SoulSoundTask;", "stateTask", "Ldev/faultyfunctions/soulgraves/tasks/SoulStateTask;", "validationTask", "Ldev/faultyfunctions/soulgraves/tasks/SoulValidationTask;", "startTasks", "", "saveData", "isValid", "forceLoadChunk", "explode", "delete", "Companion", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nSoul.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Soul.kt\ndev/faultyfunctions/soulgraves/utils/Soul\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,332:1\n1#2:333\n*E\n"})
public final class Soul {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private UUID ownerUUID;
    @NotNull
    private final UUID markerUUID;
    @NotNull
    private final Location location;
    @NotNull
    private List<ItemStack> inventory;
    private int xp;
    private final long deathTime;
    private long freezeTime;
    @NotNull
    private final String serverId;
    private final boolean isLocal;
    private long _expireTime;
    private int _timeLeft;
    @NotNull
    private Enum<SoulState> state;
    private boolean implosion;
    @Nullable
    private SoulExplodeTask explodeTask;
    @Nullable
    private SoulHintParticlesTask particleTask;
    @Nullable
    private SoulPickupTask pickupTask;
    @Nullable
    private SoulRenderTask renderTask;
    @Nullable
    private SoulSoundTask soundTask;
    @Nullable
    private SoulStateTask stateTask;
    @Nullable
    private SoulValidationTask validationTask;

    private Soul(UUID ownerUUID, UUID markerUUID, Location location, List<ItemStack> inventory, int xp, long deathTime, long expireTime, int timeLeft, long freezeTime, String serverId, boolean isLocal) {
        this.ownerUUID = ownerUUID;
        this.markerUUID = markerUUID;
        this.location = location;
        this.inventory = inventory;
        this.xp = xp;
        this.deathTime = deathTime;
        this.freezeTime = freezeTime;
        this.serverId = serverId;
        this.isLocal = isLocal;
        this._expireTime = expireTime;
        this._timeLeft = timeLeft;
        this.state = SoulState.NORMAL;
    }

    /* synthetic */ Soul(UUID uUID, UUID uUID2, Location location, List list, int n, long l, long l2, int n2, long l3, String string, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x100) != 0) {
            l3 = 0L;
        }
        if ((n3 & 0x200) != 0) {
            string = DatabaseManagerKt.getSERVER_NAME();
        }
        if ((n3 & 0x400) != 0) {
            bl = Intrinsics.areEqual(string, DatabaseManagerKt.getSERVER_NAME());
        }
        this(uUID, uUID2, location, list, n, l, l2, n2, l3, string, bl);
    }

    @NotNull
    public final UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public final void setOwnerUUID(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.ownerUUID = uUID;
    }

    @NotNull
    public final UUID getMarkerUUID() {
        return this.markerUUID;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final List<ItemStack> getInventory() {
        return this.inventory;
    }

    public final void setInventory(@NotNull List<ItemStack> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.inventory = list;
    }

    public final int getXp() {
        return this.xp;
    }

    public final void setXp(int n) {
        this.xp = n;
    }

    public final long getDeathTime() {
        return this.deathTime;
    }

    public final long getFreezeTime() {
        return this.freezeTime;
    }

    public final void setFreezeTime(long l) {
        this.freezeTime = l;
    }

    @NotNull
    public final String getServerId() {
        return this.serverId;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public final long getExpireTime() {
        return this._expireTime;
    }

    public final void setExpireTime(long value) {
        this._expireTime = value;
        this._timeLeft = RangesKt.coerceAtLeast((int)((value - System.currentTimeMillis()) / (long)1000), 0);
    }

    public final int getTimeLeft() {
        return this.isLocal ? this._timeLeft : RangesKt.coerceAtLeast((int)((this._expireTime - System.currentTimeMillis()) / (long)1000), 0);
    }

    public final void setTimeLeft(int value) {
        this._timeLeft = RangesKt.coerceAtLeast(value, 0);
        this._expireTime = System.currentTimeMillis() + (long)this._timeLeft * 1000L;
    }

    @NotNull
    public final Enum<SoulState> getState() {
        return this.state;
    }

    public final void setState(@NotNull Enum<SoulState> enum_) {
        Intrinsics.checkNotNullParameter(enum_, "<set-?>");
        this.state = enum_;
    }

    public final boolean getImplosion() {
        return this.implosion;
    }

    public final void setImplosion(boolean bl) {
        this.implosion = bl;
    }

    public final void startTasks() {
        SoulValidationTask soulValidationTask;
        SoulStateTask soulStateTask;
        SoulSoundTask soulSoundTask;
        SoulRenderTask soulRenderTask;
        SoulPickupTask soulPickupTask;
        SoulHintParticlesTask soulHintParticlesTask;
        SoulExplodeTask it;
        BukkitRunnable bukkitRunnable;
        if (!this.isLocal) {
            return;
        }
        SoulExplodeTask soulExplodeTask = this.explodeTask;
        if (soulExplodeTask == null) {
            bukkitRunnable = new SoulExplodeTask(this);
            it = bukkitRunnable;
            boolean bl = false;
            this.explodeTask = it;
            it.runTaskTimer((Plugin)SoulGraves.Companion.getPlugin(), 0L, 20L);
            soulExplodeTask = bukkitRunnable;
        }
        if ((soulHintParticlesTask = this.particleTask) == null) {
            bukkitRunnable = new SoulHintParticlesTask(this);
            it = bukkitRunnable;
            boolean bl = false;
            this.particleTask = it;
            it.runTaskTimer((Plugin)SoulGraves.Companion.getPlugin(), 0L, 100L);
            soulHintParticlesTask = bukkitRunnable;
        }
        if ((soulPickupTask = this.pickupTask) == null) {
            bukkitRunnable = new SoulPickupTask(this);
            it = bukkitRunnable;
            boolean bl = false;
            this.pickupTask = it;
            it.runTaskTimer((Plugin)SoulGraves.Companion.getPlugin(), 0L, 4L);
            soulPickupTask = bukkitRunnable;
        }
        if ((soulRenderTask = this.renderTask) == null) {
            bukkitRunnable = new SoulRenderTask(this);
            it = bukkitRunnable;
            boolean bl = false;
            this.renderTask = it;
            it.runTaskTimer((Plugin)SoulGraves.Companion.getPlugin(), 0L, 1L);
            soulRenderTask = bukkitRunnable;
        }
        if ((soulSoundTask = this.soundTask) == null) {
            bukkitRunnable = new SoulSoundTask(this);
            it = bukkitRunnable;
            boolean bl = false;
            this.soundTask = it;
            it.runTaskTimer((Plugin)SoulGraves.Companion.getPlugin(), 0L, 50L);
            soulSoundTask = bukkitRunnable;
        }
        if ((soulStateTask = this.stateTask) == null) {
            bukkitRunnable = new SoulStateTask(this);
            it = bukkitRunnable;
            boolean bl = false;
            this.stateTask = it;
            it.runTaskTimer((Plugin)SoulGraves.Companion.getPlugin(), 0L, 20L);
            soulStateTask = bukkitRunnable;
        }
        if ((soulValidationTask = this.validationTask) == null) {
            bukkitRunnable = new SoulValidationTask(this);
            it = bukkitRunnable;
            boolean bl = false;
            this.validationTask = it;
            it.runTaskTimer((Plugin)SoulGraves.Companion.getPlugin(), 0L, 100L);
            soulValidationTask = bukkitRunnable;
        }
    }

    public final void saveData() {
        if (this.isLocal && DatabaseManagerKt.getSTORAGE_MODE() == StorageType.PDC) {
            PDCDatabase.Companion.getInstance().saveSoul(this);
        } else if (this.isLocal && DatabaseManagerKt.getSTORAGE_MODE() == StorageType.CROSS_SERVER) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> Soul.saveData$lambda$7(this));
        }
    }

    public final boolean isValid(boolean forceLoadChunk) {
        World world = this.location.getWorld();
        if (world == null) {
            return false;
        }
        World world2 = world;
        if (!ConfigManager.INSTANCE.getOfflineOwnerTimerFreeze() && System.currentTimeMillis() >= this.getExpireTime()) {
            return false;
        }
        if (world2.isChunkLoaded(this.location.getChunk())) {
            UUID it = this.markerUUID;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)it);
            v2 = entity;
            if (entity == null) {
                return false;
            }
        } else {
            if (forceLoadChunk) {
                world2.loadChunk(this.location.getChunk());
                if (Bukkit.getEntity((UUID)this.markerUUID) == null) {
                    return false;
                }
            }
            v2 = Unit.INSTANCE;
        }
        return true;
    }

    public final boolean explode() {
        if (this.isLocal) {
            this.state = SoulState.EXPLODING;
            this.implosion = true;
            return true;
        }
        if (DatabaseManagerKt.getSTORAGE_MODE() == StorageType.CROSS_SERVER) {
            RedisPublishAPI.INSTANCE.explodeSoul(this.markerUUID);
            return true;
        }
        return false;
    }

    public final void delete() {
        SoulGraves.Companion.getPlugin().getLogger().info("SOUL DELETED!");
        if (this.isLocal && DatabaseManagerKt.getSTORAGE_MODE() == StorageType.PDC) {
            Unit unit;
            Unit unit2;
            SoulExplodeTask soulExplodeTask = this.explodeTask;
            if (soulExplodeTask != null) {
                soulExplodeTask.cancel();
            }
            SoulHintParticlesTask soulHintParticlesTask = this.particleTask;
            if (soulHintParticlesTask != null) {
                soulHintParticlesTask.cancel();
            }
            SoulPickupTask soulPickupTask = this.pickupTask;
            if (soulPickupTask != null) {
                soulPickupTask.cancel();
            }
            SoulRenderTask soulRenderTask = this.renderTask;
            if (soulRenderTask != null) {
                soulRenderTask.cancel();
            }
            SoulSoundTask soulSoundTask = this.soundTask;
            if (soulSoundTask != null) {
                soulSoundTask.cancel();
            }
            SoulStateTask soulStateTask = this.stateTask;
            if (soulStateTask != null) {
                soulStateTask.cancel();
            }
            SoulValidationTask soulValidationTask = this.validationTask;
            if (soulValidationTask != null) {
                soulValidationTask.cancel();
            }
            PDCDatabase.Companion.getInstance().deleteSoul(this);
            World world = this.location.getWorld();
            if (world != null) {
                world.loadChunk(this.location.getChunk());
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            Unit $this$delete_u24lambda_u249 = unit = unit2;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)this.markerUUID);
            Marker marker = entity instanceof Marker ? (Marker)entity : null;
            if (marker != null) {
                marker.remove();
            }
            SoulGraves.Companion.getSoulList().remove(this);
            SoulDeleteEvent event = new SoulDeleteEvent(this);
            Bukkit.getPluginManager().callEvent((Event)event);
        } else if (this.isLocal && DatabaseManagerKt.getSTORAGE_MODE() == StorageType.CROSS_SERVER) {
            Object event;
            Unit unit;
            SoulExplodeTask soulExplodeTask = this.explodeTask;
            if (soulExplodeTask != null) {
                soulExplodeTask.cancel();
            }
            SoulHintParticlesTask soulHintParticlesTask = this.particleTask;
            if (soulHintParticlesTask != null) {
                soulHintParticlesTask.cancel();
            }
            SoulPickupTask soulPickupTask = this.pickupTask;
            if (soulPickupTask != null) {
                soulPickupTask.cancel();
            }
            SoulRenderTask soulRenderTask = this.renderTask;
            if (soulRenderTask != null) {
                soulRenderTask.cancel();
            }
            SoulSoundTask soulSoundTask = this.soundTask;
            if (soulSoundTask != null) {
                soulSoundTask.cancel();
            }
            SoulStateTask soulStateTask = this.stateTask;
            if (soulStateTask != null) {
                soulStateTask.cancel();
            }
            SoulValidationTask soulValidationTask = this.validationTask;
            if (soulValidationTask != null) {
                soulValidationTask.cancel();
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> Soul.delete$lambda$10(this));
            World world = this.location.getWorld();
            if (world != null) {
                world.loadChunk(this.location.getChunk());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit $this$delete_u24lambda_u2411 = event = unit;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)this.markerUUID);
            Marker marker = entity instanceof Marker ? (Marker)entity : null;
            if (marker != null) {
                marker.remove();
            }
            SoulGraves.Companion.getSoulList().remove(this);
            event = new SoulDeleteEvent(this);
            Bukkit.getPluginManager().callEvent((Event)event);
        } else if (DatabaseManagerKt.getSTORAGE_MODE() == StorageType.CROSS_SERVER) {
            RedisPublishAPI.INSTANCE.deleteSoul(this.markerUUID);
        }
    }

    private static final void saveData$lambda$7(Soul this$0) {
        MySQLDatabase.Companion.getInstance().saveSoul(this$0);
    }

    private static final void delete$lambda$10(Soul this$0) {
        MySQLDatabase.Companion.getInstance().deleteSoul(this$0);
    }

    public /* synthetic */ Soul(UUID ownerUUID, UUID markerUUID, Location location, List inventory, int xp, long deathTime, long expireTime, int timeLeft, long freezeTime, String serverId, boolean isLocal, DefaultConstructorMarker $constructor_marker) {
        this(ownerUUID, markerUUID, location, inventory, xp, deathTime, expireTime, timeLeft, freezeTime, serverId, isLocal);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012JV\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012JN\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012\u00a8\u0006\u001a"}, d2={"Ldev/faultyfunctions/soulgraves/utils/Soul$Companion;", "", "<init>", "()V", "createNewForPlayerDeath", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "ownerUUID", "Ljava/util/UUID;", "marker", "Lorg/bukkit/entity/Entity;", "location", "Lorg/bukkit/Location;", "inventory", "", "Lorg/bukkit/inventory/ItemStack;", "xp", "", "deathTime", "", "expireTime", "createDataCopy", "markerUUID", "serverId", "", "freezeTime", "initAndStart", "soulgraves"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Soul createNewForPlayerDeath(@NotNull UUID ownerUUID, @NotNull Entity marker, @NotNull Location location, @NotNull List<ItemStack> inventory, int xp, long deathTime, long expireTime) {
            Intrinsics.checkNotNullParameter(ownerUUID, "ownerUUID");
            Intrinsics.checkNotNullParameter(marker, "marker");
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(inventory, "inventory");
            UUID uUID = marker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Soul soul = new Soul(ownerUUID, uUID, location, inventory, xp, deathTime, deathTime + (long)((ConfigManager.INSTANCE.getTimeStable() + ConfigManager.INSTANCE.getTimeUnstable()) * 1000), (int)((expireTime - deathTime) / (long)1000), 0L, null, true, 768, null);
            SoulGraves.Companion.getSoulList().add(soul);
            soul.startTasks();
            soul.saveData();
            return soul;
        }

        @NotNull
        public final Soul createDataCopy(@NotNull UUID ownerUUID, @NotNull UUID markerUUID, @NotNull Location location, @NotNull List<ItemStack> inventory, int xp, @NotNull String serverId, long deathTime, long expireTime, long freezeTime) {
            Intrinsics.checkNotNullParameter(ownerUUID, "ownerUUID");
            Intrinsics.checkNotNullParameter(markerUUID, "markerUUID");
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(inventory, "inventory");
            Intrinsics.checkNotNullParameter(serverId, "serverId");
            int n = (int)((expireTime - deathTime) / (long)1000);
            return new Soul(ownerUUID, markerUUID, location, inventory, xp, deathTime, expireTime, n, freezeTime, serverId, false, null);
        }

        @NotNull
        public final Soul initAndStart(@NotNull UUID markerUUID, @NotNull UUID ownerUUID, @NotNull Location location, @NotNull List<ItemStack> inventory, int xp, long deathTime, long expireTime, long freezeTime) {
            Intrinsics.checkNotNullParameter(markerUUID, "markerUUID");
            Intrinsics.checkNotNullParameter(ownerUUID, "ownerUUID");
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(inventory, "inventory");
            int n = (int)((expireTime - deathTime) / (long)1000);
            Soul soul = new Soul(ownerUUID, markerUUID, location, inventory, xp, deathTime, expireTime, n, freezeTime, null, true, 512, null);
            return soul;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

