/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.data.candies;

import de.markusbordihn.cookiescandyandcakes.config.CandyConfig;
import de.markusbordihn.cookiescandyandcakes.data.SpecialItemEffect;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public enum CandyType {
    TEST_CANDY(CandyVariant.NORMAL, null, 0),
    TEST_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 0),
    TEST_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 0),
    APPLE_CANDY(CandyVariant.NORMAL, null, 0),
    APPLE_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 0),
    APPLE_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.WEAKNESS, 0),
    CHORUS_CANDY(CandyVariant.NORMAL, null, 0),
    CHORUS_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.LEVITATION, 0),
    CHORUS_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.CONFUSION, 0),
    CHOCOLATE_CANDY(CandyVariant.NORMAL, null, 0),
    CHOCOLATE_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 0),
    CHOCOLATE_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.HUNGER, 0),
    GLOW_BERRY_CANDY(CandyVariant.NORMAL, null, 0),
    GLOW_BERRY_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.GLOWING, 0),
    GLOW_BERRY_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.BLINDNESS, 0),
    GOLDEN_CANDY(CandyVariant.NORMAL, (Holder<MobEffect>)MobEffects.SATURATION, 0),
    GOLDEN_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.REGENERATION, 1),
    GOLDEN_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.POISON, 0),
    MELON_CANDY(CandyVariant.NORMAL, null, 0),
    MELON_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.HEAL, 0),
    MELON_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.HARM, 0),
    PUMPKIN_CANDY(CandyVariant.NORMAL, null, 0),
    PUMPKIN_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.ABSORPTION, 0),
    PUMPKIN_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.UNLUCK, 0),
    SWEET_BERRY_CANDY(CandyVariant.NORMAL, null, 0),
    SWEET_BERRY_CANDY_MYSTIC(CandyVariant.MYSTIC, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 1),
    SWEET_BERRY_CANDY_CURSED(CandyVariant.CURSED, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 1);

    private final CandyVariant variant;
    private final Holder<MobEffect> effect;
    private final int amplifier;
    private final String id;

    private CandyType(CandyVariant variant, Holder<MobEffect> effect, int amplifier) {
        this.variant = variant;
        this.effect = effect;
        this.amplifier = amplifier;
        this.id = this.name().toLowerCase(Locale.ROOT);
    }

    public String getId() {
        return this.id;
    }

    public CandyVariant getVariant() {
        return this.variant;
    }

    public Holder<MobEffect> getEffect() {
        return this.effect;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean hasEffect() {
        return this.effect != null;
    }

    public int getNutrition() {
        return CandyConfig.getNutrition(this);
    }

    public int getEffectDuration() {
        return CandyConfig.getEffectDuration(this);
    }

    public float getEffectChance() {
        return CandyConfig.getEffectChance(this);
    }

    public SpecialItemEffect getSpecialCandyEffect() {
        return CandyConfig.getSpecialCandyEffect(this);
    }

    public static enum CandyVariant {
        NORMAL,
        MYSTIC,
        CURSED;

    }
}

