/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect.cookie.client;

import de.markusbordihn.cookiescandyandcakes.effect.ClientEffectInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ElderGuardianCookieMysticEffectClient
implements ClientEffectInterface {
    private static final int SPAWN_TICK = 20;
    private static final int GAZE_DURATION = 200;
    private static final int DISSOLVE_TICK = 220;
    private static final int TOTAL_DURATION = 260;
    private static final int GUARDIAN_SPAWN_TICK = 60;
    private final List<Guardian> guardians = new ArrayList<Guardian>();
    private ElderGuardian elderGuardian;
    private Vec3 elderGuardianBasePos;
    private int breathingTick = 0;

    @Override
    public int getDuration() {
        return 260;
    }

    @Override
    public void tick(LocalPlayer localPlayer, int elapsedTicks) {
        Level level = localPlayer.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        if (elapsedTicks == 20) {
            this.spawnElderGuardian(clientLevel, localPlayer);
        } else if (elapsedTicks == 60) {
            this.spawnSideGuardians(clientLevel, localPlayer);
        } else if (elapsedTicks > 20 && elapsedTicks < 220) {
            this.updateElderGuardian(localPlayer);
            ++this.breathingTick;
        } else if (elapsedTicks == 220) {
            this.dissolveElderGuardian(clientLevel);
            this.dissolveGuardians(clientLevel);
        }
    }

    @Override
    public void onStart(LocalPlayer localPlayer) {
        this.elderGuardian = null;
        this.guardians.clear();
        this.elderGuardianBasePos = null;
        this.breathingTick = 0;
    }

    @Override
    public void onEnd(LocalPlayer localPlayer) {
        if (this.elderGuardian != null && this.elderGuardian.isAlive()) {
            this.elderGuardian.discard();
        }
        this.elderGuardian = null;
        for (Guardian guardian : this.guardians) {
            if (guardian == null || !guardian.isAlive()) continue;
            guardian.discard();
        }
        this.guardians.clear();
    }

    private void spawnElderGuardian(ClientLevel level, LocalPlayer player) {
        Vec3 lookDirection = player.getLookAngle();
        this.elderGuardianBasePos = player.position().add(lookDirection.scale(3.0)).add(0.0, 1.0, 0.0);
        this.elderGuardian = (ElderGuardian)EntityType.ELDER_GUARDIAN.create((Level)level);
        if (this.elderGuardian != null) {
            this.elderGuardian.setPos(this.elderGuardianBasePos.x, this.elderGuardianBasePos.y, this.elderGuardianBasePos.z);
            this.elderGuardian.setNoGravity(true);
            this.elderGuardian.setInvulnerable(true);
            this.elderGuardian.setSilent(true);
            float yaw = (float)Math.toDegrees(Math.atan2(-lookDirection.x, lookDirection.z));
            this.elderGuardian.setYRot(yaw);
            this.elderGuardian.yRotO = yaw;
            this.elderGuardian.setYHeadRot(yaw);
            level.addEntity((Entity)this.elderGuardian);
            level.playLocalSound(this.elderGuardianBasePos.x, this.elderGuardianBasePos.y, this.elderGuardianBasePos.z, SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.HOSTILE, 1.0f, 1.0f, false);
            this.spawnWaterParticles(level, this.elderGuardianBasePos);
        }
    }

    private void spawnSideGuardians(ClientLevel level, LocalPlayer player) {
        Guardian rightGuardian;
        if (this.elderGuardianBasePos == null) {
            return;
        }
        Vec3 lookDirection = player.getLookAngle();
        Vec3 rightDirection = new Vec3(-lookDirection.z, 0.0, lookDirection.x).normalize();
        Guardian leftGuardian = (Guardian)EntityType.GUARDIAN.create((Level)level);
        if (leftGuardian != null) {
            Vec3 leftPos = this.elderGuardianBasePos.add(rightDirection.scale(-4.0)).add(0.0, 0.5, 0.0);
            leftGuardian.setPos(leftPos.x, leftPos.y, leftPos.z);
            leftGuardian.setNoGravity(true);
            leftGuardian.setInvulnerable(true);
            leftGuardian.setSilent(true);
            level.addEntity((Entity)leftGuardian);
            this.guardians.add(leftGuardian);
            this.spawnWaterParticles(level, leftPos);
        }
        if ((rightGuardian = (Guardian)EntityType.GUARDIAN.create((Level)level)) != null) {
            Vec3 rightPos = this.elderGuardianBasePos.add(rightDirection.scale(4.0)).add(0.0, 0.5, 0.0);
            rightGuardian.setPos(rightPos.x, rightPos.y, rightPos.z);
            rightGuardian.setNoGravity(true);
            rightGuardian.setInvulnerable(true);
            rightGuardian.setSilent(true);
            level.addEntity((Entity)rightGuardian);
            this.guardians.add(rightGuardian);
            this.spawnWaterParticles(level, rightPos);
        }
        level.playLocalSound(this.elderGuardianBasePos.x, this.elderGuardianBasePos.y, this.elderGuardianBasePos.z, SoundEvents.GUARDIAN_AMBIENT, SoundSource.HOSTILE, 1.0f, 0.9f, false);
    }

    private void updateElderGuardian(LocalPlayer player) {
        float yaw;
        Vec3 direction;
        Vec3 playerPos;
        if (this.elderGuardian != null && this.elderGuardian.isAlive() && this.elderGuardianBasePos != null) {
            double breathingOffset = Math.sin((double)this.breathingTick * 0.05) * 0.15;
            Vec3 newPos = this.elderGuardianBasePos.add(0.0, breathingOffset, 0.0);
            this.elderGuardian.setPos(newPos.x, newPos.y, newPos.z);
            playerPos = player.getEyePosition();
            direction = playerPos.subtract(newPos).normalize();
            yaw = (float)Math.toDegrees(Math.atan2(-direction.x, direction.z));
            this.elderGuardian.setYRot(yaw);
            this.elderGuardian.setYHeadRot(yaw);
            Level level = player.level();
            if (level instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)level;
                if (player.tickCount % 10 == 0) {
                    this.spawnBubbleParticles(clientLevel, newPos);
                }
            }
        }
        for (Guardian guardian : this.guardians) {
            if (guardian == null || !guardian.isAlive()) continue;
            Vec3 guardianPos = guardian.position();
            playerPos = player.getEyePosition();
            direction = playerPos.subtract(guardianPos).normalize();
            yaw = (float)Math.toDegrees(Math.atan2(-direction.x, direction.z));
            guardian.setYRot(yaw);
            guardian.setYHeadRot(yaw);
        }
    }

    private void dissolveElderGuardian(ClientLevel level) {
        if (this.elderGuardian != null && this.elderGuardian.isAlive()) {
            Vec3 pos = this.elderGuardian.position();
            for (int i = 0; i < 30; ++i) {
                double offsetX = (level.random.nextDouble() - 0.5) * 2.0;
                double offsetY = level.random.nextDouble() * 2.0;
                double offsetZ = (level.random.nextDouble() - 0.5) * 2.0;
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, pos.x + offsetX, pos.y + offsetY, pos.z + offsetZ, 0.0, 0.1, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.END_ROD, pos.x + offsetX, pos.y + offsetY, pos.z + offsetZ, (level.random.nextDouble() - 0.5) * 0.1, level.random.nextDouble() * 0.1, (level.random.nextDouble() - 0.5) * 0.1);
            }
            level.playLocalSound(pos.x, pos.y, pos.z, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.HOSTILE, 1.0f, 1.2f, false);
            this.elderGuardian.discard();
        }
    }

    private void dissolveGuardians(ClientLevel level) {
        for (Guardian guardian : this.guardians) {
            if (guardian == null || !guardian.isAlive()) continue;
            Vec3 pos = guardian.position();
            for (int i = 0; i < 20; ++i) {
                double offsetX = (level.random.nextDouble() - 0.5) * 1.5;
                double offsetY = level.random.nextDouble() * 1.5;
                double offsetZ = (level.random.nextDouble() - 0.5) * 1.5;
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, pos.x + offsetX, pos.y + offsetY, pos.z + offsetZ, 0.0, 0.05, 0.0);
            }
            guardian.discard();
        }
    }

    private void spawnWaterParticles(ClientLevel level, Vec3 pos) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = (level.random.nextDouble() - 0.5) * 1.5;
            double offsetY = level.random.nextDouble() * 1.5;
            double offsetZ = (level.random.nextDouble() - 0.5) * 1.5;
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, pos.x + offsetX, pos.y + offsetY, pos.z + offsetZ, 0.0, 0.05, 0.0);
        }
    }

    private void spawnBubbleParticles(ClientLevel level, Vec3 pos) {
        for (int i = 0; i < 3; ++i) {
            double offsetX = level.random.nextDouble() - 0.5;
            double offsetY = level.random.nextDouble();
            double offsetZ = level.random.nextDouble() - 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, pos.x + offsetX, pos.y + offsetY, pos.z + offsetZ, 0.0, 0.02, 0.0);
        }
    }
}

