/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.event;

import de.markusbordihn.cookiescandyandcakes.config.MonsterLootConfig;
import de.markusbordihn.cookiescandyandcakes.data.candies.CandyType;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.registry.ModItems;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MonsterLootHandler {
    private static final int REFRESH_INTERVAL = 100;
    private static List<Item> cachedWeightedItems = null;
    private static int callsSinceLastRefresh = 0;

    private MonsterLootHandler() {
    }

    public static boolean shouldDropSpecialCookies(Entity entity) {
        if (!(entity instanceof Monster)) {
            return false;
        }
        float dropChance = (float)MonsterLootConfig.globalDropChance / 100.0f;
        return entity.level().getRandom().nextFloat() < dropChance;
    }

    private static List<Item> buildWeightedItemList() {
        int i;
        Item item;
        int weight;
        ArrayList<Item> weightedItems = new ArrayList<Item>();
        for (CookieType cookieType : CookieType.values()) {
            if (cookieType.getVariant() != CookieType.CookieVariant.MYSTIC && cookieType.getVariant() != CookieType.CookieVariant.CURSED) continue;
            weight = MonsterLootConfig.getCookieDropWeight(cookieType);
            item = MonsterLootHandler.getCookieItem(cookieType);
            if (item == null) continue;
            for (i = 0; i < weight; ++i) {
                weightedItems.add(item);
            }
        }
        for (Enum enum_ : CandyType.values()) {
            if (((CandyType)enum_).getVariant() != CandyType.CandyVariant.MYSTIC && ((CandyType)enum_).getVariant() != CandyType.CandyVariant.CURSED) continue;
            weight = MonsterLootConfig.getCandyDropWeight((CandyType)enum_);
            item = MonsterLootHandler.getCandyItem((CandyType)enum_);
            if (item == null) continue;
            for (i = 0; i < weight; ++i) {
                weightedItems.add(item);
            }
        }
        return weightedItems;
    }

    private static Item getCookieItem(CookieType cookieType) {
        try {
            String fieldName = cookieType.name();
            Field field = ModItems.class.getDeclaredField(fieldName);
            return (Item)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Item getCandyItem(CandyType candyType) {
        try {
            String fieldName = candyType.name();
            Field field = ModItems.class.getDeclaredField(fieldName);
            return (Item)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ItemStack getRandomSpecialCookie(Entity entity) {
        if (cachedWeightedItems == null || ++callsSinceLastRefresh >= 100) {
            cachedWeightedItems = MonsterLootHandler.buildWeightedItemList();
            callsSinceLastRefresh = 0;
        }
        if (cachedWeightedItems.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Item item = cachedWeightedItems.get(entity.level().getRandom().nextInt(cachedWeightedItems.size()));
        return new ItemStack((ItemLike)item);
    }

    public static ItemEntity createSpecialCookieDrop(Entity entity) {
        return new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), MonsterLootHandler.getRandomSpecialCookie(entity));
    }
}

