/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.data.cookies;

import de.markusbordihn.cookiescandyandcakes.config.CookieConfig;
import java.util.Locale;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_6880;

public enum CookieType {
    APPLE_COOKIE(CookieVariant.NORMAL, null, 0),
    APPLE_COOKIE_MYSTIC(CookieVariant.MYSTIC, (class_6880<class_1291>)class_1294.field_5898, 0),
    APPLE_COOKIE_CURSED(CookieVariant.CURSED, (class_6880<class_1291>)class_1294.field_5899, 0),
    CARROT_COOKIE(CookieVariant.NORMAL, null, 0),
    CARROT_COOKIE_MYSTIC(CookieVariant.MYSTIC, (class_6880<class_1291>)class_1294.field_5925, 0),
    CARROT_COOKIE_CURSED(CookieVariant.CURSED, (class_6880<class_1291>)class_1294.field_5919, 0),
    GLOW_BERRY_COOKIE(CookieVariant.NORMAL, null, 0),
    GLOW_BERRY_COOKIE_MYSTIC(CookieVariant.MYSTIC, (class_6880<class_1291>)class_1294.field_5912, 0),
    GLOW_BERRY_COOKIE_CURSED(CookieVariant.CURSED, (class_6880<class_1291>)class_1294.field_38092, 0),
    MELON_COOKIE(CookieVariant.NORMAL, null, 0),
    MELON_COOKIE_MYSTIC(CookieVariant.MYSTIC, (class_6880<class_1291>)class_1294.field_5924, 0),
    MELON_COOKIE_CURSED(CookieVariant.CURSED, (class_6880<class_1291>)class_1294.field_5920, 0),
    PUMPKIN_COOKIE(CookieVariant.NORMAL, null, 0),
    PUMPKIN_COOKIE_MYSTIC(CookieVariant.MYSTIC, (class_6880<class_1291>)class_1294.field_5907, 0),
    PUMPKIN_COOKIE_CURSED(CookieVariant.CURSED, (class_6880<class_1291>)class_1294.field_5911, 1),
    SWEET_BERRY_COOKIE(CookieVariant.NORMAL, null, 0),
    SWEET_BERRY_COOKIE_MYSTIC(CookieVariant.MYSTIC, (class_6880<class_1291>)class_1294.field_5913, 2),
    SWEET_BERRY_COOKIE_CURSED(CookieVariant.CURSED, (class_6880<class_1291>)class_1294.field_5909, 1),
    SLIME_SUGAR_COOKIE(CookieVariant.NORMAL, null, 0),
    SLIME_SUGAR_COOKIE_MYSTIC(CookieVariant.MYSTIC, (class_6880<class_1291>)class_1294.field_5913, 1),
    SLIME_SUGAR_COOKIE_CURSED(CookieVariant.CURSED, (class_6880<class_1291>)class_1294.field_5909, 0);

    private final CookieVariant variant;
    private final class_6880<class_1291> effect;
    private final int amplifier;
    private final String id;

    private CookieType(CookieVariant variant, class_6880<class_1291> effect, int amplifier) {
        this.variant = variant;
        this.effect = effect;
        this.amplifier = amplifier;
        this.id = this.name().toLowerCase(Locale.ROOT);
    }

    public String getId() {
        return this.id;
    }

    public CookieVariant getVariant() {
        return this.variant;
    }

    public class_6880<class_1291> getEffect() {
        return this.effect;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean hasEffect() {
        return this.effect != null;
    }

    public int getNutrition() {
        return CookieConfig.getNutrition(this);
    }

    public int getEffectDuration() {
        return CookieConfig.getEffectDuration(this);
    }

    public float getEffectChance() {
        return CookieConfig.getEffectChance(this);
    }

    public SpecialCookieEffect getSpecialCookieEffect() {
        return CookieConfig.getSpecialCookieEffect(this);
    }

    public static enum CookieVariant {
        NORMAL,
        MYSTIC,
        CURSED;

    }

    public record SpecialCookieEffect(float lightningChance, boolean enableSounds, float soundVolume, int darknessEffectDuration, String mysticSoundType, String cursedSoundType) {
        public static final SpecialCookieEffect NONE = new SpecialCookieEffect(0.0f, false, 0.0f, 0, "none", "none");
        public static final SpecialCookieEffect DEFAULT_MYSTIC = new SpecialCookieEffect(0.5f, true, 1.0f, 0, "levelup", "none");
        public static final SpecialCookieEffect DEFAULT_CURSED = new SpecialCookieEffect(0.5f, true, 4.0f, 60, "none", "ender_dragon");

        public boolean hasEffects() {
            return this.lightningChance > 0.0f || this.enableSounds;
        }
    }
}

