/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.effect;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.effect.CookieEffectInterface;
import de.markusbordihn.cookiescandyandcakes.effect.SlimeSugarCookieMysticEffect;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;

public class CookieEffectManager {
    private static final Map<CookieType, CookieEffectInterface> SPECIAL_EFFECTS = new HashMap<CookieType, CookieEffectInterface>();
    private static final Map<UUID, ActiveEffect> activeEffects = new HashMap<UUID, ActiveEffect>();

    private CookieEffectManager() {
    }

    public static void applyEffect(class_3222 player, CookieType cookieType) {
        if (player == null || cookieType == null) {
            return;
        }
        CookieEffectInterface effect = SPECIAL_EFFECTS.get((Object)cookieType);
        if (effect != null) {
            UUID playerUUID = player.method_5667();
            activeEffects.put(playerUUID, new ActiveEffect(effect, 0, effect.getDuration()));
            effect.onStart(player);
        }
    }

    public static void tick(class_3222 player) {
        if (player == null) {
            return;
        }
        UUID playerUUID = player.method_5667();
        ActiveEffect activeEffect = activeEffects.get(playerUUID);
        if (activeEffect != null) {
            activeEffect.tick(player);
            if (activeEffect.isExpired()) {
                activeEffect.effect.onEnd(player);
                activeEffects.remove(playerUUID);
            }
        }
    }

    public static void tickAll(Iterable<class_3222> players) {
        Iterator<class_3222> iterator = players.iterator();
        while (iterator.hasNext()) {
            CookieEffectManager.tick(iterator.next());
        }
    }

    public static void removeEffect(class_3222 player) {
        UUID playerUUID;
        ActiveEffect activeEffect;
        if (player != null && (activeEffect = activeEffects.remove(playerUUID = player.method_5667())) != null) {
            activeEffect.effect.onEnd(player);
        }
    }

    public static void clearAll() {
        activeEffects.clear();
    }

    static {
        SPECIAL_EFFECTS.put(CookieType.SLIME_SUGAR_COOKIE_MYSTIC, new SlimeSugarCookieMysticEffect());
    }

    static class ActiveEffect {
        private final CookieEffectInterface effect;
        private final int duration;
        private int elapsedTicks;

        public ActiveEffect(CookieEffectInterface effect, int elapsedTicks, int duration) {
            this.effect = effect;
            this.elapsedTicks = elapsedTicks;
            this.duration = duration;
        }

        public void tick(class_3222 player) {
            this.effect.tick(player, this.elapsedTicks);
            ++this.elapsedTicks;
        }

        public boolean isExpired() {
            return this.elapsedTicks >= this.duration;
        }
    }
}

