/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.config;

import de.markusbordihn.cookiescandyandcakes.config.Config;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;

public class CookieConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "cookies.cfg";
    public static final String CONFIG_FILE_HEADER = " Cookie Configuration\n\n This configuration file allows you to customize cookie properties per type.\n\n General Settings:\n - nutrition: Food points restored (default: 2)\n - effectDuration: Duration of potion effects in ticks (default: 600 = 30 seconds, 20 ticks = 1 second)\n - effectChance: Chance for potion effects to apply (0.0-1.0, default: 1.0 = 100%)\n\n Special Cookie Effects (for MYSTIC and CURSED variants):\n - specialEffect.lightningChance: Chance for lightning effect (0.0-1.0, default: 0.5 = 50%)\n - specialEffect.enableSounds: Enable dramatic sound effects (default: true)\n - specialEffect.soundVolume: Volume of sound effects (MYSTIC default: 1.0, CURSED default: 4.0)\n - specialEffect.enableDarknessEffect: Enable darkness effect for CURSED cookies (default: true, disable for epilepsy/photosensitivity)\n - specialEffect.darknessEffectDuration: Duration of darkness effect in ticks for CURSED cookies (default: 60 = 3 seconds)\n - specialEffect.mysticSoundType: Sound type for MYSTIC cookies (levelup, enchant, amethyst, bell, none; default: levelup)\n - specialEffect.cursedSoundType: Sound type for CURSED cookies (ender_dragon, wither, ambient_cave, sculk, none; default: ender_dragon)\n\n Available Sound Types:\n - MYSTIC: levelup, enchant, amethyst, bell, none\n - CURSED: ender_dragon, wither, ambient_cave, sculk, none\n\n Accessibility Note:\n - Set specialEffect.enableDarknessEffect to false if you have epilepsy or are sensitive to screen flashing/darkening effects\n\n You can configure these values globally or per cookie type by prefixing with the cookie type ID.\n Example: apple_cookie_mystic.nutrition = 3\n\n";
    private static final Map<CookieType, Integer> nutritionOverrides = new EnumMap<CookieType, Integer>(CookieType.class);
    private static final Map<CookieType, Integer> effectDurationOverrides = new EnumMap<CookieType, Integer>(CookieType.class);
    private static final Map<CookieType, Float> effectChanceOverrides = new EnumMap<CookieType, Float>(CookieType.class);
    private static int defaultNutrition = 2;
    private static int defaultEffectDuration = 600;
    private static float defaultEffectChance = 1.0f;
    private static float specialEffectLightningChance = 0.5f;
    private static boolean specialEffectEnableSounds = true;
    private static boolean specialEffectEnableDarknessEffect = true;
    private static float specialEffectMysticSoundVolume = 1.0f;
    private static float specialEffectCursedSoundVolume = 4.0f;
    private static int specialEffectDarknessEffectDuration = 60;
    private static String specialEffectMysticSoundType = "levelup";
    private static String specialEffectCursedSoundType = "ender_dragon";

    public static void registerConfig() {
        CookieConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        CookieConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = CookieConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = CookieConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        defaultNutrition = CookieConfig.parseConfigValue(properties, "nutrition", defaultNutrition);
        defaultEffectDuration = CookieConfig.parseConfigValue(properties, "effectDuration", defaultEffectDuration);
        defaultEffectChance = CookieConfig.parseConfigValue(properties, "effectChance", defaultEffectChance);
        specialEffectLightningChance = CookieConfig.parseConfigValue(properties, "specialEffect.lightningChance", specialEffectLightningChance);
        specialEffectEnableSounds = CookieConfig.parseConfigValue(properties, "specialEffect.enableSounds", specialEffectEnableSounds);
        specialEffectEnableDarknessEffect = CookieConfig.parseConfigValue(properties, "specialEffect.enableDarknessEffect", specialEffectEnableDarknessEffect);
        specialEffectMysticSoundVolume = CookieConfig.parseConfigValue(properties, "specialEffect.mysticSoundVolume", specialEffectMysticSoundVolume);
        specialEffectCursedSoundVolume = CookieConfig.parseConfigValue(properties, "specialEffect.cursedSoundVolume", specialEffectCursedSoundVolume);
        specialEffectDarknessEffectDuration = CookieConfig.parseConfigValue(properties, "specialEffect.darknessEffectDuration", specialEffectDarknessEffectDuration);
        specialEffectMysticSoundType = CookieConfig.parseConfigValue(properties, "specialEffect.mysticSoundType", specialEffectMysticSoundType);
        specialEffectCursedSoundType = CookieConfig.parseConfigValue(properties, "specialEffect.cursedSoundType", specialEffectCursedSoundType);
        nutritionOverrides.clear();
        effectDurationOverrides.clear();
        effectChanceOverrides.clear();
        for (CookieType type : CookieType.values()) {
            String prefix = type.getId() + ".";
            if (properties.containsKey(prefix + "nutrition")) {
                nutritionOverrides.put(type, CookieConfig.parseConfigValue(properties, prefix + "nutrition", defaultNutrition));
            }
            if (properties.containsKey(prefix + "effectDuration")) {
                effectDurationOverrides.put(type, CookieConfig.parseConfigValue(properties, prefix + "effectDuration", defaultEffectDuration));
            }
            if (!properties.containsKey(prefix + "effectChance")) continue;
            effectChanceOverrides.put(type, Float.valueOf(CookieConfig.parseConfigValue(properties, prefix + "effectChance", defaultEffectChance)));
        }
        CookieConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static int getNutrition(CookieType type) {
        return nutritionOverrides.getOrDefault((Object)type, defaultNutrition);
    }

    public static int getEffectDuration(CookieType type) {
        return effectDurationOverrides.getOrDefault((Object)type, defaultEffectDuration);
    }

    public static float getEffectChance(CookieType type) {
        return effectChanceOverrides.getOrDefault((Object)type, Float.valueOf(defaultEffectChance)).floatValue();
    }

    public static CookieType.SpecialCookieEffect getSpecialCookieEffect(CookieType type) {
        if (type.getVariant() == CookieType.CookieVariant.MYSTIC) {
            return new CookieType.SpecialCookieEffect(specialEffectLightningChance, specialEffectEnableSounds, specialEffectMysticSoundVolume, 0, specialEffectMysticSoundType, "none");
        }
        if (type.getVariant() == CookieType.CookieVariant.CURSED) {
            return new CookieType.SpecialCookieEffect(specialEffectLightningChance, specialEffectEnableSounds, specialEffectCursedSoundVolume, specialEffectEnableDarknessEffect ? specialEffectDarknessEffectDuration : 0, "none", specialEffectCursedSoundType);
        }
        return CookieType.SpecialCookieEffect.NONE;
    }
}

