/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.item.variants;

import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieSoundType;
import de.markusbordihn.cookiescandyandcakes.data.cookies.CookieType;
import de.markusbordihn.cookiescandyandcakes.item.base.BaseSpecialCookie;
import de.markusbordihn.cookiescandyandcakes.item.base.IdentifiableCookie;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class CursedCookie
extends BaseSpecialCookie
implements IdentifiableCookie {
    public CursedCookie(CookieType cookieType) {
        super(cookieType);
    }

    @Override
    public CookieType getCookieType() {
        return this.cookieType;
    }

    @Override
    public class_1799 method_7861(class_1799 itemStack, class_1937 level, class_1309 entity) {
        if (!level.field_9236) {
            this.applySpecialEffects(level, entity);
        }
        return super.method_7861(itemStack, level, entity);
    }

    private void applySpecialEffects(class_1937 level, class_1309 entity) {
        CookieType.SpecialCookieEffect effect = this.cookieType.getSpecialCookieEffect();
        if (!effect.hasEffects()) {
            return;
        }
        this.spawnLightningIfNeeded(level, entity, effect);
        this.playSoundIfEnabled(level, entity, effect);
        this.applyDarknessIfNeeded(entity, effect);
    }

    private void spawnLightningIfNeeded(class_1937 level, class_1309 entity, CookieType.SpecialCookieEffect effect) {
        if (level.field_9229.method_43057() < effect.lightningChance()) {
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(level);
            if (lightning == null) {
                return;
            }
            lightning.method_24203(entity.method_23317(), entity.method_23318(), entity.method_23321());
            lightning.method_29498(true);
            level.method_8649((class_1297)lightning);
        }
    }

    private void playSoundIfEnabled(class_1937 level, class_1309 entity, CookieType.SpecialCookieEffect effect) {
        class_3414 sound;
        if (effect.enableSounds() && (sound = CookieSoundType.getCursedSound(effect.cursedSoundType())) != null) {
            level.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, class_3419.field_15248, effect.soundVolume(), CookieSoundType.getPitch(effect.cursedSoundType(), level.field_9229.method_43057()));
        }
    }

    private void applyDarknessIfNeeded(class_1309 entity, CookieType.SpecialCookieEffect effect) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (effect.darknessEffectDuration() > 0) {
                player.method_6092(new class_1293(class_1294.field_38092, effect.darknessEffectDuration(), 0, false, false, false));
            }
        }
    }
}

