/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.config;

import de.markusbordihn.cookiescandyandcakes.config.Config;
import java.io.File;
import java.util.Properties;

public class MonsterLootConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "monster_loot.cfg";
    public static final String CONFIG_FILE_HEADER = " Monster Loot Configuration\n\n This configuration file allows you to define drop chances for candy crumbs from monsters.\n Drop chances are in percentage (0-100). Set to 0 to disable drops for that item.\n The global drop chance determines if ANY candy crumb will drop (25% default).\n\n";
    public static int globalDropChance = 25;
    public static int appleCookieMysticDropWeight = 1;
    public static int appleCookieCursedDropWeight = 1;
    public static int carrotCookieMysticDropWeight = 1;
    public static int carrotCookieCursedDropWeight = 1;
    public static int glowBerryCookieMysticDropWeight = 1;
    public static int glowBerryCookieCursedDropWeight = 1;
    public static int melonCookieMysticDropWeight = 1;
    public static int melonCookieCursedDropWeight = 1;
    public static int pumpkinCookieMysticDropWeight = 1;
    public static int pumpkinCookieCursedDropWeight = 1;
    public static int sweetBerryCookieMysticDropWeight = 1;
    public static int sweetBerryCookieCursedDropWeight = 1;
    public static int slimeSugarCookieMysticDropWeight = 1;
    public static int slimeSugarCookieCursedDropWeight = 1;

    public static void registerConfig() {
        MonsterLootConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MonsterLootConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MonsterLootConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MonsterLootConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        globalDropChance = MonsterLootConfig.parseConfigValue(properties, "globalDropChance", globalDropChance);
        appleCookieMysticDropWeight = MonsterLootConfig.parseConfigValue(properties, "appleCookieMysticDropWeight", appleCookieMysticDropWeight);
        appleCookieCursedDropWeight = MonsterLootConfig.parseConfigValue(properties, "appleCookieCursedDropWeight", appleCookieCursedDropWeight);
        carrotCookieMysticDropWeight = MonsterLootConfig.parseConfigValue(properties, "carrotCookieMysticDropWeight", carrotCookieMysticDropWeight);
        carrotCookieCursedDropWeight = MonsterLootConfig.parseConfigValue(properties, "carrotCookieCursedDropWeight", carrotCookieCursedDropWeight);
        glowBerryCookieMysticDropWeight = MonsterLootConfig.parseConfigValue(properties, "glowBerryCookieMysticDropWeight", glowBerryCookieMysticDropWeight);
        glowBerryCookieCursedDropWeight = MonsterLootConfig.parseConfigValue(properties, "glowBerryCookieCursedDropWeight", glowBerryCookieCursedDropWeight);
        melonCookieMysticDropWeight = MonsterLootConfig.parseConfigValue(properties, "melonCookieMysticDropWeight", melonCookieMysticDropWeight);
        melonCookieCursedDropWeight = MonsterLootConfig.parseConfigValue(properties, "melonCookieCursedDropWeight", melonCookieCursedDropWeight);
        pumpkinCookieMysticDropWeight = MonsterLootConfig.parseConfigValue(properties, "pumpkinCookieMysticDropWeight", pumpkinCookieMysticDropWeight);
        pumpkinCookieCursedDropWeight = MonsterLootConfig.parseConfigValue(properties, "pumpkinCookieCursedDropWeight", pumpkinCookieCursedDropWeight);
        sweetBerryCookieMysticDropWeight = MonsterLootConfig.parseConfigValue(properties, "sweetBerryCookieMysticDropWeight", sweetBerryCookieMysticDropWeight);
        sweetBerryCookieCursedDropWeight = MonsterLootConfig.parseConfigValue(properties, "sweetBerryCookieCursedDropWeight", sweetBerryCookieCursedDropWeight);
        slimeSugarCookieMysticDropWeight = MonsterLootConfig.parseConfigValue(properties, "slimeSugarCookieMysticDropWeight", slimeSugarCookieMysticDropWeight);
        slimeSugarCookieCursedDropWeight = MonsterLootConfig.parseConfigValue(properties, "slimeSugarCookieCursedDropWeight", slimeSugarCookieCursedDropWeight);
        MonsterLootConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

