/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.cookiescandyandcakes.event;

import de.markusbordihn.cookiescandyandcakes.config.MonsterLootConfig;
import de.markusbordihn.cookiescandyandcakes.data.loot.ItemWeight;
import de.markusbordihn.cookiescandyandcakes.registry.ModItems;
import java.util.ArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MonsterLootHandler {
    private static final ItemWeight[] SPECIAL_COOKIE_ITEMS_WITH_WEIGHTS = new ItemWeight[]{new ItemWeight(ModItems.APPLE_COOKIE_MYSTIC, () -> MonsterLootConfig.appleCookieMysticDropWeight), new ItemWeight(ModItems.APPLE_COOKIE_CURSED, () -> MonsterLootConfig.appleCookieCursedDropWeight), new ItemWeight(ModItems.CARROT_COOKIE_MYSTIC, () -> MonsterLootConfig.carrotCookieMysticDropWeight), new ItemWeight(ModItems.CARROT_COOKIE_CURSED, () -> MonsterLootConfig.carrotCookieCursedDropWeight), new ItemWeight(ModItems.GLOW_BERRY_COOKIE_MYSTIC, () -> MonsterLootConfig.glowBerryCookieMysticDropWeight), new ItemWeight(ModItems.GLOW_BERRY_COOKIE_CURSED, () -> MonsterLootConfig.glowBerryCookieCursedDropWeight), new ItemWeight(ModItems.MELON_COOKIE_MYSTIC, () -> MonsterLootConfig.melonCookieMysticDropWeight), new ItemWeight(ModItems.MELON_COOKIE_CURSED, () -> MonsterLootConfig.melonCookieCursedDropWeight), new ItemWeight(ModItems.PUMPKIN_COOKIE_MYSTIC, () -> MonsterLootConfig.pumpkinCookieMysticDropWeight), new ItemWeight(ModItems.PUMPKIN_COOKIE_CURSED, () -> MonsterLootConfig.pumpkinCookieCursedDropWeight), new ItemWeight(ModItems.SWEET_BERRY_COOKIE_MYSTIC, () -> MonsterLootConfig.sweetBerryCookieMysticDropWeight), new ItemWeight(ModItems.SWEET_BERRY_COOKIE_CURSED, () -> MonsterLootConfig.sweetBerryCookieCursedDropWeight), new ItemWeight(ModItems.SLIME_SUGAR_COOKIE_MYSTIC, () -> MonsterLootConfig.slimeSugarCookieMysticDropWeight), new ItemWeight(ModItems.SLIME_SUGAR_COOKIE_CURSED, () -> MonsterLootConfig.slimeSugarCookieCursedDropWeight)};

    private MonsterLootHandler() {
    }

    public static boolean shouldDropSpecialCookies(Entity entity) {
        if (!(entity instanceof Monster)) {
            return false;
        }
        float dropChance = (float)MonsterLootConfig.globalDropChance / 100.0f;
        return entity.level().getRandom().nextFloat() < dropChance;
    }

    public static ItemStack getRandomSpecialCookie(Entity entity) {
        ArrayList<Item> weightedItems = new ArrayList<Item>();
        for (ItemWeight itemWeight : SPECIAL_COOKIE_ITEMS_WITH_WEIGHTS) {
            int weight = itemWeight.weightSupplier().getAsInt();
            for (int i = 0; i < weight; ++i) {
                weightedItems.add(itemWeight.item());
            }
        }
        if (weightedItems.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Item item = (Item)weightedItems.get(entity.level().getRandom().nextInt(weightedItems.size()));
        return new ItemStack((ItemLike)item);
    }

    public static ItemEntity createSpecialCookieDrop(Entity entity) {
        return new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), MonsterLootHandler.getRandomSpecialCookie(entity));
    }
}

